package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.enums.*;
import com.ejianc.business.pro.rmat.service.IContractAsyncService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Service("contract") 
public class ContractBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IContractService service;

	@Autowired
	private IContractAsyncService contractAsyncService;

	@Autowired
	ISignatureCommonApi signatureCommonApi;

	@Autowired
	private IParamConfigApi paramConfigApi;

	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		
		/*
			起草方式为线下签订则不需要签章
			当不使用电子签章时：创建时默认为未签章，单据审批通过后自动更改为【已签章】
			当签章状态变为【已签章】时，合同状态变为【履约中】
		 */
		ContractEntity entity = service.selectById(billId);
		if (entity != null){
			if((DraftTypeEnum.线上起草.getCode()).equals(entity.getDraftType()) && (null == entity.getContractFileId())) {
				// 确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
		}
		
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		ContractEntity e = service.selectById(billId);
		if(DraftTypeEnum.线上起草.getCode().equals(e.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().equals(e.getDraftType())) {
			if(null == e.getContractFileId()) {
				//确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
			if(!e.getContractFileSyncFlag()) {
				return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		ContractEntity e = service.selectById(billId);
		logger.info("审批节点审批中时节点审批前回调:  当前数据-{}", JSONObject.toJSONString(e));
		//线上起草且文件未同步
		if((DraftTypeEnum.线上起草.getCode().equals(e.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().equals(e.getDraftType())) && !e.getContractFileSyncFlag()) {
			return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
		}
		return CommonResponse.success("审批处理成功！");
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		
		/*
			起草方式为线下签订则不需要签章
			当不使用电子签章时：创建时默认为未签章，单据审批通过后自动更改为【已签章】
			当签章状态变为【已签章】时，合同状态变为【履约中】
		 */
		ContractEntity entity = service.selectById(billId);
		if (entity != null){
			if((DraftTypeEnum.线下签订.getCode()).equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().equals(entity.getDraftType()) ) {
				// 线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
				entity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
				entity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
			} 

			if((DraftTypeEnum.线上起草.getCode()).equals(entity.getDraftType()) && (null == entity.getContractFileId())) {
				// 确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}

			if(DraftTypeEnum.线上起草.getCode().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().equals(entity.getDraftType())) {
				if(null == entity.getContractFileId()) {
					//确保线上起草方式时，用户已编辑合同文件
					return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
				}
				if(!entity.getContractFileSyncFlag()) {
					return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
				}
			}
		}
		
		// 推送供方
		Boolean pushResult = service.pushBillToSupCenter(entity);
		if(pushResult) {
			entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		}else {
			logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.周转材租赁合同.getName(), billId);
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		
		// 推送合同池
		Boolean pushResult2 = service.pushContract(BeanMapper.map(entity, ContractVO.class));
		if(pushResult2) {
			entity.setPushPoolFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			entity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
		}

		// 水印系统参数
		CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
		if (!response.isSuccess() || response.getData() == null) {
			throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
		}
		String valueData = response.getData().getValueData();
		Assert.hasText(valueData, "获取的水印系统参数不能为空!");

		// 是否限制： 0:不限制，1:限制
		if ("0".equals(valueData)) {
			// 转换水印参数配置：默认规则
			WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(entity.getContractFileId(), entity.getId(),
					entity.getBillCode(), BillTypeEnum.周转材租赁合同.getCode(), "prormatContract");
			Assert.notNull(watermarkVO, "获取水印系统参数失败!");
			// 获取上下文并异步调用添加水印
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			HashMap<String, String> headers = new HashMap<>();
			headers.put("authority", request.getHeader("authority"));
			headers.put("ejc-token", request.getHeader("ejc-token"));
			contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
		}
		//合同文件检查
		checkContractFile(entity);
		service.saveOrUpdate(entity);
		
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /*
			弃审逻辑：
			1、审批过程中，支持后台弃审；
			2、当审批通过，且没有走签章流程且没有下游业务时，支持后台弃审；
		 */
		ContractEntity contractEntitiy = service.selectById(billId);

		// 审批可以撤回的签章状态集合
		List<Integer> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		//使用电子签章且已有签章流程则不允许撤回
		if(DraftTypeEnum.线上起草.getCode().equals(contractEntitiy.getDraftType()) || DraftTypeEnum.上传合同.getCode().equals(contractEntitiy.getDraftType())) {
			if (!statusList.contains(contractEntitiy.getSignatureStatus())){
				return CommonResponse.error("当前单据已有签章流程，不能撤回！");
			}
		}else if(SignatureStatusEnum.已签章.getCode().equals(contractEntitiy.getSignatureStatus())) {
			contractEntitiy.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
		}

		if(PerformanceStatusEnum.履约中.getCode().equals(contractEntitiy.getPerformanceStatus())) {
			contractEntitiy.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());
		}

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		// 将推送至供方的单据作废
		if (BillPushStatusEnum.推送成功.getStatus().equals(contractEntitiy.getBillPushFlag())) {
			boolean pushResult = service.delPushBill(contractEntitiy);
			if (!pushResult) {
				return CommonResponse.error("弃审回调失败，单据作废协同服务失败！");
			}
		}

		// TO DO 已生效单据的 归档状态 /从合同池删除，删除失败抛异常
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntitiy.getBillState()) ||
				BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntitiy.getBillState())) {
			// 从合同池删除数据
			boolean delResult = service.delContractFromPool(contractEntitiy.getId());
			if(delResult) {
				contractEntitiy.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			} else {
				logger.error("单据-【{}】从合同池删除失败！", JSONObject.toJSONString(contractEntitiy));
				return CommonResponse.error("操作失败，单据从合同池删除失败！");
			}

			//若合同属于自动归档的，则将其归档状态改为未归档
			if(DraftTypeEnum.线上起草.getCode().equals(contractEntitiy.getDraftType()) || DraftTypeEnum.上传合同.equals(contractEntitiy.getDraftType())) {
				contractEntitiy.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
			}
		}

		// 删除文件中心水印文件
		if(contractEntitiy.getWatermarkContractFileId() != null) {
			boolean delWatermarkflag = service.delWatermarkContractFile(contractEntitiy.getWatermarkContractFileId());
			if (delWatermarkflag) {
				contractEntitiy.setWatermarkContractFileId(null);
			}
		}

		service.saveOrUpdate(contractEntitiy, false);

		return CommonResponse.success("弃审/撤回前校验回调成功！");
		
	}

	/**
	 * 检查合同文件
	 *
	 * @param contractEntity
	 */
	private void checkContractFile(ContractEntity contractEntity) {
		//查询合同对饮附件是否存在
		CommonResponse<AttachmentVO> attachResp = attachmentApi.queryDetail(contractEntity.getContractFileId().toString());
		if(!attachResp.isSuccess() || null == attachResp.getData()) {
			logger.info("合同存储文件Id-{}在文件中心不存在，根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息",
					contractEntity.getContractFileId(),
					contractEntity.getId(),
					("2".equals(contractEntity.getDraftType()) || "3".equals(contractEntity.getDraftType())) ? "rmatContractFile" : "contractFile",
					BillTypeEnum.周转材租赁合同.getCode());
			//合同附件不存在，根据合同Id、业务类型、查询是否存在对应的文件信息，若存在则更新到合同中，否则抛出异常
			CommonResponse<List<AttachmentVO>> attachListResp = attachmentApi.queryListBySourceId(contractEntity.getId(),
					BillTypeEnum.周转材租赁合同.getCode(),
					("2".equals(contractEntity.getDraftType()) || "3".equals(contractEntity.getDraftType())) ? "rmatContractFile" : "contractFile", "desc");

			logger.info("根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息结果：{}",
					contractEntity.getId(),
					("2".equals(contractEntity.getDraftType()) || "3".equals(contractEntity.getDraftType())) ? "rmatContractFile" : "contractFile",
					BillTypeEnum.周转材租赁合同.getCode(),
					JSONObject.toJSONString(attachListResp));
			if(attachListResp.isSuccess() || CollectionUtils.isEmpty(attachListResp.getData())) {
				AttachmentVO attachmentVO = attachListResp.getData().get(0);
				logger.info("将合同id-{}对应合同文件Id-{}改为{}", contractEntity.getId(), contractEntity.getContractFileId(), attachmentVO.getId());
				contractEntity.setContractFileId(attachmentVO.getId());
				contractEntity.setContractFilePath(attachmentVO.getTruePath());
			} else {
				throw new BusinessException("审批失败，获取合同文件信息失败, 请检查合同文件！");
			}
		}
	}


	@Override
	public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
		ContractEntity e = service.selectById(billId);
		List<ParamsCheckVO> paramsCheckVO = service.historyPriceCtrlContractPrice(BeanMapper.map(e, ContractVO.class));
		JSONObject object = new JSONObject();
		if(paramsCheckVO.size() > 0 && paramsCheckVO.get(0).getDataSource().size() > 0){
			logger.info("单价异常");
			object.put("priceFlag","是");//是单价异常
		}else{
			logger.info("单价正常");
			object.put("priceFlag","否");//否 单价异常
		}
		return CommonResponse.success(object);
	}
}
