package com.ejianc.business.prosub.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包合同单据类型枚举
 *
 * @author CJ
 * @Description:
 * @date 2022/3/3 16:16
 */
public enum ProsubBillTypeEnum {

    劳务分包合同("劳务分包合同", "BT211108000000002"),
    专业分包合同("专业分包合同", "BT220216000000003"),

    劳务分包合同解除("劳务分包合同解除", "BT211230000000005"),
    专业分包合同解除("专业分包合同解除", "EJCBT202205000030"),

    劳务分包合同变更("劳务分包合同变更", "BT211108000000003"),
    专业分包合同变更("专业分包合同变更", "BT220216000000004"),

    劳务分包合同记录("劳务分包合同记录", "BT211108000000004"),
    专业分包合同记录("专业分包合同记录", "BT220216000000005"),

    劳务分包合同过程结算("劳务分包合同过程结算", "BT220114000000002"),
    专业分包合同过程结算("专业分包合同过程结算", "BT220307000000007"),

    劳务分包合同节点结算("劳务分包合同节点结算", "BT220114000000003"),
    专业分包合同节点结算("专业分包合同节点结算", "BT220307000000008"),

    劳务分包合同完工结算("劳务分包合同完工结算", "BT220114000000004"),
    专业分包合同完工结算("专业分包合同完工结算", "BT220307000000009"),

    劳务分包总计划("劳务分包总计划", "BT220113000000003"),
    专业分包总计划("专业分包总计划", "EJCBT202205000053"),

    劳务分包总计划变更("劳务分包总计划变更", "BT220113000000004"),
    专业分包总计划变更("专业分包总计划变更", "EJCBT202205000054");

    ProsubBillTypeEnum(String billTypeName, String billTypeCode) {
        this.billTypeName = billTypeName;
        this.billTypeCode = billTypeCode;
    }

    private String billTypeName;
    private String billTypeCode;
    private static Map<String, ProsubBillTypeEnum> enumMap = new HashMap();

    public String getBillTypeName() {
        return billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    public static ProsubBillTypeEnum getByCode(String code) {
        return enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(ProsubBillTypeEnum.class).stream().collect(Collectors.toMap(ProsubBillTypeEnum::getBillTypeCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
