package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.PlanDetailChangeVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("planChange") 
public class PlanChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IPlanService masterPlanService;

	@Autowired
	private IPlanDetailService masterPlanDetailService;

	@Autowired
	private IPlanChangeService masterPlanChangeService;

	@Autowired
	private IPlanChangeHisService masterPlanChangeHisService;

	@Autowired
	private IPlanDetailChangeHisService planDetailChangeHisService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("总计划变更审批完成回调处理：billId: {}, state: {}", billId, state);

		PlanChangeEntity planChange = masterPlanChangeService.selectById(billId);
		PlanEntity newPlanEntity = null;
		PlanEntity oldPlan = masterPlanService.selectById(planChange.getSourcePlanId());

		//设置总计划变更单据生效时间
		planChange.setEffectiveDate(new Date());

		//1、复制合同信息到合同记录
		PlanChangeHisEntity recordEntity = BeanMapper.map(oldPlan, PlanChangeHisEntity.class);
		logger.info("总计划变更审批完成回调, 总计划变更信息：【{}】, 变更前总计划信息: 【{}】", JSON.toJSONString(planChange), JSON.toJSONString(oldPlan));

		//设置总计划Id
		recordEntity.setSourcePlanId(oldPlan.getId());
		//Id置为空
		recordEntity.setId(null);
		if(CollectionUtils.isNotEmpty(recordEntity.getPlanDetailList())) {
			recordEntity.getPlanDetailList().stream().forEach(detail -> {
				detail.setTargetId(detail.getId());
				detail.setId(null);
			});
		}

		//设置编制人等信息
		recordEntity.setCreateUserCode(planChange.getCreateUserCode());
		recordEntity.setCreateTime(planChange.getCreateTime());
		recordEntity.setCreateUserName(planChange.getCreateUserName());
		recordEntity.setModifyUserName(planChange.getModifyUserName());
		recordEntity.setUpdateTime(planChange.getUpdateTime());
		recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
		recordEntity.setEffectiveDate(planChange.getEffectiveDate());

		recordEntity.setOriginalPlanTaxMny(oldPlan.getTotalPlanTaxMny());
		recordEntity.setOriginalPlanMny(oldPlan.getTotalPlanMny());
		recordEntity.setTotalPlanTaxMny(planChange.getTotalPlanTaxMny());
		recordEntity.setTotalPlanMny(planChange.getTotalPlanMny());
		recordEntity.setChangePlanId(oldPlan.getChangeId());

		recordEntity.setChangeUserName(planChange.getChangeUserName());
		recordEntity.setChangeReason(planChange.getChangeReason());
		if(null == recordEntity.getTotalPlanTaxMny()) {
			recordEntity.setTotalPlanTaxMny(BigDecimal.ZERO.setScale(8));
		}
		if(null == recordEntity.getTotalPlanMny()) {
			recordEntity.setTotalPlanMny(BigDecimal.ZERO.setScale(8));
		}
		if(null == recordEntity.getOriginalPlanTaxMny()) {
			recordEntity.setOriginalPlanTaxMny(BigDecimal.ZERO.setScale(8));
		}
		if(null == recordEntity.getOriginalPlanMny()) {
			recordEntity.setOriginalPlanMny(BigDecimal.ZERO.setScale(8));
		}
		recordEntity.setChangeMny(recordEntity.getTotalPlanTaxMny().subtract(recordEntity.getOriginalPlanTaxMny()));
		if(recordEntity.getOriginalPlanTaxMny().compareTo(BigDecimal.ZERO) == 0) {
			recordEntity.setChangeRatio(new BigDecimal("0"));
		} else {
			recordEntity.setChangeRatio(recordEntity.getChangeMny().divide(recordEntity.getOriginalPlanTaxMny(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP));
		}

		//总计划变更记录保存
		masterPlanChangeHisService.saveOrUpdate(recordEntity, false);
		//更新变更记录表中末级的的parentId,根据从主表带过来的parentId查询当前父级的主键Id 赋值给当前末级  begin
		recordEntity.getPlanDetailList().forEach((item)->{
			if(item.getParentId()!=null){
				QueryWrapper<PlanDetailChangeHisEntity> query = new QueryWrapper<>();
				query.eq("target_id", item.getParentId());
				query.eq("plan_id", item.getPlanId());
				PlanDetailChangeHisEntity one = planDetailChangeHisService.getOne(query);
				if(one!=null){
					item.setParentId(one.getId());
				}
			}
		});
		masterPlanChangeHisService.saveOrUpdate(recordEntity, false);
		//更新变更记录表中末级的的parentId,根据从主表带过来的parentId查询当前父级的主键Id 赋值给当前末级  begin

		masterPlanChangeService.saveOrUpdate(planChange, false);

		//修改总计划字段
		newPlanEntity = BeanMapper.map(planChange, PlanEntity.class);
		//变更状态-已变更
		newPlanEntity.setChangeState(PlanVO.PLAN_CHANGE_STATE_CHANGED);

		//清空当前变更计划id
		newPlanEntity.setChangeId(null);
		//合同初始创建信息
		newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
		newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
		newPlanEntity.setCreateTime(oldPlan.getCreateTime());
		newPlanEntity.setId(oldPlan.getId());
		newPlanEntity.setVersion(oldPlan.getVersion());
		newPlanEntity.setChangeVersion(planChange.getChangeVersion());

		//子表信息设置
		List<Long> delDetailIds = new ArrayList<>();
		List<Long> notDelDetailIds = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(planChange.getPlanDetailList())) {
			List<PlanDetailEntity> list = new ArrayList<>();
			PlanDetailEntity tmp = null;
			Map<Long, PlanDetailEntity> map = oldPlan.getPlanDetailList().stream().collect(Collectors.toMap(PlanDetailEntity::getId, e -> e));
			List<PlanDetailEntity> oldList = oldPlan.getPlanDetailList();

			for(PlanDetailChangeEntity detail : planChange.getPlanDetailList()) {
				notDelDetailIds.add(detail.getTargetId());
				tmp = BeanMapper.map(detail, PlanDetailEntity.class);

				if(null != detail.getTargetId()) {
					tmp.setId(detail.getTargetId());
					tmp.setVersion(map.get(detail.getTargetId()).getVersion());
					if(PlanDetailChangeVO.CHANGE_TYPE_DEL.equals(detail.getChangeType().toString())) {
						//终止项删除
						delDetailIds.add(detail.getTargetId());
					} else {
						tmp.setRowState("edit");
						tmp.setId(tmp.getTargetId());
						for (PlanDetailEntity planDetail:oldList) {
							if(planDetail.getId().equals(tmp.getTargetId())){
								tmp.setParentId(planDetail.getParentId());
							}
						}
						list.add(tmp);
					}
				} else {
					tmp.setRowState("add");
					for (PlanDetailEntity planDetail:oldList) {
						if(planDetail.getSourceId().equals(tmp.getDocCategoryId())){
							tmp.setParentId(planDetail.getId());
							tmp.setTargetId(tmp.getId());
						}
					}
					list.add(tmp);
				}
			}
			newPlanEntity.setPlanDetailList(list);
		}

		//删除已有子表
        logger.info("计划变更单审批通过，待删除终止项：detailIds-{}", JSONObject.toJSONString(delDetailIds));
		if(CollectionUtils.isNotEmpty(delDetailIds) && oldPlan.getId() != null) {
			QueryWrapper<PlanDetailEntity> removeWrapper = new QueryWrapper<>();
			removeWrapper.eq("plan_id", oldPlan.getId());
			removeWrapper.in("id", delDetailIds);
			masterPlanDetailService.remove(removeWrapper);
		}
		List<PlanDetailEntity> masterPlanDetailList = newPlanEntity.getPlanDetailList();
		//根据更新后数据维护树形关系
		Map<String,Long> idMap=new HashMap<>();
		masterPlanDetailList.forEach(cdEntity ->{
			idMap.put(cdEntity.getTid(),cdEntity.getId());
		});

		masterPlanDetailList.forEach(cdEntity ->{
			if(StringUtils.isNotEmpty(cdEntity.getTpid())){
				cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
			}
		});
		newPlanEntity.setPlanDetailList(masterPlanDetailList);

		if(masterPlanService.saveOrUpdate(newPlanEntity, false)) {
			return CommonResponse.success("回调业务处理成功！");
		}
		return CommonResponse.success("回调业务处理失败！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		if(state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
			CommonResponse.success("有审批流程的变更总计划无法执行该操作！");
		}
		return CommonResponse.success("总计划变更弃审回调处理成功！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("总计划变更弃审回调处理：billId: {}, state: {}", billId, state);
		PlanChangeEntity planChange = masterPlanChangeService.selectById(billId);

		QueryWrapper<PlanChangeHisEntity> hisQuery = new QueryWrapper<>();
		hisQuery.eq("change_plan_id", billId);
		PlanChangeHisEntity hisEntity = masterPlanChangeHisService.getOne(hisQuery);

		if(null != hisEntity) {
			//数据恢复至审批完成前的数据状态
			PlanEntity newPlanEntity = null;
			PlanEntity oldPlan = masterPlanService.selectById(planChange.getSourcePlanId());

			logger.info("总计划执行弃审数据恢复逻辑，当前数据【{}】，待恢复数据【{}】", oldPlan, hisEntity);
			//数据恢复
			newPlanEntity = BeanMapper.map(hisEntity, PlanEntity.class);
			newPlanEntity.setChangeId(hisEntity.getChangePlanId());
			//恢复创建人等信息
			newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
			newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
			newPlanEntity.setCreateTime(oldPlan.getCreateTime());
			newPlanEntity.setId(oldPlan.getId());
			newPlanEntity.setVersion(oldPlan.getVersion());
			newPlanEntity.setChangeVersion(planChange.getChangeVersion());

			//变更状态-变更中
			newPlanEntity.setChangeState(PlanVO.PLAN_CHANGE_STATE_CHANGING);
			//总计划金额
			newPlanEntity.setTotalPlanTaxMny(hisEntity.getOriginalPlanTaxMny());
			//总计划金额无税
			newPlanEntity.setTotalPlanMny(hisEntity.getOriginalPlanMny());
			newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);

			//子表信息设置
			List<Long> delDetailIds = new ArrayList<>();
			if(CollectionUtils.isNotEmpty(planChange.getPlanDetailList())) {
				List<PlanDetailEntity> list = new ArrayList<>();
				PlanDetailEntity tmp = null;
				Map<Long, Integer> map = oldPlan.getPlanDetailList().stream().collect(Collectors.toMap(PlanDetailEntity::getId, PlanDetailEntity::getVersion));

				for(PlanDetailChangeEntity detail : planChange.getPlanDetailList()) {
					tmp = BeanMapper.map(detail, PlanDetailEntity.class);

					if(null != detail.getTargetId()) {
						tmp.setVersion(map.get(detail.getTargetId()));
						tmp.setId(detail.getTargetId());
						if(detail.getChangeType().equals(PlanDetailChangeVO.CHANGE_TYPE_ADD)) {
							//删除新增项
							delDetailIds.add(detail.getId());
						} else {
							list.add(tmp);
						}
					} else {
						//删除新增项
						delDetailIds.add(detail.getId());
					}
				}

				newPlanEntity.setPlanDetailList(list);
			}

			//删除已有子表
			if(CollectionUtils.isNotEmpty(delDetailIds)) {
				masterPlanDetailService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
			}

			//删除变更记录
			masterPlanChangeHisService.removeById(hisEntity.getId(), false);

			masterPlanService.saveOrUpdate(newPlanEntity, false);
		}

		if(masterPlanChangeService.saveOrUpdate(planChange, false)) {
			return CommonResponse.success("回调业务处理成功！");
		}
		return CommonResponse.success("总计划变更弃审回调处理成功！");
	}

}
