package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2022/3/5 11:27
 */
@RestController
@RequestMapping
public class SettleSignFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISignatureManageApi signatureManageApi;

    @Autowired
    private ISettleService settleService;

    /**
     * 完工结算附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "/finishSettleFileUpdate/updateFileInfo")
    public CommonResponse<JSONObject> updateFinishSignFileInfo(@RequestBody JSONObject updateData) {
        return updateSignFileInfo(updateData);
    }

    /**
     * 节点结算附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "/nodeSettleFileUpdate/updateFileInfo")
    public CommonResponse<JSONObject> updateNodeSignFileInfo(@RequestBody JSONObject updateData) {
        return updateSignFileInfo(updateData);
    }

    /**
     * 完工结算附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "/processSettleFileUpdate/updateFileInfo")
    public CommonResponse<JSONObject> updateProcessSettleFileInfo(@RequestBody JSONObject updateData) {
        return updateSignFileInfo(updateData);
    }




    private CommonResponse<JSONObject> updateSignFileInfo(JSONObject updateData) {
        JSONObject resp = new JSONObject();

        SettleEntity entity = settleService.selectById(updateData.getLong("billId"));
        entity.setContractFileId(updateData.getLong("fileId"));
        entity.setContractFileHighlightId(updateData.getLong("fileId"));
        entity.setContractFilePath(updateData.getString("fileOnlinePath"));
        entity.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));

        settleService.saveOrUpdate(entity, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", entity);
        return CommonResponse.success("合同文件信息更新成功！",resp);
    }

    /**
     * 获取节点结算签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType
     * @return
     */
    @GetMapping(value = "/nodeSettleFileUpdate/getSignedFileInfo")
    public CommonResponse<JSONObject> getNodeSettleSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {
        return getSignedFileInfo(billId);
    }
    /**
     * 获取过程结算签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType
     * @return
     */
    @GetMapping(value = "/processSettleFileUpdate/getSignedFileInfo")
    public CommonResponse<JSONObject> getProcessSettleSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {
        return getSignedFileInfo(billId);
    }
    /**
     * 获取完工结算签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType
     * @return
     */
    @GetMapping(value = "/finishSettleFileUpdate/getSignedFileInfo")
    public CommonResponse<JSONObject> getFinishSettleSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {
        return getSignedFileInfo(billId);
    }

    private CommonResponse<JSONObject> getSignedFileInfo(Long billId) {
        JSONObject resp = new JSONObject();
        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureManageApi.previewContract(billId,
                Arrays.asList(new String[]{SignatureStatusEnum.已签章.getCode()}));
        if(!signResp.isSuccess()) {
            logger.error("获取单据id-{}签章文件信息失败: {}", billId, signResp.getMsg());
            return CommonResponse.error("获取合同签章文件信息失败!");
        }

        List<SignMgrPreviewVO> fileList = signResp.getData();
        if(CollectionUtils.isEmpty(fileList)) {
            return CommonResponse.error("为获取到单据签章文件信息！");
        }

        SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
        SettleEntity entity = settleService.selectById(billId);
        entity.setSignedFileId(signedFileInfo.getFileId());
        settleService.saveOrUpdate(entity, false);


        resp.put("fileId", signedFileInfo.getFileId());
        resp.put("filePath", signedFileInfo.getFilePath());
        resp.put("fileTruePath", signedFileInfo.getTruePath());

        return CommonResponse.success("查询成功！", resp);
    }

}
