package com.ejianc.business.settle.service;

import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.vo.SettleDeductVO;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.store.vo.CheckVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public interface ISettleService extends IBaseService<SettleEntity> {

    CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType, Long changeId);

    Date queryMaxSettleDate(Long contractId);

    /**
     * 查询子表数据
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return SettleEntity
     */
    SettleEntity querySubTableList(Integer settleType, Long contractId, Date settleDate);

    /**
     * 查询 领料结算 累计过程结算金额
     *
     * @param contractId
     * @return
     */
    SettleVO selectPickingProcessTaxMny(Long contractId);

    /**
     * 查询 零工登记 累计过程结算金额
     *
     * @param contractId
     * @return
     */
    SettleVO selectOddjobProcessTaxMny(Long contractId);

    /**
     * 查询 奖罚扣款单 累计过程结算金额
     *
     * @param contractId
     * @return
     */
    List<SettleDeductVO> selectDeductList(Long contractId);

    /**
     * 查询 其他费用 累计过程结算金额
     *
     * @param contractId
     * @return
     */
    SettleVO selectOtherProcessTaxMny(Long contractId);

    /**
     * 单据推送到供方协同服务
     *
     * @param settleEntity 待推送单据
     * @param billTypeCode 待推送单据的单据类型编码
     * @param cooperate    待推送单据的协同配置信息
     * @return 推送结果
     */
    Boolean pushBillToSupCenter(SettleEntity settleEntity, String billTypeCode, CooperateVO cooperate);

    /**
     * 同步单据供供应商签字信息
     *
     * @param request 请求对象
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param settleEntity
     * @param billTypeCode
     * @return 推送结果
     */
    boolean delPushBill(SettleEntity settleEntity, String billTypeCode);

    /**
     * 单据删除前校验
     *
     * @param billIds 待删除单据Id列表
     * @return
     */
    String delCheck(List<Long> billIds);

    /**
     * 查询合同对应类型的结算记录
     *
     * @param contractId
     * @param settleType
     * @return
     */
    SettleRecordVO queryDetailRecord(Long contractId, Integer settleType);

    /**
     * 新增合同结算前校验
     *
     * @param contractId
     * @param settleType
     * @return
     */
    String beforeNewSettleCheck(Long contractId, Integer settleType);


    SettleVO queryTotalNodeAndFin(Long contractId, Long projectId);

    /**
     * 结算单转结算池
     *
     * @param s
     * @param spv
     */
    public void convertSettleVOToSettlePoolVO(SettleVO s, SettlePoolVO spv);

    /**
     * 更新单据结算池推送状态
     *
     * @param id   单据id
     * @param flag 是否成功推送
     */
    public void executeUpdatePool(Long id, Boolean flag);

    /**
     * 推送至结算池
     *
     * @param vo
     */
    String pushSettleToPool(SettleVO vo);

    /**
     * 从结算池中删除数据
     *
     * @param id
     * @return
     */
    String delSettleFromPool(Long id);

    ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType);


    /**
     * 获取含本期累计结算金额
     *
     * @param contractId 合同id
     * @param settleType 结算类型
     * @param taxMny     本期结算金额
     * @param flag       查看预警标识
     * @return 含本期累计结算金额
     */
    BigDecimal getLastTaxMny(Long contractId, Integer settleType, BigDecimal taxMny, Boolean flag);


    /**
     * 获取超结金额
     *
     * @param totalTaxMny    含本期累计结算金额
     * @param contractTaxMny 合同金额
     * @return 超结金额
     */
    BigDecimal getOverTaxMny(BigDecimal totalTaxMny, BigDecimal contractTaxMny);


    /**
     * 计算合同金额
     *
     * @param contractTaxMny 合同金额
     * @param roleValue      控制规则值
     * @return 合同金额
     */
    BigDecimal getContractTaxMny(BigDecimal contractTaxMny, BigDecimal roleValue);


    /**
     *  推送实际成本
     * @param settleEntity
     */
    void costPush(SettleEntity settleEntity);
    List<Long> autoPushCost(List<Long> ids);
    void costDeletePush(SettleEntity settleEntity);


    CommonResponse<SettleVO> pushCost(SettleVO settleVO);

    // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"approve"审批通过后，"back"撤回后
    boolean updateContractPoolTotalSettleMnyAfterSettle(SettleEntity se, String type);

    /**
     * 获取工人工资单平台 0：云南 1：一建
     * @return
     */
    String salaryParameterFlag();

    void fillOtherSettlePoolAttr(SettleEntity dbEntity, SettlePoolVO spv);

    /**
     * 通过合同id查询跟该合同有关的节点结算、支付比例确认单总数
     * @param contractId
     * @return
     */
    int queryContractSettleNumOfNode(Long contractId);
}
