package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.PicKingEntity;
import com.ejianc.business.process.bean.PicKingStoreEntity;
import com.ejianc.business.process.bean.PicKingTotalEntity;
import com.ejianc.business.process.bean.PickingEquipmentEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IPicKingStoreService;
import com.ejianc.business.process.service.IPicKingTotalService;
import com.ejianc.business.process.service.IPickingEquipmentService;
import com.ejianc.business.process.service.IPickingService;
import com.ejianc.business.process.vo.PicKingStoreVO;
import com.ejianc.business.process.vo.PicKingTotalVO;
import com.ejianc.business.process.vo.PicKingVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 专业分包领料结算
 *
 * @author ljl
 */
@RestController
@RequestMapping("picking")
public class PickingController {
    private static final String BILL_CODE = "PICK_S";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPickingService service;
    @Autowired
    private IPicKingStoreService storeService;
    @Autowired
    private IPicKingTotalService totalService;
    @Autowired
    private IAccountSettleApi accountSettleApi;
    @Autowired
    private IPickingEquipmentService equipmentService;
    private final String billTypeCode = "BT220117000000002";
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/picking/card";
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<PicKingVO> saveOrUpdate(@RequestBody PicKingVO saveorUpdateVO) {
        PicKingEntity entity = BeanMapper.map(saveorUpdateVO, PicKingEntity.class);
        if (entity.getId() == null) {
            CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveorUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置id
            entity.setId(IdWorker.getId());
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方未签字.getCode());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            entity.setBillCode(billCode.getData());
            //保存单据制单人Id
            entity.setCreateUserId(InvocationInfoProxy.getUserid());

            List<FlowVO> detail = new ArrayList<>();
            //设置子表id
            if (entity.getOutList().size()>0){
                List<PicKingStoreEntity> outList = entity.getOutList();
                for (PicKingStoreEntity p:outList){
                    p.setId(IdWorker.getId());
                    p.setPickingId(entity.getId());
                    FlowVO flowVO = new FlowVO();
                    flowVO.setSettleDetailId(p.getId());
                    flowVO.setSourceId(p.getSourceId());
                    flowVO.setSourceDetailId(p.getSourceDetailId());
                    detail.add(flowVO);
                }
            }
            if (entity.getExitList().size()>0){
                List<PicKingStoreEntity> exitList = entity.getExitList();
                for (PicKingStoreEntity p:exitList){
                    p.setId(IdWorker.getId());
                    p.setPickingId(entity.getId());
                    FlowVO flowVO = new FlowVO();
                    flowVO.setSettleDetailId(p.getId());
                    flowVO.setSourceId(p.getSourceId());
                    flowVO.setSourceDetailId(p.getSourceDetailId());
                    detail.add(flowVO);
                }
            }
            StoreApiVO storeApiVO = new StoreApiVO();
            storeApiVO.setSettleCode(entity.getBillCode());
            storeApiVO.setSettleId(entity.getId());
            storeApiVO.setSettleDate(entity.getSettleDate());
            storeApiVO.setSettleFlag(1);
            storeApiVO.setDetail(detail);
            CommonResponse<String> stringCommonResponse = accountSettleApi.changeSettleFlag(storeApiVO);
            if (!stringCommonResponse.isSuccess()){
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        //校验金额
        service.saveOrUpdate(entity, false);
        //保存 回调数

        PicKingVO vo = BeanMapper.map(entity, PicKingVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
    /**
     * @param id 查询id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<PicKingVO> queryDetail(Long id) {
        QueryWrapper<PicKingEntity> picKingWrapper = new QueryWrapper<>();
        picKingWrapper.eq("id",id);
        picKingWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        PicKingEntity entity = service.getOne(picKingWrapper);
        logger.info(JSONObject.toJSONString(entity)+"@@@@@@@@@@@@@@@@@@@");
        if (entity!=null){
            //查询退库
            QueryParam queryExit = new QueryParam();
            queryExit.getParams().put("picking_id",new Parameter(QueryParam.EQ,entity.getId()));
            queryExit.getParams().put("return_store_flag",new Parameter(QueryParam.EQ,1));
            List<PicKingStoreEntity> picKingStoreExit = storeService.queryList(queryExit,false);
            entity.setExitList(picKingStoreExit);
            //查询出库
            QueryParam queryOut = new QueryParam();
            queryOut.getParams().put("picking_id",new Parameter(QueryParam.EQ,entity.getId()));
            queryOut.getParams().put("return_store_flag",new Parameter(QueryParam.EQ,0));
            List<PicKingStoreEntity> picKingStoreOut = storeService.queryList(queryOut,false);
            entity.setOutList(picKingStoreOut);
            //查询统计
            QueryParam queryTotal = new QueryParam();
            queryTotal.getParams().put("picking_id",new Parameter(QueryParam.EQ,entity.getId()));
            List<PicKingTotalEntity> totalEntities = totalService.queryList(queryTotal,false);
            entity.setTotalList(totalEntities);
            //查询设备
            QueryParam queryEqu = new QueryParam();
            queryEqu.getParams().put("picking_id",new Parameter(QueryParam.EQ,entity.getId()));
            List<PickingEquipmentEntity> totalEquip = equipmentService.queryList(queryEqu,false);
            entity.setEquipmentList(totalEquip);
        }
        PicKingVO vo = BeanMapper.map(entity, PicKingVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids] 删除id list
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<PicKingVO> vos) {
        List<Long> collect = vos.stream().map(PicKingVO::getId).collect(Collectors.toList());
        for (Long id:collect) {
            CommonResponse<PicKingVO> picKingVOCommonResponse = queryDetail(id);
            if (!picKingVOCommonResponse.isSuccess()){
            }
            PicKingVO entity = picKingVOCommonResponse.getData();
            toStore(entity,0);
            service.deletePicking(id);
        }
        return CommonResponse.success("删除成功！");
    }


    private void toStore(PicKingVO entity,Integer flag){
        StoreApiVO storeApiVO = new StoreApiVO();
        storeApiVO.setSettleId(entity.getId());
        storeApiVO.setSettleFlag(flag);
        List<FlowVO> detail = new ArrayList<>();
        if (entity.getOutList().size()>0){
            List<PicKingStoreVO> outList = entity.getOutList();
            for (PicKingStoreVO p:outList){
                FlowVO flowVO = new FlowVO();
                flowVO.setSettleDetailId(p.getId());
                flowVO.setSourceId(p.getSourceId());
                flowVO.setSourceDetailId(p.getSourceDetailId());
                detail.add(flowVO);
            }
        }
        if (entity.getExitList().size()>0){
            List<PicKingStoreVO> exitList = entity.getExitList();
            for (PicKingStoreVO p:exitList){
                FlowVO flowVO = new FlowVO();
                flowVO.setSettleDetailId(p.getId());
                flowVO.setSourceId(p.getSourceId());
                flowVO.setSourceDetailId(p.getSourceDetailId());
                detail.add(flowVO);
            }
        }
        storeApiVO.setDetail(detail);
        CommonResponse<String> stringCommonResponse = accountSettleApi.changeSettleFlag(storeApiVO);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
    }

    /**
     * @param param 查询参数
     * @Description queryList 查询列表
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<PicKingVO>> queryList(@RequestBody QueryParam param) {
        //模糊搜索配置字段示例
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<PicKingEntity> page = service.queryPage(param, false);
        IPage<PicKingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PicKingVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPicKingData", method = RequestMethod.GET)
    public CommonResponse<IPage<PicKingVO>> refPicKingData(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText,
            @RequestParam(value = "searchObject", required = false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            JSONObject _con = JSONObject.parseObject(condition);
        }
        IPage<PicKingEntity> page = service.queryPage(param, false);
        IPage<PicKingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PicKingVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 文件导出 只导出本组织的
     *
     * @param param    无
     * @param response 当前组织签章设置
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        //查询所有满足的数据 按照创建时间倒叙
        param.getOrderMap().put("create_time", QueryParam.DESC);
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<PicKingEntity> pageData = service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<PicKingVO> list = BeanMapper.mapList(pageData.getRecords(), PicKingVO.class);

            list.stream().forEach(item -> item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription()));

            Map<String, Object> beans = new HashMap<>(list.size());
            logger.error(JSONObject.toJSONString(list));
            beans.put("records", list);
            ExcelExport.getInstance().export("pincking-export.xlsx", beans, response);
        }
    }


    @RequestMapping(value = "/queryTotalNum", method = RequestMethod.POST)
    public CommonResponse<List<PicKingTotalVO>> queryAlreadyApplyMny(@RequestBody PicKingVO vo) {
        List<PicKingTotalVO> entities = totalService.totalSumList(vo.getContractId(), vo.getProjectId());
        return CommonResponse.success("查询数据成功",entities);
    }

    @RequestMapping(value = "/queryPicking", method = RequestMethod.POST)
    public CommonResponse<PicKingVO> queryPicking(@RequestBody PicKingVO vo) {
        return service.queryPicking(vo.getContractId(), vo.getProjectId());
    }


    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if(org.apache.commons.lang3.StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }


    @GetMapping(value = "/getBillShareLink")
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        PicKingEntity entity = service.selectById(id);

        if(SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(BeanMapper.map(entity, PicKingEntity.class), billTypeCode, cooperateResp.getData());
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }

        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }

}
