package com.ejianc.business.process.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.process.bean.SalaryDetailEntity;
import com.ejianc.business.process.bean.SalaryExtraEntity;
/**
 * 工人工资单主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_salary")
public class SalaryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_type")
    private Integer contractType; // 合同类型：劳务合同-0，专业合同-1
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商Id（乙方id）
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称（乙方名称）
    @TableField(value="supplier_project_manager_id")
    private Long supplierProjectManagerId; // 乙方项目经理Id（乙方负责人id）
    @TableField(value="supplier_project_manager_name")
    private String supplierProjectManagerName; // 乙方项目经理名称（乙方负责人名称）
    @TableField(value="belong_month")
    private Date belongMonth; // 所属月份
    @TableField(value="sum_salary_mny")
    private BigDecimal sumSalaryMny; // 工资单总金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; //  经办人部门
    @TableField(value="sum_worker_salary_mny")
    private BigDecimal sumWorkerSalaryMny; // 工人工资(实发工资汇总)
    @TableField(value="sum_extra_mny")
    private BigDecimal sumExtraMny; // 额外费用(额外费用汇总)
    @TableField(value="memo")
    private String memo; //  备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="salaryDetailService",pidName ="salaryId")
    private List<SalaryDetailEntity> salaryDetailList = new ArrayList<>(); // 工人工资单明细表
    @TableField(exist=false)
    @SubEntity(serviceName="salaryExtraService",pidName ="salaryId")
    private List<SalaryExtraEntity> salaryExtraList = new ArrayList<>(); // 工人工资额外费用子表
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }
    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }
    public Date getBelongMonth() {
        return belongMonth;
    }

    public void setBelongMonth(Date belongMonth) {
        this.belongMonth = belongMonth;
    }
    public BigDecimal getSumSalaryMny() {
        return sumSalaryMny;
    }

    public void setSumSalaryMny(BigDecimal sumSalaryMny) {
        this.sumSalaryMny = sumSalaryMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public BigDecimal getSumWorkerSalaryMny() {
        return sumWorkerSalaryMny;
    }

    public void setSumWorkerSalaryMny(BigDecimal sumWorkerSalaryMny) {
        this.sumWorkerSalaryMny = sumWorkerSalaryMny;
    }

    public BigDecimal getSumExtraMny() {
        return sumExtraMny;
    }

    public void setSumExtraMny(BigDecimal sumExtraMny) {
        this.sumExtraMny = sumExtraMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<SalaryDetailEntity> getSalaryDetailList() {
        return salaryDetailList;
    }

    public void setSalaryDetailList(List<SalaryDetailEntity> salaryDetailList) {
        this.salaryDetailList = salaryDetailList;
    }

    public List<SalaryExtraEntity> getSalaryExtraList() {
        return salaryExtraList;
    }

    public void setSalaryExtraList(List<SalaryExtraEntity> salaryExtraList) {
        this.salaryExtraList = salaryExtraList;
    }
}
