package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.process.bean.DeductionEntity;
import com.ejianc.business.process.bean.MeasureEntity;
import com.ejianc.business.process.bean.PicKingEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IDeductionService;
import com.ejianc.business.process.service.IMeasureService;
import com.ejianc.business.process.service.IPickingService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.mapper.ContractDetailMapper;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.*;
import com.ejianc.business.settle.vo.*;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 结算主实体
 *
 * @author generator
 */
@Service("FinishSettleService")
public class FinishSettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements IFinishSettleService {

    @Autowired
    private ISettleService settleService;
    @Autowired
    private ISettleDetailService settleDetailService;
    @Autowired
    private IMeasureService measureService;
    @Autowired
    private IPickingService pickingService;
    @Autowired
    private IRegistrationService oddjobService;
    @Autowired
    private IDeductionService deductService;

    @Autowired
    private ISettleOddjobService settleOddjobService;
    @Autowired
    private ISettleDeductService settleDeductService;
    @Autowired
    private ISettlePickingService settlePickingService;
    @Autowired
    private ISettleSalaryService settleSalaryService;
    @Autowired
    private IContractService contractService;

    @Value("${common.env.base-host}")
    private String BaseHost;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ContractDetailMapper contractDetailMapper;



    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    //劳务分包过完工算编码规则
    private static final String BILL_CODE = "FINISH_SETTLE";
    //专业分包完工结算编码规则
    private static final String PRO_SUB_BILL_CODE = "PRO_FINISH_SETTLE";
    // 劳务分包合同—最终结算-【合同量】控【月度结算量】
    private static final String LAB_FINISH_NUM_CHECK_PARAM_CODE = "P-T8i61981";
    // 专业分包合同—最终结算-【合同量】控【月度结算量】
    private static final String PRO_FINISH_NUM_CHECK_PARAM_NAME = "P-7qkB6680";
    // 劳务分包合同—最终结算
    private static final String LAB_CHECK_PARAM_CODE = "P-FWAwT442";
    // 专业分包合同—最终结算
    private static final String PRO_CHECK_PARAM_NAME = "P-LkI10x45";


    /**
     * @Description queryUnusedContract 查询合同是否被完工使用
     * 完工结算时 判断上游业务：分包计量，领料结算，零工登记，奖罚扣款单；
     * 是否有审批中的单据，如果有不允许进行完工结算
     * @param contractId
     */
    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        SettleVO settleVO = new SettleVO();

        //若当前合同有完工结算单子 或 当前合同有其他未生效的结算单子 则不能添加新的结算单
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getContractId, contractId);
        lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
        lambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        int resultCount = super.count(lambda);
        if (resultCount > 0){
            return CommonResponse.error("当前合同已进行完工结算，请选择其他合同。");
        }

        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, contractId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        List<SettleEntity> resultList = super.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)){
            String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
            return CommonResponse.error("当前合同有未审批的" + settleTypeName + "结算单，请选择其他合同。");
        }
        if (null != settleType && SettleTypeEnum.完工.getCode().equals(settleType)){
            //判断各合同过程是否有正在审批中的单据
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.EQ, BillStateEnum.APPROVING_HAS_STATE));
            //分包计量
            List<MeasureEntity> measureEntityList = measureService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(measureEntityList)){
                return CommonResponse.error("当前合同在分包计量还有正在审批中的单据，请选择其他合同。");
            }
            //领料结算
            List<PicKingEntity> picKingEntityList = pickingService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(picKingEntityList)){
                return CommonResponse.error("当前合同在领料结算还有正在审批中的单据，请选择其他合同。");
            }
            //零工登记
            List<RegistrationEntity> registrationEntityList = oddjobService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(registrationEntityList)){
                return CommonResponse.error("当前合同在零工登记还有正在审批中的单据，请选择其他合同。");
            }
            //奖罚扣款单
            List<DeductionEntity> deductionEntityList = deductService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(deductionEntityList)){
                return CommonResponse.error("当前合同在奖罚扣款单还有正在审批中的单据，请选择其他合同。");
            }
        }
        Date resultDate = settleService.queryMaxSettleDate(contractId);
        if (null == resultDate){
            resultDate = null != settleDate ? settleDate : new Date();
            settleVO.setMinSettleDate(null);
        }else {
            //如果页面日期大于当前查询出最大日期，则返回页面日期，否则返回最大日期加1
            resultDate = DateUtils.addDays(resultDate, 1);
            settleVO.setMinSettleDate(resultDate);
            if (null != settleDate && settleDate.compareTo(resultDate) > 0){
                resultDate = settleDate;
            }
        }
        settleVO.setSettleDate(resultDate);

        //设置领料结算累计过程结算金额
        SettleVO processPickingVO = settleService.selectPickingProcessTaxMny(contractId);
        //设置零工登记累计过程结算金额
        SettleVO processOddjobVO = settleService.selectOddjobProcessTaxMny(contractId);
        //设置奖罚扣款单累计过程结算金额
//        SettleVO processDeductVO = settleService.selectDeductProcessTaxMny(contractId);
        //设置其他清单累计过程结算金额
        SettleVO processOtherVO = settleService.selectOtherProcessTaxMny(contractId);
        if (null != processPickingVO){
            settleVO.setPickingProcessTaxMny(null != processPickingVO.getPickingProcessTaxMny() ? processPickingVO.getPickingProcessTaxMny() : BigDecimal.ZERO);
            settleVO.setPickingProcessMny(null != processPickingVO.getPickingProcessMny() ? processPickingVO.getPickingProcessMny() : BigDecimal.ZERO);
        }else{
            settleVO.setPickingProcessTaxMny(BigDecimal.ZERO);
            settleVO.setPickingProcessMny(BigDecimal.ZERO);
        }
        if (null != processOddjobVO){
            settleVO.setOddjobProcessTaxMny(null != processOddjobVO.getOddjobProcessTaxMny() ? processOddjobVO.getOddjobProcessTaxMny() : BigDecimal.ZERO);
            settleVO.setOddjobProcessMny(null != processOddjobVO.getOddjobProcessMny() ? processOddjobVO.getOddjobProcessMny() : BigDecimal.ZERO);
        }else {
            settleVO.setOddjobProcessTaxMny(BigDecimal.ZERO);
            settleVO.setOddjobProcessMny(BigDecimal.ZERO);
        }
        //奖罚扣款单赋值
        if (null != processOtherVO){
            settleVO.setOtherProcessTaxMny(null != processOtherVO.getOtherProcessTaxMny() ? processOtherVO.getOtherProcessTaxMny() : BigDecimal.ZERO);
            settleVO.setOtherProcessMny(null != processOtherVO.getOtherProcessMny() ? processOtherVO.getOtherProcessMny() : BigDecimal.ZERO);
        }else {
            settleVO.setOtherProcessTaxMny(BigDecimal.ZERO);
            settleVO.setOtherProcessMny(BigDecimal.ZERO);
        }


        //获取清单表累计结算量（节点、过程）
        List<SettleDetailVO> settleDetailList = settleDetailService.selectDetailRecordAndTotalProcessNum(contractId);

        List<SettleDetailVO> settleDetailNodeNumList = settleDetailService.selectDetailTotalNodeNum(contractId);
        Map<Long, BigDecimal> settleDetailNodeNumMap = new HashMap<>();
        settleDetailNodeNumList.forEach(settleDetailVO -> {
            settleDetailNodeNumMap.put(settleDetailVO.getId(), settleDetailVO.getTotalNodeNum());
        });
        //设置清单表累计结算量（节点、过程）
        if (CollectionUtils.isNotEmpty(settleDetailList)){
            settleDetailList.forEach(settleDetail -> {
                settleDetail.setTotalNodeNum(null != settleDetailNodeNumMap.get(settleDetail.getId()) ? settleDetailNodeNumMap.get(settleDetail.getId()) : BigDecimal.ZERO);
                settleDetail.setTotalProcessNum(null != settleDetail.getTotalProcessNum() ? settleDetail.getTotalProcessNum() : BigDecimal.ZERO);
                settleDetail.setTid(settleDetail.getId().toString());
                settleDetail.setTpid(settleDetail.getParentId() != null ? settleDetail.getParentId().toString() : null);
                settleDetail.setRowState("edit");
            });
            settleVO.setSettleDetailList(TreeNodeBUtil.buildTree(settleDetailList));
        }

        //设置领料子表
        settleVO.setSettlePickingList(BeanMapper.mapList(settlePickingService.queryPickingList(SettleTypeEnum.完工.getCode(), contractId, null), SettlePickingVO.class));
        //设置零工登记子表
        settleVO.setSettleOddjobList(BeanMapper.mapList(settleOddjobService.queryOddjobList(SettleTypeEnum.完工.getCode(), contractId, null), SettleOddjobVO.class));
        //设置讲法扣款单
        settleVO.setSettleDeductList(BeanMapper.mapList(settleDeductService.queryDeductList(SettleTypeEnum.完工.getCode(), contractId, null), SettleDeductVO.class));
        //设置工人工资子表
        settleVO.setSettleSalaryList(BeanMapper.mapList(settleSalaryService.querySalaryList(SettleTypeEnum.完工.getCode(), contractId, null), SettleSalaryVO.class));
        //完工结算单不需要其他费用子表数据

        //TODO 调用查询合同相关数据方法
        return CommonResponse.success("当前合同可用！", settleVO);
    }

    @Override
    public CommonResponse queryFinishFlag(Long contractId) {
        //若当前条件 同一项目+供应商+付款类型 有未生效的申请单，则不能添加新的申请单
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
        lambda.eq(SettleEntity::getContractId, contractId);
//        lambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.UNCOMMITED_STATE.getBillStateCode()));
        int resultCount = super.count(lambda);
        if (resultCount>0){
            return CommonResponse.error("当前合同已进行完工结算 不能进行领料结算");
        }

        return CommonResponse.success("当前合同可以进行结算");
    }


    /**
     * 推送目标成本SettleVO
     *
     * @param settleEntity 最终结算实体
     *
     * @return 结算单VO
     */
    @Override
    public SettleVO getPushTargetCostSettleVO(SettleEntity settleEntity) {
        //目标成本 推送结算单生效
        SettleVO settleVO = BeanMapper.map(settleEntity, SettleVO.class);
        // 结算清单过滤出叶子节点
        List<SettleDetailEntity> settleDetailList = settleEntity.getSettleDetailList().stream().filter(e -> e.getSettleNum() != null).collect(Collectors.toList());
        // 根据结算单的合同id查询合同详情
        ContractEntity ce = contractService.selectById(settleEntity.getContractId());
        // 合同清单过滤出叶子节点
        List<ContractDetailEntity> ceDetailList = ce.getDetailList().stream().filter(e -> e.getDetailNum() != null).collect(Collectors.toList());
        // 推总金额执行表
        settleVO.setMny(ComputeUtil.safeSub(settleEntity.getMny(), ce.getContractMny()));
        settleVO.setTaxMny(ComputeUtil.safeSub(settleEntity.getTaxMny(), ce.getContractTaxMny()));

        // 推明细执行表（合同明细）
        List<SettleDetailVO> sdList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(settleDetailList)) {
            // 合同清单不会为空
            List<Long> contractIds = ceDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            for (SettleDetailEntity sd : settleDetailList) {

                // 理论上合同清单包含结算单的清单明细
                if (contractIds.contains(sd.getSourceId())) {
                    for (ContractDetailEntity cd : ceDetailList) {
                        if (sd.getSourceId().equals(cd.getId())) {
                            // 【完工结算量】- 【合同明细量】
                            sd.setSettleNum(ComputeUtil.safeSub(sd.getSettleNum(), cd.getDetailNum()));
                            // 【完工结算无税金额】-【合同明细无税金额】
                            sd.setSettleMny(ComputeUtil.safeSub(sd.getSettleMny(), cd.getDetailMny()));
                            // 【完工结算金额】-【合同明细金额】
                            sd.setSettleTaxMny(ComputeUtil.safeSub(sd.getSettleTaxMny(), cd.getDetailTaxMny()));
                        }
                    }
                }
                sdList.add(BeanMapper.map(sd, SettleDetailVO.class));
            }
        }
        settleVO.setSettleDetailList(sdList);
        return settleVO;
    }


    @Override
    public ExecutionVO targetCost(SettleVO settleVO, String linkUrl, Integer contractType){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        if (contractType==0){
            totalVO.setBillType("BT220114000000004");
            totalVO.setBussinessType(BussinessTypeEnum.劳务分包合同.getCode());
        }else {
            totalVO.setBillType("BT220307000000009");
            totalVO.setBussinessType(BussinessTypeEnum.专业分包合同.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        if (settleVO.getProjectId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(settleVO.getProjectId());
        }
        if (settleVO.getOrgId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(settleVO.getOrgId());
        }
        totalVO.setMoney(settleVO.getMny());
        totalVO.setTaxMoney(settleVO.getTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (CollectionUtils.isNotEmpty(settleVO.getSettleDetailList())){
            List<SettleDetailVO> settleDetailVOS = settleVO.getSettleDetailList().stream().filter(item -> item.getDetailNum() != null).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(settleDetailVOS)) {
                throw new BusinessException("目标成本推送失败，结算明细没有叶子结点！");
            }
//            Map<Long, LabsubCategoryVO> labCategoryCache = new HashMap<>();
//            Map<Long, ProsubCategoryVO> proCategoryCache = new HashMap<>();
            for (SettleDetailVO settleDetailVO : settleDetailVOS){
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(settleDetailVO.getId());
                // 来源主表id
                detailExecutionVO.setSourceBillId(settleDetailVO.getSettleId());
                detailExecutionVO.setCategoryId(settleDetailVO.getDocCategoryId()); // 档案分类ID
                // 根据档案id判断是否是分类
                detailExecutionVO.setCategoryFlag(settleDetailVO.getDocId() == null);
                detailExecutionVO.setCode(settleDetailVO.getSourceBillCode());
                detailExecutionVO.setCategoryContainFlag(false);

                // 根据档案分类id查询档案分类信息
                if (null == settleDetailVO.getDocCategoryId()){
                    throw new BusinessException("档案分类id不能为空");
                }
//                if (0 == contractType){
//                    LabsubCategoryVO categoryVO = labCategoryCache.get(settleDetailVO.getDocCategoryId());
//                    if(null == categoryVO) {
//                        // 劳务分包
//                        CommonResponse<LabsubCategoryVO> res = shareLabsubApi.queryLabSubByCategoryId(settleDetailVO.getDocCategoryId());
//                        if (!res.isSuccess() || res.getData() == null) {
//                            logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类ID:{}",settleDetailVO.getDocCategoryId());
//                            throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
//                        }
//                        categoryVO = res.getData();
//                        labCategoryCache.put(settleDetailVO.getDocCategoryId(), categoryVO);
//                    }
//
//                    if (null == categoryVO){
//                        detailExecutionVO.setCategoryInnerCode(null);
//                        detailExecutionVO.setCategoryCode(null);
//                    }else {
//                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
//                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
//                    }
//                } else {
//                    ProsubCategoryVO categoryVO = proCategoryCache.get(settleDetailVO.getDocCategoryId());
//                    if(categoryVO == null) {
//                        // 专业分包
//                        CommonResponse<ProsubCategoryVO> res = shareLabsubApi.queryMajorSubByCategoryId(settleDetailVO.getDocCategoryId());
//                        if (!res.isSuccess() || res.getData() == null) {
//                            logger.error("根据档案分类id查询专业分包档案分类信息失败,档案分类ID:{}",settleDetailVO.getDocCategoryId());
//                            throw new BusinessException("根据分类ID查询专业分包档案分类信息失败!");
//                        }
//                        categoryVO = res.getData();
//                        proCategoryCache.put(settleDetailVO.getDocCategoryId(), categoryVO);
//                    }
//
//                    if (null == categoryVO){
//                        detailExecutionVO.setCategoryInnerCode(null);
//                        detailExecutionVO.setCategoryCode(null);
//                    }else {
//                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
//                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
//                    }
//                }

                // 档案id
                if (settleDetailVO.getDocId() == null) {
                    throw new BusinessException("档案id不能为空");
                }
                detailExecutionVO.setDocId(settleDetailVO.getDocId());
                if (contractType==0){
                    detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                }else {
                    detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                }
                detailExecutionVO.setCode(settleDetailVO.getSourceBillCode());
                detailExecutionVO.setName(settleDetailVO.getDetailName());
                detailExecutionVO.setUnitName(settleDetailVO.getDetailUnit());
                detailExecutionVO.setNum(settleDetailVO.getSettleNum());
                detailExecutionVO.setTaxPrice(settleDetailVO.getDetailTaxPrice());
                detailExecutionVO.setPrice(settleDetailVO.getDetailPrice());
                detailExecutionVO.setSpec(settleDetailVO.getDetailMeasurementRules());
                detailExecutionVO.setMemo(settleDetailVO.getMemo());
                detailExecutionVO.setMoney(settleDetailVO.getSettleMny());
                detailExecutionVO.setTaxMoney(settleDetailVO.getSettleTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }


    @Override
    public ParamsCheckVO mnyCtrl(SettleVO settleVO) {

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务分包合同
        if (0 == settleVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        // 专业分包合同
        if (1 == settleVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, settleVO.getOrgId());
        }

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVO;
        }
        List<BillParamVO> data = billParamByCode.getData();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();

            // 控制规则值
            BigDecimal roleValue = billParamVO.getRoleValue();

            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            if (!"none".equals(paramsCheck.getWarnType())) {
                // 金额计算

                // 最新版本合同金额，最新的合同金额
                ContractEntity contract = contractService.selectById(settleVO.getContractId());
                if (null == contract) {
                    logger.info("获取合同信息失败！");
                    throw new BusinessException("获取合同信息失败！");
                }

                // 最终结算金额
                BigDecimal taxMny = settleVO.getTaxMny();
                // 合同金额
                BigDecimal contractTaxMny = settleService.getContractTaxMny(contract.getContractTaxMny(), roleValue);

                // 控制金额
                if (taxMny.compareTo(contractTaxMny) > 0) {
                    // 超结金额
                    BigDecimal overTaxMny = settleService.getOverTaxMny(taxMny, contractTaxMny);

                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("合同超结");
                    paramsCheckDsVO.setWarnName("累计最终结算金额大于合同金额");

                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("最终结算金额：").append(taxMny.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("。超结金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));

                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheck.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheck);
                } else {
                    // 未超结金额
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
        }

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }

        return paramsCheckVO;
    }

    /**
     * 劳务/专业分包合同—完工结算  【合同量】控【最终结算量】  合同最终结算量 > 合同数量*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     * 1、末级清单控制
     * 2、合同数量：取最新版本合同数量；
     * 3、结算数量：含本期累计月度结算量；(根据合同清单维度)
     *
     * @param settleVO
     * @param flag
     * @return
     */
    @Override
    public ParamsCheckVO numCtrl(SettleVO settleVO, Boolean flag) {
        logger.info("FinishSettleServiceImpl--numCtrl()--begin--当前为完工结算，【合同量】控【最终结算量】--入参：settleVO={}", JSONObject.toJSONString(settleVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务分包合同
        if (0 == settleVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_FINISH_NUM_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        // 专业分包合同
        if (1 == settleVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_FINISH_NUM_CHECK_PARAM_NAME, settleVO.getOrgId());
        }

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVO;
        }
        List<BillParamVO> data = billParamByCode.getData();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();

            // 控制规则值
            BigDecimal roleValue = billParamVO.getRoleValue();

            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            // 为none时不需要控制
            if (!"none".equals(paramsCheck.getWarnType())) {
                Long tenantid = InvocationInfoProxy.getTenantid();
                // 存储当前结算vo的清单数据
                List<SettleDetailVO> settleDetailList = settleVO.getSettleDetailList();
                // 用于存储当前结算vo的清单数据，key为清单的contractDetailId，value为清单数据
                HashMap<Long, SettleDetailVO> settleDetailMap = new HashMap<>();
                // 用于存储 当前结算vo的清单数据中，相同合同清单id的本期结算量的累加值，key为合同清单id，value为累计值
                HashMap<Long, BigDecimal> settleNumMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(settleDetailList)) {
                    // 将结算清点放入map中，key为contractDetailId，value为清单数据
                    for (SettleDetailVO settleDetailVO : settleDetailList) {
                        // 只要 末级且非删除 的结算清单
                        if (settleDetailVO.getDetailNum() == null || "del".equals(settleDetailVO.getRowState())) {
                            continue;
                        }
                        settleDetailMap.put(settleDetailVO.getContractDetailId(), settleDetailVO);
                        // 合并同一个contractDetailId的结算清单的本期结算量并放入map中，key为contractDetailId，value为计算好的本期结算量
                        // 当前的本期结算量
                        BigDecimal settleNum = settleDetailVO.getSettleNum() == null ? BigDecimal.ZERO : settleDetailVO.getSettleNum();
                        // 相同合同清单id的结算清单的本期结算量的累计 = 之前的累计值 + 当前的本期结算量
                        BigDecimal settleNumTotalOld = settleNumMap.get(settleDetailVO.getContractDetailId());
                        settleNumTotalOld = settleNumTotalOld == null ? BigDecimal.ZERO : settleNumTotalOld;
                        settleNumMap.put(settleDetailVO.getContractDetailId(), settleNumTotalOld.add(settleNum));
                    }
                }
                logger.info("待保存数据同一合同清单下的本期结算量的为：map={}", JSONObject.toJSONString(settleNumMap));
                // 用于存储根据当前结算vo的清单数据中的合同清单id查询到的合同清单数据
                List<ContractDetailEntity> contractDetailEntityList = new ArrayList<>();
                QueryWrapper<ContractDetailEntity> cdWrapper = new QueryWrapper<>();
                Set<Long> settleNumMapKeySet = settleNumMap.keySet();
                if (MapUtils.isNotEmpty(settleNumMap)) {
                    cdWrapper = new QueryWrapper<>();
                    cdWrapper.eq("dr", 0).eq("tenant_id", tenantid)
                            .in("id", settleNumMapKeySet);
                    contractDetailEntityList = contractDetailMapper.selectList(cdWrapper);
                }
                logger.info("查询到的待保存数据所属的合同清单数据：list={}", JSONObject.toJSONString(contractDetailEntityList));
                // 将合同清单数据存到map中，key为当前合同清单的id，value为当前合同清单数据，其实主要需要的是合同的合同量
                HashMap<Long, ContractDetailEntity> contractDetailEntityMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
                    for (ContractDetailEntity contractDetailEntity : contractDetailEntityList) {
                        contractDetailEntityMap.put(contractDetailEntity.getId(), contractDetailEntity);
                    }
                }
                // 当前合同清单的含本期累计结算量 = 合同清单的往期的本期结算量的累计值 + 当前结算vo中的结算清单的本期结算量
                if (MapUtils.isNotEmpty(settleDetailMap)) {
                    Set<Long> keySet = settleDetailMap.keySet();
                    if (keySet.size() > 0) {
                        logger.info("参数控制----begin");
                        for (Long key : keySet) {
                            logger.info("当前合同清单id：id={}", JSONObject.toJSONString(key));
                            // 最终结算没有累计值，本期结算量就是总共的结算量
                            BigDecimal settleNum = settleNumMap.get(key);
                            settleNum = settleNum == null ? BigDecimal.ZERO : settleNum;
                            logger.info("待保存的结算清单同一合同清单下的本期结算量为:settleNum={}", settleNum);

                            ContractDetailEntity cdEntiey = contractDetailEntityMap.get(key);
                            if (cdEntiey == null) {
                                continue;
                            }
                            logger.info("当前合同清单数据：contractDetailVO={}", JSONObject.toJSONString(cdEntiey));

                            // 清单名称
                            String detailName = cdEntiey.getDetailName();
                            detailName = StringUtils.isBlank(detailName) ? "" : detailName;
                            logger.info("当前合同清单名称：detailName={}", detailName);
                            // 计量规则
                            String detailRule = cdEntiey.getDetailMeasurementRules();
                            detailRule = StringUtils.isBlank(detailRule) ? "" : detailRule;
                            logger.info("当前计量规则：detailRule={}", detailRule);
                            // 合同量
                            BigDecimal detailNum = cdEntiey.getDetailNum() == null ? BigDecimal.ZERO : cdEntiey.getDetailNum();
                            logger.info("当前合同量：detailNum={}", detailNum);

                            // 计算 合同量*X%
                            BigDecimal conNum = detailNum.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
                            logger.info("当前合同量*"+ roleValue.toString() +"%：conNum={}", conNum);

                            // 控制 合同月度结算量 > 合同数量*X%
                            logger.info("再次打印日志，本期结算量 = {}，合同量*"+ roleValue.toString() +"% = {}", settleNum, conNum);
                            if (settleNum.compareTo(conNum) > 0) {
                                // 计算超出数量
                                BigDecimal overNum = settleNum.subtract(conNum);
                                logger.info("超出数量={}", overNum);
                                // 封装预警信息
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(detailName + detailRule);
                                paramsCheckDsVO.setWarnName("最终结算数量大于合同数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("合同最终结算数量：").append(settleNum.setScale(2, RoundingMode.DOWN))
                                        .append("，合同数量*").append(roleValue).append("%：").append(conNum.setScale(2, RoundingMode.DOWN))
                                        .append("。超出数量：").append(overNum.setScale(2, RoundingMode.DOWN));
                                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                dataSource.add(paramsCheckDsVO);
                                paramsCheck.setDataSource(dataSource);
                            }
                        }
                        logger.info("参数控制--end");
                    } else {
                        // 无需控制
                        paramsCheck.setWarnType(paramsArray[0]);
                    }
                } else {
                    // 无需控制
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
            logger.info("FinishSettleServiceImpl--numCtrl()--end--当前为完工结算，【合同量】控【最终结算量】--返回结果：paramsCheckVO={}", JSONObject.toJSONString(paramsCheck));
            paramsCheckVOList.add(paramsCheck);
        }

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }

        return paramsCheckVO;
    }

    @Override
    public SettleVO saveFinishSettle(SettleVO saveOrUpdateVO) {
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(saveOrUpdateVO.getContractType() == 0 ? BILL_CODE : PRO_SUB_BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置归档状态
            entity.setFilingStatus(0);
            //设置乙方签字状态
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方未签字.getCode());
            //保存单据制单人Id
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");


            //更新合同、合同池履约状态
            String updateMsg = contractService.changePerformanceStatus(entity.getContractId(), ContractPerformanceStateEnum.已终止.getStateCode());
            if(StringUtils.isNotBlank(updateMsg)) {
                throw new BusinessException("保存失败，更新合同履约状态失败！");
            }
        }
        List<SettleDetailEntity> detailList = entity.getSettleDetailList();
        if (!detailList.isEmpty()) {
            Map<String, Long> idMap = new HashMap<>();
            for (SettleDetailEntity sd : detailList) {
                if (!("del").equals(sd.getRowState())){
                    if (sd.getId() == null || entity.getId() == null) {
                        sd.setId(IdWorker.getId());
                    }
                    idMap.put(sd.getTid(), sd.getId());
                    sd.setParentId(null);
                }
            }
            for (SettleDetailEntity sd : detailList) {
                if (!("del").equals(sd.getRowState())){
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty(sd.getTpid())) {
                        sd.setParentId(idMap.get(sd.getTpid()));
                    }
                }
            }
        }
        // 初始化签章状态
        entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());

        //单据更新
        super.saveOrUpdate(entity, false);

        return BeanMapper.map(entity, SettleVO.class);
    }

    @Override
    public String delBatch(List<Long> billIds) {
        StringBuilder sp = new StringBuilder();

        QueryWrapper<SettleEntity> query = new QueryWrapper<>();
        query.in("id", billIds);
        List<SettleEntity> settleList = settleService.list(query);
        for(SettleEntity settle : settleList) {
            String msg = contractService.changePerformanceStatus(settle.getContractId(), ContractPerformanceStateEnum.履约中.getStateCode());
            if(StringUtils.isBlank(msg)) {
                super.removeById(settle.getId());
            } else {
                sp.append(settle.getContractName()).append("、[").append(settle.getContractCode()).append("]");
            }
        }

        return sp.toString().length() > 0 ? sp.toString() : null;
    }

}
