package com.ejianc.business.process.service;

import com.ejianc.business.process.bean.MeasureDetailEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 分包计量计量清单实体
 *
 * @author generator
 */
public interface IMeasureDetailService extends IBaseService<MeasureDetailEntity> {
    /**
     * 查询清单历史计量
     *
     * @param listId 合同清单id
     * @param detailId 子表Id
     * @return 清单历史计量
     */
    BigDecimal queryLastWorkNum(Long listId, Long detailId);

    /**
     * 查询清单历史计量
     *
     * @param listIds 合同清单id列表
     * @return 清单历史计量
     */
    Map<Long, BigDecimal> queryLastWorkNumByIds(List<Long> listIds);
}
