package com.ejianc.business.contract.relieve.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contract.relieve.vo.ContractRelieveVO;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("contractRelieve")
public class ContractRelieveBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IContractRelieveService service;

	@Autowired
	private IContractService contractService;

	@Value("${common.env.base-host}")
	private static String BASE_HOST;

	@Value("${refer.base-host:null}")
	private String BASE_HOST_FRONTEND;

	@Autowired
	private IExecutionApi executionApi;

	@Autowired
	private ITemplateCategoryApi templateCategoryApi;

	@Autowired
	private IContractPoolApi contractPoolApi;

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		ContractRelieveEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======提交完回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("合同解除审批回调处理成功");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ContractRelieveEntity entity = service.selectById(billId);
		if (entity != null) {
			// 已签章
			if (entity.getDraftType() == 2) {
				entity.setSignatureStatus("4");
				entity.setPerformanceStatus(Integer.valueOf(PerformanceStatusEnum.已解除.getCode()));
				entity.setEffectiveDate(new Date());
				service.saveOrUpdate(entity, false);

				QueryParam param = new QueryParam();
				param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
				List<ContractEntity> contractEntities = contractService.queryList(param, false);
				contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.已解除.getCode());
				logger.info("======终审审核完回调,已签章======,{}", JSONObject.toJSONString(contractEntities.get(0)));
				contractService.saveOrUpdate(contractEntities.get(0), false);
			} else if (entity.getDraftType() == 1) {
				// 初始化成未签章
				entity.setSignatureStatus("1");
				logger.info("======终审审核完回调,初始化成未签章======,{}", JSONObject.toJSONString(entity));
				service.saveOrUpdate(entity, false);
			}
			String frontendBaseHost="";
			if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
				frontendBaseHost = BASE_HOST_FRONTEND;
			}else{
				frontendBaseHost = BASE_HOST;
			}
			// 解除单生效->推送目标成本
			// 根据解除单合同id查询合同类型
			ContractEntity contract = contractService.selectById(entity.getContractId());
			String linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/contractRelieve/Card?id=" + entity.getId() + "&cardType=" + contract.getContractType();
			ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractRelieveVO.class), linkUrl);
			logger.info("合同解除，目标成本推送数据: {}", JSON.toJSONString(executionVO));
			CommonResponse<String> response = executionApi.aggPush(executionVO);
			logger.info("合同解除，目标成本推送结果: {}", JSON.toJSONString(response));
			if (!response.isSuccess()) {
				throw new BusinessException("目标成本推送失败," + response.getMsg());
			}


			// 更新合同池中合同的履约状态为已解除
			ContractPoolVO contractPoolVO = new ContractPoolVO();
			contractPoolVO.setSourceId(entity.getContractId());
			contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.已解除.getCode());
			contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
		}

		return CommonResponse.success("合同解除终审审核完回调处理成功!");
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		ContractRelieveEntity entity = service.selectById(billId);

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		// 签章状态：1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他已签章；  单据新增后默认为待签章
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());
		if("1".equals(entity.getDraftType()) && !statusList.contains(entity.getSignatureStatus())) {
			return CommonResponse.error("合同解除" + (SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus()) ? "已生效" : "已有签章流程")  + "，不允许弃审!");
		} else if(SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus())) {
			entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
			service.saveOrUpdate(entity, false);
		}

		// 更新合同履约状态
		ContractPoolVO contractPoolVO = new ContractPoolVO();
		contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		contractPoolVO.setSourceId(entity.getContractId());
		contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);

		// 解除单撤回后，更新合同状态为履约中
		UpdateWrapper<ContractEntity> updateWrapper = new UpdateWrapper<>();
		updateWrapper.eq("id", entity.getContractId());
		updateWrapper.set("performance_status", PerformanceStatusEnum.履约中.getCode());
		contractService.update(updateWrapper);

		return CommonResponse.success("撤回前校验回调成功！");
	}

}
