package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.mapper.ContractDetailMapper;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.mapper.SettleDetailMapper;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.IProcessSettleService;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算主实体
 *
 * @author generator
 */
@Service("ProcessSettleService")
public class ProcessSettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements IProcessSettleService {

    // 劳务分包合同—月度结算
    private static final String LAB_CHECK_PARAM_CODE = "P-6F91n740";
    // 专业分包合同—月度结算
    private static final String PRO_CHECK_PARAM_NAME = "P-7gO63u43";

    // 劳务分包合同—月度结算-【合同量】控【月度结算量】
    private static final String LAB_PROCESS_NUM_CHECK_PARAM_CODE = "P-2LuSuo75";
    // 专业分包合同—月度结算-【合同量】控【月度结算量】
    private static final String PRO_PROCESS_NUM_CHECK_PARAM_NAME = "P-c38YSH76";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private ContractDetailMapper contractDetailMapper;

    @Autowired
    private SettleDetailMapper settleDetailMapper;

    @Autowired
    private ISettleDetailService settleDetailService;

    @Autowired
    private IExecutionApi executionApi;


    @Override
    public ParamsCheckVO mnyCtrl(SettleVO settleVO, Boolean flag) {

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务分包合同
        if (0 == settleVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        // 专业分包合同
        if (1 == settleVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, settleVO.getOrgId());
        }

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVO;
        }
        List<BillParamVO> data = billParamByCode.getData();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();

            // 控制规则值
            BigDecimal roleValue = billParamVO.getRoleValue();

            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            if (!"none".equals(paramsCheck.getWarnType())) {
                // 金额计算

                // 最新版本合同金额，最新的合同金额
                ContractEntity contract = contractService.selectById(settleVO.getContractId());
                if (null == contract) {
                    logger.info("获取合同信息失败！");
                    throw new BusinessException("获取合同信息失败！");
                }

                // 本次月度结算金额
                BigDecimal taxMny = settleVO.getTaxMny();
                // 含本次累计月度结算金额
                BigDecimal totalTaxMny = settleService.getLastTaxMny(settleVO.getContractId(), SettleTypeEnum.过程.getCode(), taxMny, flag);
                // 合同金额
                BigDecimal contractTaxMny = settleService.getContractTaxMny(contract.getContractTaxMny(), roleValue);

                // 控制金额
                if (totalTaxMny.compareTo(contractTaxMny) > 0) {
                    // 超结金额
                    BigDecimal overTaxMny = settleService.getOverTaxMny(totalTaxMny, contractTaxMny);

                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("合同超结");
                    paramsCheckDsVO.setWarnName("累计过程结算金额大于合同金额");

                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次过程结算金额：").append(taxMny.setScale(2, RoundingMode.DOWN)).append("，含本次累计过程结算金额：").append(totalTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("。超结金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));

                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheck.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheck);
                } else {
                    // 未超结金额
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
        }
        if (null == settleVO.getId()) {
            settleVO.setId(IdWorker.getId());
        }
        List<SettleDetailVO> settlementDetailList = settleVO.getSettleDetailList();
        List<SettleDetailVO> settlementDetailListNew = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(settlementDetailList)) {
            for (SettleDetailVO cdEntity : settlementDetailList) {
                if (null == cdEntity.getId()) {
                    cdEntity.setId(IdWorker.getId());
                    cdEntity.setSettleId(settleVO.getId());
                }
                if (!"del".equals(cdEntity.getRowState())) {
                    settlementDetailListNew.add(cdEntity);
                }
            }
            settleVO.setSettleDetailList(settlementDetailListNew);
        }
        //--目标成本控制
        ExecutionVO executionVO = settleService.prepareExecutionVO(BeanMapper.map(settleVO, SettleEntity.class));
        logger.error("目标成本控制推送传参：" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本控制失败," + response.getMsg());
        }
        ParamsCheckVO tarRes = response.getData();
        if(null!=tarRes){
            paramsCheckVOList.add(tarRes);
        }

        /*--end---目标成本控制*/

        //--成本科目控制
        CostCtrlVO costCtrlVO = settleService.sjCost(settleVO);
        if(null != costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("成本科目控制失败," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOList.add(costRes);
            }
        }
        /*--end---成本科目控制*/

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }

        return paramsCheckVO;
    }

  /**
     * 劳务/专业分包合同—月度结算  【合同量】控【月度结算量】  合同月度结算量 > 合同数量*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     * 1、末级清单控制
     * 2、合同数量：取最新版本合同数量；
     * 3、结算数量：含本期累计月度结算量；(根据合同清单维度)
     *
     * @param settleVO
     * @param flag
     * @return
     */
    @Override
    public ParamsCheckVO numCtrl(SettleVO settleVO, Boolean flag) {
        logger.info("ProcessSettleServiceImpl--numCtrl()--begin--当前为过程结算，【合同量】控【月度结算量】--入参：settleVO={}", JSONObject.toJSONString(settleVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务分包合同
        if (0 == settleVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_PROCESS_NUM_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        // 专业分包合同
        if (1 == settleVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_PROCESS_NUM_CHECK_PARAM_NAME, settleVO.getOrgId());
        }

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVO;
        }
        List<BillParamVO> data = billParamByCode.getData();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();

            // 控制规则值
            BigDecimal roleValue = billParamVO.getRoleValue();

            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            // 为none时不需要控制
            if (!"none".equals(paramsCheck.getWarnType())) {
                Long tenantid = InvocationInfoProxy.getTenantid();
                // 存储当前结算vo的清单数据
                List<SettleDetailVO> settleDetailList = settleVO.getSettleDetailList();
                // 用于存储当前结算vo的清单数据，key为清单的contractDetailId，value为清单数据
                HashMap<Long, SettleDetailVO> settleDetailMap = new HashMap<>();
                // 用于存储当前结算vo的清单数据的id
                List<Long> settleDetailIdList = new ArrayList<>();
                // 用于存储 当前结算vo的清单数据中，相同合同清单id的本期结算量的累加值，key为合同清单id，value为累计值
                HashMap<Long, BigDecimal> settleNumMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(settleDetailList)) {
                    // 将结算清点放入map中，key为contractDetailId，value为清单数据
                    for (SettleDetailVO settleDetailVO : settleDetailList) {
                        // 只要 末级且非删除 的结算清单
                        if (settleDetailVO.getDetailNum() == null || "del".equals(settleDetailVO.getRowState())) {
                            continue;
                        }
                        settleDetailMap.put(settleDetailVO.getContractDetailId(), settleDetailVO);
                        if (settleDetailVO.getId() != null) {
                            // 拿到末级清单的所有清单id
                            settleDetailIdList.add(settleDetailVO.getId());
                        }
                        // 合并同一个contractDetailId的结算清单的本期结算量并放入map中，key为contractDetailId，value为计算好的本期结算量
                        // 当前的本期结算量
                        BigDecimal settleNum = settleDetailVO.getSettleNum() == null ? BigDecimal.ZERO : settleDetailVO.getSettleNum();
                        // 相同合同清单id的结算清单的本期结算量的累计 = 之前的累计值 + 当前的本期结算量
                        BigDecimal settleNumTotalOld = settleNumMap.get(settleDetailVO.getContractDetailId());
                        settleNumTotalOld = settleNumTotalOld == null ? BigDecimal.ZERO : settleNumTotalOld;
                        settleNumMap.put(settleDetailVO.getContractDetailId(), settleNumTotalOld.add(settleNum));
                    }
                }
                logger.info("待保存数据同一合同清单下的本期结算量的为：map={}", JSONObject.toJSONString(settleNumMap));
                // 用于存储根据当前结算vo的清单数据中的合同清单id查询到的合同清单数据
                List<ContractDetailEntity> contractDetailEntityList = new ArrayList<>();
                QueryWrapper<ContractDetailEntity> cdWrapper = new QueryWrapper<>();
                Set<Long> settleNumMapKeySet = settleNumMap.keySet();
                if (MapUtils.isNotEmpty(settleNumMap)) {
                    cdWrapper = new QueryWrapper<>();
                    cdWrapper.eq("dr", 0).eq("tenant_id", tenantid)
                            .in("id", settleNumMapKeySet);
                    contractDetailEntityList = contractDetailMapper.selectList(cdWrapper);
                }
                logger.info("查询到的待保存数据所属的合同清单数据：list={}", JSONObject.toJSONString(contractDetailEntityList));
                // 将合同清单数据存到map中，key为当前合同清单的id，value为当前合同清单数据，其实主要需要的是合同的合同量
                HashMap<Long, ContractDetailEntity> contractDetailEntityMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
                    for (ContractDetailEntity contractDetailEntity : contractDetailEntityList) {
                        contractDetailEntityMap.put(contractDetailEntity.getId(), contractDetailEntity);
                    }
                }
                // 用于存储合同清单的往期的本期结算量的累计值，key为contractDetailId，value为累计值
                HashMap<Long, BigDecimal> cdSettleNumMap = new HashMap<>();
                // 用于初始化往期的本期结算量的累计值，即往期的本期结算量的累计值初始值当做0处理
                if (MapUtils.isNotEmpty(settleNumMap)) {
                    if (settleNumMapKeySet.size() > 0) {
                        for (Long key : settleNumMapKeySet) {
                            cdSettleNumMap.put(key, BigDecimal.ZERO);
                        }
                    }
                }
                // 查询当前结算vo的结算清单的所有合同清单的往期的本期结算量的累计值，当有往期值的时候才需要查询往期值，settleNumMapKeySet-所有的contractDetailId的list
                if (CollectionUtils.isNotEmpty(settleNumMapKeySet)) {
                    List<Map<String, Object>> contractDetailSettleNumQueryMaps = settleDetailMapper.queryCountSettleNumByContractSettleType(
                            tenantid,
                            0,
                            new ArrayList<>(settleNumMapKeySet),
                            CollectionUtils.isNotEmpty(settleDetailIdList) ? settleDetailIdList : null
                    );
                    if (CollectionUtils.isNotEmpty(contractDetailSettleNumQueryMaps)) {
                        for (Map<String, Object> detailSettleNumQueryMap : contractDetailSettleNumQueryMaps) {
                            if (MapUtils.isEmpty(detailSettleNumQueryMap)) {
                                continue;
                            }
                            Object settleNumTotalObj = detailSettleNumQueryMap.get("settleTotalNum");
                            cdSettleNumMap.put(
                                    Long.parseLong(detailSettleNumQueryMap.get("contractDetailId").toString()),
                                    new BigDecimal(settleNumTotalObj != null ? settleNumTotalObj.toString() : "0")
                            );
                        }
                    }
                }
                logger.info("查询到的待保存数据的结算清单所在的合同清单的晚期的本期结算量的累计值：map={}", JSONObject.toJSONString(cdSettleNumMap));
                // 当前合同清单的含本期累计结算量 = 合同清单的往期的本期结算量的累计值 + 当前结算vo中的结算清单的本期结算量
                if (MapUtils.isNotEmpty(settleDetailMap)) {
                    Set<Long> keySet = settleDetailMap.keySet();
                    if (keySet.size() > 0) {
                        logger.info("参数控制----begin");
                        for (Long key : keySet) {
                            logger.info("当前合同清单id：id={}", JSONObject.toJSONString(key));
                            BigDecimal settleNumTotalOld = cdSettleNumMap.get(key);
                            settleNumTotalOld = settleNumTotalOld == null ? BigDecimal.ZERO : settleNumTotalOld;
                            logger.info("合同清单下的不含本期累计结算量为:settleNumTotalOld={}", settleNumTotalOld);
                            // 待保存的结算清单同一合同清单的本期结算量的累加值
                            BigDecimal settleNum = settleNumMap.get(key);
                            settleNum = settleNum == null ? BigDecimal.ZERO : settleNum;
                            logger.info("待保存的结算清单同一合同清单下的本期结算量为:settleNum={}", settleNum);
                            BigDecimal settleTotalNum = settleNumTotalOld.add(settleNum);
                            logger.info("合同清单下的含本期累计结算量为:settleTotalNum={}", settleTotalNum);

                            ContractDetailEntity cdEntiey = contractDetailEntityMap.get(key);
                            if (cdEntiey == null) {
                                continue;
                            }
                            logger.info("当前合同清单数据：contractDetailVO={}", JSONObject.toJSONString(cdEntiey));

                            // 清单名称
                            String detailName = cdEntiey.getDetailName();
                            detailName = StringUtils.isBlank(detailName) ? "" : detailName;
                            logger.info("当前合同清单名称：detailName={}", detailName);
                            // 计量规则
                            String detailRule = cdEntiey.getDetailMeasurementRules();
                            detailRule = StringUtils.isBlank(detailRule) ? "" : detailRule;
                            logger.info("当前计量规则：detailRule={}", detailRule);
                            // 合同量
                            BigDecimal detailNum = cdEntiey.getDetailNum() == null ? BigDecimal.ZERO : cdEntiey.getDetailNum();
                            logger.info("当前合同量：detailNum={}", detailNum);

                            // 计算 合同量*X%
                            BigDecimal conNum = detailNum.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
                            logger.info("当前合同量*"+ roleValue.toString() +"%：conNum={}", conNum);

                            // 控制 合同月度结算量 > 合同数量*X%
                            logger.info("再次打印日志，含本期累计结算量 = {}，合同量*"+ roleValue.toString() +"% = {}", settleTotalNum, conNum);
                            if (settleTotalNum.compareTo(conNum) > 0) {
                                // 计算超出数量
                                BigDecimal overNum = settleTotalNum.subtract(conNum);
                                logger.info("超出数量={}", overNum);
                                // 封装预警信息
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(detailName + detailRule);
                                paramsCheckDsVO.setWarnName("过程结算数量大于合同数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次过程结算数量：").append(settleNum.setScale(2, RoundingMode.DOWN))
                                        .append("，含本次累计过程结算数量：").append(settleTotalNum.setScale(2, RoundingMode.DOWN))
                                        .append("，合同数量*").append(roleValue).append("%：").append(conNum.setScale(2, RoundingMode.DOWN))
                                        .append("。超出数量：").append(overNum.setScale(2, RoundingMode.DOWN));
                                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                dataSource.add(paramsCheckDsVO);
                                paramsCheck.setDataSource(dataSource);
                            }
                        }
                        logger.info("参数控制--end");
                    } else {
                        // 无需控制
                        paramsCheck.setWarnType(paramsArray[0]);
                    }
                } else {
                    // 无需控制
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
            logger.info("ProcessSettleServiceImpl--numCtrl()--end--当前为过程结算，【合同量】控【过程结算量】--返回结果：paramsCheckVO={}", JSONObject.toJSONString(paramsCheck));
            paramsCheckVOList.add(paramsCheck);
        }

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }

        return paramsCheckVO;
    }


}
