package com.ejianc.business.prosub.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.filing.enums.FilingTypeEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.service.IMeasureDetailService;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.bean.ContractOtherCostEntity;
import com.ejianc.business.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.prosub.service.IContractDetailService;
import com.ejianc.business.prosub.service.IContractOtherCostService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.models.auth.In;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springside.modules.nosql.redis.JedisTemplate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractService service;

    @Autowired
    private IContractDetailService detailService;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IContractOtherCostService otherCostService;

    @Autowired
    private IParamCheckApi paramCheckApi;

    //劳务分包合同单据编码
    private final String LABORSUB_Bill_CODE = "BT211108000000002";
    //专业分包合同单据编码
    private final String PROSUB_Bill_CODE = "BT220216000000003";

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    @Autowired
    private IMeasureDetailService measureDetailService;

    @Autowired
    private IContractRelieveService contractRelieveService;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IContractPoolApi contractPoolApi;

    private final String PUSH_POOL_PREFIX = "pushContract::";

    // 归档参数控制
    private final String FILLING_TYPE_STATE = "P-eg7rBO0134";
    @Autowired
    private IParamConfigApi paramConfigApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        ContractVO vo = service.insertOrUpdate(saveorUpdateVO, authority, false);
        return CommonResponse.success("保存成功！", service.queryDetail(vo.getId()));
    }

    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        ContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        if (null != contractEntity.getContractType() && contractEntity.getContractType().equals(0)){
            resp.put("contractBillTypeCode", LABORSUB_Bill_CODE);
        }else {
            resp.put("contractBillTypeCode", PROSUB_Bill_CODE);
        }
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        return service.deleteByIds(vos);
    }

    /**
     * @Description 导出
     *
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = pageList(param);
        List<ContractVO> contractVOList = new ArrayList<>();
        if (null != commonResponse.getData()){
            contractVOList = (List<ContractVO>) commonResponse.getData().get("records");
            if (null != contractVOList && contractVOList.size() > 0){
                contractVOList.forEach(c -> {
                    //设置合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；
                    // 默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。
                    // 当合同存在生效的最终结算时，状态自动改为【已封账】
                    if(StringUtils.isBlank(c.getPerformanceStatus())) {
                        c.setPerformanceStatus(PerformanceStatusEnum.未签订.getDescription());
                    } else {
                        logger.info("合同状态：{}", c.getPerformanceStatus());
                        logger.info("状态码：", PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                        c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                    }

                    //设置签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
                    if(StringUtils.isBlank(c.getSignatureStatus())) {
                        c.setSignatureStatus(SignatureStatusEnum.未签章.getDescription());
                    } else {
                        c.setSignatureStatus(SignatureStatusEnum.getEnumByCode(c.getSignatureStatus()).getDescription());
                    }

                    //流程状态
                    c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
                });
            }
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("prosubContract-export.xlsx", beans, response);
    }

    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));


        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(param.getOrderMap().containsKey("createTime") && null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);

        String filingTypeConfig = service.getFilingTypeConfig();

        IPage<ContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        page.put("filingTypeConfig", filingTypeConfig);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 合同参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/prosubContractRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> prosubContractRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        //设置模糊查询
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

        if (!(null != conditionMap.get("orgId") || null != conditionMap.get("projectId"))){
            return CommonResponse.error("当前传入项目id 或 组织id为空！");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")){
            return CommonResponse.error("当前传入组织类型为空！");
        }
        if(null != conditionMap.get("contractType")) {
            queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ, conditionMap.get("contractType")));
        }
        if(null != conditionMap.get("categoryId")) {
            //查询该分类下所有子分类
            CommonResponse<List<TemplateCategoryVO>> categoryVOResp = templateCategoryApi.querySelfAndChildById(Long.valueOf(conditionMap.get("categoryId").toString()));
            if(!categoryVOResp.isSuccess()) {
                return CommonResponse.error("获取合同类别信息失败！");
            }
            List<Long> categoryIds = categoryVOResp.getData().stream().map(item -> item.getId()).collect(Collectors.toList());
            switch (categoryIds.size()) {
                case 0:
                    JSONObject page = new JSONObject();
                    page.put("records", new ArrayList<>());
                    page.put("total", 0);
                    page.put("current", queryParam.getPageIndex());
                    page.put("size", queryParam.getPageSize());
                    page.put("pages", 0);
                    return CommonResponse.success("查询分包合同数据成功！", page);
                case 1:
                    queryParam.getParams().put("contractCategoryId", new Parameter(QueryParam.EQ, categoryIds.get(0)));
                    break;
                default:
                    queryParam.getParams().put("contractCategoryId", new Parameter(QueryParam.IN, categoryIds));
            }
        }

        if (null != conditionMap.get("projectId")){
            Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }else {

            //查询本下范围内日的合同
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        // 零工登记转扣过滤
        // if(conditionMap.containsKey("contractType")) {
        //     queryParam.getParams().put("contract_type", new Parameter(QueryParam.EQ, Integer.parseInt(conditionMap.get("contractType").toString())));
        // }
        if(conditionMap.containsKey("contractId")) {
            List<Long> contractIds = new ArrayList<>();
            contractIds.add(Long.parseLong(conditionMap.get("contractId").toString()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NOT_IN, contractIds));
        }
        //归档参数设置为2时，过滤所有未归档的合同
        String filingTypeConfig = service.getFilingTypeConfig();
        if ("2".equals(filingTypeConfig)){
            queryParam.getParams().put("filingStatus", new Parameter(QueryParam.EQ, 1));
        }else if ("1".equals(filingTypeConfig)){
            logger.info("conditionMap中的值为：", JSONObject.toJSONString(conditionMap));
            logger.info(conditionMap.containsKey("contractFilingType") ? "condition包含contractFilingType值为" + conditionMap.get("contractFilingType").toString() : "condition不包含contractFilingType");
            if(conditionMap.containsKey("contractFilingType") && "settle".equals(conditionMap.get("contractFilingType").toString())) {
                queryParam.getParams().put("filingStatus", new Parameter(QueryParam.EQ, 1));
            }
        }


        queryParam.getParams().put("performance_status", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null != queryParam.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", queryParam.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);



        IPage<ContractEntity> pageData= service.queryPage(queryParam,false);
        logger.info("分包合同查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同数据成功！",page);
    }


    /**
     * 合同明细参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/prosubContractDetailRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> prosubContractDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("detailName");
        fuzzyFields.add("detailWorkContent");
        fuzzyFields.add("detailMeasurementRules");

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
        String calcLastTotalNum = null != conditionMap.get("calcLastTotalNum") ? conditionMap.get("calcLastTotalNum").toString() : null;

        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置只查询叶子节点清单
        queryParam.getParams().put("detail_price", new Parameter(QueryParam.NE, null));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同明细查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        IPage<ContractDetailEntity> pageData= detailService.queryPage(queryParam,false);
        logger.info("分包合同明细查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        List<JSONObject> records = BeanMapper.mapList(pageData.getRecords(), JSONObject.class);
        List<Long> detailIds = new ArrayList<>();
        Map<Long, List<JSONObject>> detailHasParentMap = new HashMap<>();
        records.stream().forEach(item -> {
            detailIds.add(item.getLong("id"));
            if(null != item.get("parentId")) {
                if(null == detailHasParentMap.get(item.getLong("parentId"))) {
                    detailHasParentMap.put(item.getLong("parentId"), new ArrayList<>());
                }
                detailHasParentMap.get(item.getLong("parentId")).add(item);
            }
        });

        //查询清单的直接父级
        if (!detailHasParentMap.isEmpty()){
            List<ContractDetailEntity> parents = (List<ContractDetailEntity>) detailService.listByIds(new ArrayList<>(detailHasParentMap.keySet()));
            for(ContractDetailEntity parent : parents) {
                detailHasParentMap.get(parent.getId()).forEach(child -> child.put("pTag", parent.getDetailCode() + "-" + parent.getDetailName()));
            }
        }
        //查询清单的累计计量
        if("true".equals(calcLastTotalNum)&&!detailIds.isEmpty()) {
            Map<Long, BigDecimal> calcResult = measureDetailService.queryLastWorkNumByIds(detailIds);
            records.stream().forEach(r -> {
                r.put("lastTotalNum", calcResult.get(r.getLong("id")));
            });
        }

        page.put("records", records);
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同明细数据成功！",page);
    }

    /**
     * 合同明细参照查询（合同按钮选择用）
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractDetailRef",method = RequestMethod.GET)
    public CommonResponse<List<ContractDetailVO>> contractDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        List<ContractDetailVO> resList = new ArrayList<>();
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
        ContractEntity contractEntity = service.selectById((Serializable) conditionMap.get("contractId"));
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                List<ContractDetailVO> contractDetailList = BeanMapper.mapList(contractEntity.getDetailList(), ContractDetailVO.class);
                if (CollectionUtils.isNotEmpty(contractDetailList)) {
                    for (ContractDetailVO detail : contractDetailList) {
                        detail.setTid(detail.getId().toString());
                        detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                    }
                    resList = TreeNodeBUtil.buildTree(contractDetailList);
                }
            }
        }
        logger.info("返回合同明细数据成功：", JSONObject.toJSONString(resList));
        return CommonResponse.success("查询参照数据成功！",resList);
    }


    /**
     * @param contractId 合同id
     * @return 合同子级list
     */
    @ResponseBody
    @RequestMapping(value = "/queryPayment",method = RequestMethod.GET)
    public CommonResponse<List<ContractPaymentVO>> queryPayment(
            @RequestParam(value = "contractId") String contractId){
        List<ContractPaymentVO> contractPayments = new ArrayList<>();
        ContractEntity contractEntity = service.selectById(contractId);
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);

            }
        }
        return CommonResponse.success("查询数据成功！",contractPayments);
    }

    /**
     * 付款阶段参照查询 后续删除
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractPaymentRef",method = RequestMethod.GET)
    public CommonResponse<List<ContractPaymentVO>> contractPaymentRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        List<ContractPaymentVO> contractPayments = new ArrayList<>();
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
        ContractEntity contractEntity = service.selectById((Serializable) conditionMap.get("contractId"));
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
            }
        }
        return CommonResponse.success("查询参照数据成功！",contractPayments);
    }


    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 新增或者修改补充协议
     *
     * @param supplement
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error("保存失败，主合同信息为空！");
        }
        return CommonResponse.success("查询详情数据成功！", service.saveOrUpdateSupplement(supplement, false));
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段 新增补充协议
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }


    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag) {
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }

    /**
     * 判断当前合同能否新增合同解除单据
     * @param id 合同主键
     * @return boolean
     */
    @RequestMapping(value = "/addRelieveFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        Boolean flag = contractRelieveService.isCanRelieve(id);
        return CommonResponse.success("校验该合同新增合同解除单据成功！", flag);
    }

    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/signatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        ContractEntity contractEntity = service.selectById(id);
        if (contractEntity != null){
            contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
            contractEntity.setFilingStatus(FilingStatusEnum.已归档.getTypeCode());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
            contractEntity.setEffectiveDate(new Date());
            service.saveOrUpdate(contractEntity);
        }
        return CommonResponse.success();
    }

    /**
     * 合同其他费用参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/prosubContractOtherCostRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> prosubContractOtherCostRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }

        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同其他费用查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        IPage<ContractOtherCostEntity> pageData= otherCostService.queryPage(queryParam,false);
        logger.info("分包合同其他费用查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractOtherCostVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同其他费用数据成功！",page);
    }

    @PostMapping(value = "/testPushContract")
    @ResponseBody
    public CommonResponse<ContractPoolVO> testPushContract(@RequestBody ContractVO contractVO) {
        ContractEntity contract = service.selectById(contractVO.getId());
        boolean pushContractResult = service.pushContract(BeanMapper.map(contract, ContractVO.class));
        if(pushContractResult) {
            return CommonResponse.success("合同数据推送合同池成功！");
        }

        return CommonResponse.error("合同数据推送合同池失败！");
    }

    @PostMapping(value = "/deleteContractFile")
    @ResponseBody
    public CommonResponse<Integer> deleteContractFile(@RequestBody ContractVO contractVO) {
        Integer contractVersion = service.deleteContractFileById(contractVO.getId());
        if(null != contractVersion && contractVersion.equals(-1)) {
            return CommonResponse.error("合同删除合同附件失败！");
        }
        return CommonResponse.success("合同删除合同附件成功！", contractVersion);
    }



    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ContractVO contractVO, HttpServletRequest req) {
        ContractVO cv;
        String linkUrl;
        if (null != contractVO.getSupplementFlag() && 1 == contractVO.getSupplementFlag()) {
            cv = service.saveOrUpdateSupplement(contractVO, true);
            linkUrl = service.getSupplementLinkUrl(cv);
        } else {
            String authority = req.getHeader("authority");
            cv = service.insertOrUpdate(contractVO, authority, true);
            linkUrl = service.getLinkUrl(cv);
        }

        //目标成本推送
        ExecutionVO executionVO = service.targetCost(cv,linkUrl,cv.getContractType(), cv.getContractType().equals(0) ? ProsubBillTypeEnum.劳务分包合同.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同.getBillTypeCode());
//        logger.error("分包合同，目标成本数据校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        logger.info("分包合同，目标成本数据校验结果：{}" , JSONObject.toJSONString(response));

        if (!response.isSuccess()) {
            logger.error("目标成本参数控制失败，返回信息-{}", response.getMsg());
            return response;
        }
        ParamsCheckVO responseData = paramCheck(contractVO, response, false);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        ContractEntity entity = service.selectById(id);
        ContractVO cv = BeanMapper.map(entity, ContractVO.class);
        //目标成本推送
        String linkUrl;
        if (null != cv.getSupplementFlag() && 1 == cv.getSupplementFlag()) {
            linkUrl = service.getSupplementLinkUrl(cv);
        } else {
            linkUrl = service.getLinkUrl(cv);
        }
        ExecutionVO executionVO = service.targetCost(cv,linkUrl,cv.getContractType(), cv.getContractType().equals(0) ? ProsubBillTypeEnum.劳务分包合同.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同.getBillTypeCode());
//        logger.error("分包合同，目标成本数据校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        logger.info("分包合同，目标成本数据校验结果：{}" , JSONObject.toJSONString(response));

        if (!response.isSuccess()) {
            logger.error("目标成本参数控制失败，返回信息-{}", response.getMsg());
            return response;
        }
        ParamsCheckVO responseData = paramCheck(cv, response, true);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    // 查询合同下所有单项结算末级清单
    @RequestMapping(value = "/queryLabProSettleDetails", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractSettleDetailsReportVO>> queryLabProSettleDetails(@RequestBody QueryParam queryParam) {
        IPage<ContractSettleDetailsReportVO> details = service.queryLabProSettleDetails(queryParam, false);
        return CommonResponse.success("查询成功", details);
    }

    // 导出合同下所有单项结算末级清单
    @RequestMapping(value = "/exportLabProSettleDetails", method = RequestMethod.POST)
    @ResponseBody
    public void exportLabProSettleDetails(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        IPage<ContractSettleDetailsReportVO> details = service.queryLabProSettleDetails(queryParam, true);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", details.getRecords());
        ExcelExport.getInstance().export("labProSettleDetails-export.xlsx", beans, response);
    }

    // 查询合同下所有单项结算末级清单，当点击结算数量查询当前合同清单下的所有结算单（需要根据结算单类型查询）
    @RequestMapping(value = "/queryLabProSettleDetailsList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractSettleDetailsReportVO>> queryLabProSettleDetailsList(Integer pageNumber, Integer pageSize,
                                                                              @RequestParam(required = false) String detailWorkContent,
                                                                              @RequestParam(required = false) String detailRule,
                                                                              @RequestParam String contractDetailId,
                                                                              @RequestParam String contractType,
                                                                              @RequestParam String settleType) {
        QueryParam queryParam = new QueryParam();
        if (pageNumber == null || pageNumber < 1) {
            pageNumber = 0;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        queryParam.setPageIndex(pageNumber - 1);
        queryParam.setPageSize(pageSize);
        IPage<ContractSettleDetailsReportVO> pageData = service.queryLabProSettleDetailsList(pageNumber - 1, pageSize, Long.parseLong(contractDetailId), Integer.parseInt(settleType), Integer.parseInt(contractType), detailWorkContent, detailRule);
        return CommonResponse.success("查询成功", pageData);
    }

    /**
     * 合同推送合同池
     *
     * @return
     */
    @PostMapping(value = "/pushContractToPool")
    @ResponseBody
    public CommonResponse<ContractVO> pushContractToPool(@RequestBody Long contractId) {
        JedisTemplate jedisTemplate = cacheManager.getJedisTemplate();
        //校验当前合同是否正在进行同步操作
        String contractIdStr = jedisTemplate.get(PUSH_POOL_PREFIX + contractId.toString());
        if(StringUtils.isNotBlank(contractIdStr)) {
            return CommonResponse.error("当前单据数据已处于同步操作中，请勿重复操作！");
        }
        //校验通过，执行合同同步操作
        jedisTemplate.set(PUSH_POOL_PREFIX + contractId.toString(), contractId.toString());

        ContractEntity dbEntity = service.selectById(contractId);
        if(null == dbEntity) {
            //删除合同同步控制标签
            jedisTemplate.del(PUSH_POOL_PREFIX + contractId.toString());
            return CommonResponse.error("合同推送合同池失败，未找到Id-"+ contractId +"匹配的合同");
        }
        ContractVO vo = BeanMapper.map(dbEntity, ContractVO.class);
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            data.setSourceType(vo.getContractType().equals(0) ? ContractTypeEnum.劳务分包合同.getTypeCode() : ContractTypeEnum.专业分包合同.getTypeCode());
            //走分支 区分是否参照定标结果
            String cardType = "";
            String routePath = "";
            if (vo.getAddType()==1){
                if (vo.getContractType()==1){
                    //专业
                    cardType = "proSubDirectCard";
                    routePath = "proSubList";
                }else if(vo.getContractType()==0) {
                    //劳务
                    cardType = "laborSubDirectCard";
                    routePath = "laborSubList";
                }
                //直接新增
            }else if (vo.getAddType()==0){
                //参照定标结果
                if (vo.getContractType()==1){
                    //专业
                    cardType ="proSubCard";
                    routePath = "proSubList";
                }else if(vo.getContractType()==0) {
                    //劳务
                    cardType ="laborSubCard";
                    routePath = "laborSubList";
                }
            }
            data.setMobileCardUrl("ejc-prosub-mobile/#/" + (vo.getContractType() == 1 ? "proContract" : "labContract") + "/card?id=" + vo.getId());
            data.setPcCardUrl("/ejc-prosub-frontend/#/"+routePath+"/contractMultiCards?id="+vo.getId()+"&supplementFlag="+vo.getSupplementFlag()+"&cardType="+cardType+"&performanceStatus="+vo.getPerformanceStatus());
            data.setAddType(0); //业务系统推送合同池
            logger.info("推送合同池 转换 对象：——————{}",JSONObject.toJSONString(data));

            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                if(BillPushStatusEnum.未成功推送.getStatus().equals(dbEntity.getBillPushFlag())) {
                    dbEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(dbEntity);
                }
                return CommonResponse.success("合同推送成功", vo);
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), JSONObject.toJSONString(transDataResp));
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        } finally {
            //删除合同同步控制标签
            jedisTemplate.del(PUSH_POOL_PREFIX + contractId.toString());
        }
        return CommonResponse.error("合同推送失败", vo);
    }

    /**
     * 参数控制
     * 劳务/专业分包合同-补充协议  【合同金额】控【补充协议金额】  补充协议金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     *
     * 劳务分包合同-签订（即保存时）、补充协议 【总计划量】控【合同量】 合同量  > 总计划量*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     *
     * 劳务分包合同-签订（即保存时）、补充协议 【总计划金额】控【合同金额】 合同金额  > 总计划金额*X% 默认100% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     *
     * 施工合同—劳务合同（包含补充协议) 【施工合同金额-专业合同金额】控【劳务合同金额】 劳务合同金额  > (施工合同金额-专业合同金额)*X% 默认30% 提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     *
     * 【施工合同】控【支出合同金额】接口
     *
     * @param contractVO
     * @param response
     * @param flag 是否是新增的数据：true是，false否
     * @return
     */
    private ParamsCheckVO paramCheck(ContractVO contractVO, CommonResponse<ParamsCheckVO> response, boolean flag) {
        Integer contractType = contractVO.getContractType();
        ParamsCheckVO responseData = response.getData();
        ParamsCheckVO resp = new ParamsCheckVO();

        List<ParamsCheckVO> allCheck = new ArrayList<>();
        if (null != contractVO.getSupplementFlag() && 1 == contractVO.getSupplementFlag()) {
            logger.info("【合同金额】控【补充协议金额】 start");
            // 只控制补充协议：【合同金额】控【补充协议金额】
            allCheck.addAll(service.supplementMnyCtrl(contractVO));
            logger.info("【合同金额】控【补充协议金额】 end");
        }
        // 【总计划量】控【合同量】
        logger.info("【总计划量】控【合同量】 start");
        allCheck.addAll(service.planNumCtrlContractNum(contractVO));
        logger.info("【总计划量】控【合同量】 end");

        // 【总计划金额】控【合同金额】
        logger.info("【【总计划金额】控【合同金额】 start");
        allCheck.addAll(service.planMnyCtrlContractMny(contractVO));
        logger.info("【【总计划金额】控【合同金额】 end");

        // 历史价控 合同价
        logger.info("历史价控 合同价 start");
        allCheck.addAll(service.historyPriceCtrlContractPrice(contractVO));
        logger.info("历史价控 合同价 end");

        // 目标成本价控 合同价
        logger.info("目标成本价控 合同价 start");
        allCheck.addAll(service.targetCostPriceCtrlContractPrice(contractVO));
        logger.info("目标成本价控 合同价 end");
        logger.info("allCheck:{}", JSONObject.toJSONString(allCheck));

        // 只控制劳务分包合同：【施工合同金额 - 专业合同金额】控【劳务分包合同金额】
        if (contractType != null && contractType == 0) {
            logger.info("【施工合同金额 - 专业合同金额】控【劳务分包合同金额】 start");
            allCheck.addAll(service.contractionMnyCtrlLabConMny(contractVO));
            logger.info("【施工合同金额 - 专业合同金额】控【劳务分包合同金额】 end");
        }

        // 【施工合同】控【支出合同金额】 接口
        CommonResponse<List<ParamsCheckVO>> ctrlOutConMnyRes = paramCheckApi.paramsCheck(contractVO.getProjectId(), contractVO.getId(), contractVO.getContractTaxMny(), contractVO.getOrgId());
        if (ctrlOutConMnyRes.isSuccess() && ctrlOutConMnyRes.getData() != null) {
            allCheck.addAll(ctrlOutConMnyRes.getData());
        }


        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }

        //如果目标成本预警登记小于等于参数控制预警登记
        if(null == responseData.getWarnType()  || ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) < ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            for(ParamsCheckVO p : result) {
                resp.getDataSource().addAll(p.getDataSource());
            }
        } else if(ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) == ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            if(CollectionUtils.isNotEmpty(responseData.getDataSource())) {
                resp.getDataSource().addAll(responseData.getDataSource());
            }
            for(ParamsCheckVO p : result) {
                resp.getDataSource().addAll(p.getDataSource());
            }
        } else { //否则
            return responseData;
        }

        return resp;
    }

    /**
     * @Description saveOrUpdate 查询当前合同下付款申请单列表
     * @param id
     */
    @RequestMapping(value = "/queryPaymentApplyList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractPaymentResultVO> query(Long id) {
        ContractPaymentResultVO vo = service.queryPaymentApplyList(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    /**
     * 分包打印详情处理
     *
     * @param detailJsonStr
     * @return
     */
    @PostMapping("/handlePrintDetail")
    @ResponseBody
    public CommonResponse<JSONObject> handlePrintDetail(@RequestBody String detailJsonStr) {
        String contractKey = null, detailKey = null, numKey = null;


        if(StringUtils.isBlank(detailJsonStr)) {
            return CommonResponse.success(null);
        }
        JSONObject data = JSONObject.parseObject(detailJsonStr);
        if(null == data) {
            return CommonResponse.success(null);
        }
        JSONObject detailJson = data.getJSONObject("detailJson");
        switch (data.getString("billType")) {
            case LABORSUB_Bill_CODE:
            case PROSUB_Bill_CODE:
                contractKey = "Contract";
                detailKey = "ContractDetail";
                numKey = "detailNum";
                break;
            case "BT220216000000004": //专业分包合同变更
            case "BT211108000000003": //劳务分包合同变更
                contractKey = "Change";
                detailKey = "ChangeDetail";
                numKey = "detailNum";
                break;
            case "BT220114000000002": //劳务分包过程结算
            case "BT220307000000007": //专业分包过程结算
                contractKey = "ProcessSettle";
                detailKey = "ProcessSettleDetail";
                numKey = "settleNum";
                break;
            case "BT220114000000003": //劳务分包节点结算
            case "BT220307000000008": //专业分包节点结算
                contractKey = "NodeSettle";
                detailKey = "NodeSettleDetail";
                numKey = "settleNum";
                break;
            case "BT220114000000004": //劳务分包完工结算
            case "BT220307000000009": //专业分包完工结算
                contractKey = "FinishSettle";
                detailKey = "FinishSettleDetail";
                numKey = "settleNum";
                break;
            default:
                return CommonResponse.error("错误的单据类型");
        }

        if(null == detailJson) {
            return CommonResponse.success(null);
        }
        JSONObject contract = detailJson.getJSONObject(contractKey);
        JSONArray detail = contract.getJSONArray(detailKey);
        final String finalNumKey = numKey;
        if(null != detail && detail.size() > 0) {
            contract.put(detailKey, detail.stream().filter(item -> StringUtils.isNotBlank(JSONObject.parseObject(JSONObject.toJSONString(item)).getString(finalNumKey))).collect(Collectors.toList()));
            detailJson.put(contractKey, contract);
        }

        return CommonResponse.success(detailJson);
    }


    /**
     * 分包合同目标成本推送数据
     *
     * @param id 合同id
     *
     * @return CommonResponse
     */
    @GetMapping(value = "/pushTargetCost")
    @ResponseBody
    public CommonResponse<String> pushTargetCost(@RequestParam("id") Long id) {
        service.pushTargetCost(id);
        return CommonResponse.success("手动：分包合同目标成本推送数据成功！");
    }

    //查询 劳务分包合同 参照
    /**
     * 合同查询接口 区分劳务 是否补充协议
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/proContractRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> proContractRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        //设置模糊查询
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

        if (!(null != conditionMap.get("orgId") || null != conditionMap.get("projectId"))){
            return CommonResponse.error("当前传入项目id 或 组织id为空！");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")){
            return CommonResponse.error("当前传入组织类型为空！");
        }
        //劳务还是 专业
        if (null != conditionMap.get("contractType")){
            queryParam.getParams().put("contractType",new Parameter(QueryParam.EQ,conditionMap.get("contractType")));
        }else {
            return CommonResponse.error("当前传入合同类型为空！");
        }
        //是否补充协议
        if (null != conditionMap.get("supplementFlag")){
            queryParam.getParams().put("supplementFlag",new Parameter(QueryParam.EQ,conditionMap.get("supplementFlag")));
        }

        if (null != conditionMap.get("changeStatus")){
            queryParam.getParams().put("changeStatus",new Parameter(QueryParam.EQ,conditionMap.get("changeStatus")));
        }



        if (null != conditionMap.get("projectId")){
            Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }else {

            //查询本下范围内日的合同
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }



        //查询已生效，未归档单据
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("filing_status", new Parameter(QueryParam.EQ, 0));
        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null != queryParam.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", queryParam.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);
        IPage<ContractEntity> pageData= service.queryPage(queryParam,false);
        logger.info("分包合同查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同数据成功！",page);
    }


}