package com.ejianc.business.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractFileService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;


@Service("contractFileService")
public class ContractFileServiceImpl implements IContractFileService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Autowired
    private IChangeService changeService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject updateSignedFileInfo(Long billId, String billType) {
        JSONObject resp = new JSONObject();

        ArrayList<ContractVO> cvs = new ArrayList<>();
        ContractVO cv = new ContractVO();
        // 根据billType区分主合同和变更
        if("contract".equals(billType)) {
            // 主合同
            // 查询合同详情
            ContractEntity entity = contractService.selectById(billId);
            Assert.notNull(entity, "查询不到主合同详情");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setSourceType(billType);

            // 区分劳务和专业
            if(entity.getContractType() == 0){
                // 劳务合同
                // 主合同和补充协议
                cv.setBillType(ProsubBillTypeEnum.劳务分包合同.getBillTypeCode());
            } else {
                // 专业合同
                cv.setBillType(ProsubBillTypeEnum.专业分包合同.getBillTypeCode());
            }
            cvs.add(cv);
        } else {
            // 变更
            // 查询合同详情
            ChangeEntity entity = changeService.selectById(billId);
            Assert.notNull(entity, "查询不到变更合同详情");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setSourceType(billType);

            // 区分劳务和专业
            if(entity.getContractType() == 0){
                // 劳务合同
                // 主合同和补充协议
                cv.setBillType(ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode());
            } else {
                // 专业合同
                cv.setBillType(ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode());
            }
            cvs.add(cv);
        }

        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
        if(!signResp.isSuccess()) {
            logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", billId, billType, signResp.getMsg());
        }else {
            List<SignMgrPreviewVO> fileList = signResp.getData();
            if(CollectionUtils.isEmpty(fileList)) {
                logger.error("未获取到合同签章文件信息");
            }else {
                SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
                if("contract".equals(billType)) {
                    ContractEntity contract = contractService.selectById(billId);
                    contract.setSignedFileId(signedFileInfo.getFileId());
                    contractService.saveOrUpdate(contract, false);
                } else {
                    ChangeEntity contractChange = changeService.selectById(billId);
                    contractChange.setChangeSignedFileId(signedFileInfo.getFileId());
                    changeService.saveOrUpdate(contractChange, false);
                }
                resp.put("fileId", signedFileInfo.getFileId());
                resp.put("filePath", signedFileInfo.getFilePath());
                resp.put("fileTruePath", signedFileInfo.getTruePath());
            }
        }
        return  resp;
    }
}
