/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.mapper.ContractDetailMapper;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.mapper.SettleDetailMapper;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.IProcessSettleService;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ProcessSettleService")
public class ProcessSettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements IProcessSettleService {
    private static final String LAB_CHECK_PARAM_CODE = "P-6F91n740";
    private static final String PRO_CHECK_PARAM_NAME = "P-7gO63u43";
    private static final String LAB_PROCESS_NUM_CHECK_PARAM_CODE = "P-2LuSuo75";
    private static final String PRO_PROCESS_NUM_CHECK_PARAM_NAME = "P-c38YSH76";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ContractDetailMapper contractDetailMapper;
    @Autowired
    private SettleDetailMapper settleDetailMapper;
    @Autowired
    private ISettleDetailService settleDetailService;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IDutyApi dutyApi;

    @Override
    public ParamsCheckVO mnyCtrl(SettleVO settleVO, Boolean flag) {
        CostCtrlVO costCtrlVO;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (null != settleVO.getProjectId() && null != settleVO.getOrgId()) {
            List<ParamsCheckVO> paramsCheckVOS = this.costProjectCheckParams(settleVO);
            paramsCheckVOS.get(0);
            if (paramsCheckVOS.size() > 0) {
                return paramsCheckVOS.get(0);
            }
        }
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        if (1 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, settleVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            BigDecimal contractTaxMny;
            ArrayList checkDsVOS = new ArrayList();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if ("none".equals(paramsCheck.getWarnType())) continue;
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
            if (null == contract) {
                this.logger.info("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            BigDecimal taxMny = settleVO.getTaxMny();
            BigDecimal totalTaxMny = this.settleService.getLastTaxMny(settleVO.getContractId(), SettleTypeEnum.\u8fc7\u7a0b.getCode(), taxMny, flag);
            if (totalTaxMny.compareTo(contractTaxMny = this.settleService.getContractTaxMny(contract.getContractTaxMny(), roleValue)) > 0) {
                BigDecimal overTaxMny = this.settleService.getOverTaxMny(totalTaxMny, contractTaxMny);
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\uff1a").append(taxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u7ed3\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                checkDsVOS.add(paramsCheckDsVO);
                paramsCheck.setDataSource((List)checkDsVOS);
                paramsCheckVOList.add(paramsCheck);
                continue;
            }
            paramsCheck.setWarnType(paramsArray[0]);
        }
        if (null == settleVO.getId()) {
            settleVO.setId(Long.valueOf(IdWorker.getId()));
        }
        List settlementDetailList = settleVO.getSettleDetailList();
        ArrayList<SettleDetailVO> settlementDetailListNew = new ArrayList<SettleDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)settlementDetailList)) {
            for (SettleDetailVO cdEntity : settlementDetailList) {
                if (null == cdEntity.getId()) {
                    cdEntity.setId(Long.valueOf(IdWorker.getId()));
                    cdEntity.setSettleId(settleVO.getId());
                }
                if ("del".equals(cdEntity.getRowState())) continue;
                settlementDetailListNew.add(cdEntity);
            }
            settleVO.setSettleDetailList(settlementDetailListNew);
        }
        ExecutionVO executionVO = this.settleService.prepareExecutionVO((SettleEntity)((Object)BeanMapper.map((Object)settleVO, SettleEntity.class)));
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a7\u5236\u5931\u8d25," + response.getMsg());
        }
        ParamsCheckVO tarRes = (ParamsCheckVO)response.getData();
        if (null != tarRes) {
            paramsCheckVOList.add(tarRes);
        }
        if (null != (costCtrlVO = this.settleService.sjCost(settleVO))) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOList.add(costRes);
            }
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    public List<ParamsCheckVO> costProjectCheckParams(SettleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse booleanCommonResponse = this.dutyApi.queryDutyByProjectId(vo.getProjectId());
        if (!booleanCommonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (!((Boolean)booleanCommonResponse.getData()).booleanValue()) {
            CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId("P-ilUA850193", vo.getOrgId());
            if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
                List data = (List)billParamByCodeAndOrgId.getData();
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (BillParamVO billParamByCode : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        String orgName = billParamByCode.getOrgName();
                        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        paramsCheckVO.setWarnType("alert");
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u65e0\u76ee\u6807\u6210\u672c\u63a7\u7ed3\u7b97");
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnName("\u8be5\u9879\u76ee\u6ca1\u6709\u7f16\u5236\u76ee\u6807\u8d23\u4efb\u6210\u672c");
                        paramsCheckDsVO.setContent("\u8be5\u9879\u76ee\u6ca1\u6709\u7f16\u5236\u76ee\u6807\u8d23\u4efb\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u7ed3\u7b97\u5355");
                        checkDsVOS.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            } else {
                this.logger.info(billParamByCodeAndOrgId.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO numCtrl(SettleVO settleVO, Boolean flag) {
        this.logger.info("ProcessSettleServiceImpl--numCtrl()--begin--\u5f53\u524d\u4e3a\u8fc7\u7a0b\u7ed3\u7b97\uff0c\u3010\u5408\u540c\u91cf\u3011\u63a7\u3010\u6708\u5ea6\u7ed3\u7b97\u91cf\u3011--\u5165\u53c2\uff1asettleVO={}", (Object)JSONObject.toJSONString((Object)settleVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(LAB_PROCESS_NUM_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        if (1 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PRO_PROCESS_NUM_CHECK_PARAM_NAME, settleVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheck.getWarnType())) {
                List<Map<String, Object>> contractDetailSettleNumQueryMaps;
                Long tenantid = InvocationInfoProxy.getTenantid();
                List settleDetailList = settleVO.getSettleDetailList();
                HashMap<Long, SettleDetailVO> settleDetailMap = new HashMap<Long, SettleDetailVO>();
                ArrayList<Long> settleDetailIdList = new ArrayList<Long>();
                HashMap<Long, BigDecimal> settleNumMap = new HashMap<Long, BigDecimal>();
                if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
                    for (SettleDetailVO settleDetailVO : settleDetailList) {
                        if (settleDetailVO.getDetailNum() == null || "del".equals(settleDetailVO.getRowState())) continue;
                        settleDetailMap.put(settleDetailVO.getContractDetailId(), settleDetailVO);
                        if (settleDetailVO.getId() != null) {
                            settleDetailIdList.add(settleDetailVO.getId());
                        }
                        BigDecimal settleNum = settleDetailVO.getSettleNum() == null ? BigDecimal.ZERO : settleDetailVO.getSettleNum();
                        BigDecimal settleNumTotalOld = (BigDecimal)settleNumMap.get(settleDetailVO.getContractDetailId());
                        settleNumTotalOld = settleNumTotalOld == null ? BigDecimal.ZERO : settleNumTotalOld;
                        settleNumMap.put(settleDetailVO.getContractDetailId(), settleNumTotalOld.add(settleNum));
                    }
                }
                this.logger.info("\u5f85\u4fdd\u5b58\u6570\u636e\u540c\u4e00\u5408\u540c\u6e05\u5355\u4e0b\u7684\u672c\u671f\u7ed3\u7b97\u91cf\u7684\u4e3a\uff1amap={}", (Object)JSONObject.toJSONString(settleNumMap));
                List contractDetailEntityList = new ArrayList();
                QueryWrapper cdWrapper = new QueryWrapper();
                Set settleNumMapKeySet = settleNumMap.keySet();
                if (MapUtils.isNotEmpty(settleNumMap)) {
                    cdWrapper = new QueryWrapper();
                    ((QueryWrapper)((QueryWrapper)cdWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).in((Object)"id", settleNumMapKeySet);
                    contractDetailEntityList = this.contractDetailMapper.selectList((Wrapper)cdWrapper);
                }
                this.logger.info("\u67e5\u8be2\u5230\u7684\u5f85\u4fdd\u5b58\u6570\u636e\u6240\u5c5e\u7684\u5408\u540c\u6e05\u5355\u6570\u636e\uff1alist={}", (Object)JSONObject.toJSONString(contractDetailEntityList));
                HashMap<Long, Object> contractDetailEntityMap = new HashMap<Long, Object>();
                if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
                    for (Object contractDetailEntity : contractDetailEntityList) {
                        contractDetailEntityMap.put(contractDetailEntity.getId(), contractDetailEntity);
                    }
                }
                HashMap<Long, BigDecimal> cdSettleNumMap = new HashMap<Long, BigDecimal>();
                if (MapUtils.isNotEmpty(settleNumMap) && settleNumMapKeySet.size() > 0) {
                    Object contractDetailEntity;
                    contractDetailEntity = settleNumMapKeySet.iterator();
                    while (contractDetailEntity.hasNext()) {
                        Long key = (Long)contractDetailEntity.next();
                        cdSettleNumMap.put(key, BigDecimal.ZERO);
                    }
                }
                if (CollectionUtils.isNotEmpty(settleNumMapKeySet) && CollectionUtils.isNotEmpty(contractDetailSettleNumQueryMaps = this.settleDetailMapper.queryCountSettleNumByContractSettleType(tenantid, 0, new ArrayList<Long>(settleNumMapKeySet), CollectionUtils.isNotEmpty(settleDetailIdList) ? settleDetailIdList : null))) {
                    for (Map<String, Object> detailSettleNumQueryMap : contractDetailSettleNumQueryMaps) {
                        if (MapUtils.isEmpty(detailSettleNumQueryMap)) continue;
                        Object settleNumTotalObj = detailSettleNumQueryMap.get("settleTotalNum");
                        cdSettleNumMap.put(Long.parseLong(detailSettleNumQueryMap.get("contractDetailId").toString()), new BigDecimal(settleNumTotalObj != null ? settleNumTotalObj.toString() : "0"));
                    }
                }
                this.logger.info("\u67e5\u8be2\u5230\u7684\u5f85\u4fdd\u5b58\u6570\u636e\u7684\u7ed3\u7b97\u6e05\u5355\u6240\u5728\u7684\u5408\u540c\u6e05\u5355\u7684\u665a\u671f\u7684\u672c\u671f\u7ed3\u7b97\u91cf\u7684\u7d2f\u8ba1\u503c\uff1amap={}", (Object)JSONObject.toJSONString(cdSettleNumMap));
                if (MapUtils.isNotEmpty(settleDetailMap)) {
                    Set keySet = settleDetailMap.keySet();
                    if (keySet.size() > 0) {
                        this.logger.info("\u53c2\u6570\u63a7\u5236----begin");
                        for (Long key : keySet) {
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355id\uff1aid={}", (Object)JSONObject.toJSONString((Object)key));
                            BigDecimal settleNumTotalOld = (BigDecimal)cdSettleNumMap.get(key);
                            settleNumTotalOld = settleNumTotalOld == null ? BigDecimal.ZERO : settleNumTotalOld;
                            this.logger.info("\u5408\u540c\u6e05\u5355\u4e0b\u7684\u4e0d\u542b\u672c\u671f\u7d2f\u8ba1\u7ed3\u7b97\u91cf\u4e3a:settleNumTotalOld={}", (Object)settleNumTotalOld);
                            BigDecimal settleNum = (BigDecimal)settleNumMap.get(key);
                            settleNum = settleNum == null ? BigDecimal.ZERO : settleNum;
                            this.logger.info("\u5f85\u4fdd\u5b58\u7684\u7ed3\u7b97\u6e05\u5355\u540c\u4e00\u5408\u540c\u6e05\u5355\u4e0b\u7684\u672c\u671f\u7ed3\u7b97\u91cf\u4e3a:settleNum={}", (Object)settleNum);
                            BigDecimal settleTotalNum = settleNumTotalOld.add(settleNum);
                            this.logger.info("\u5408\u540c\u6e05\u5355\u4e0b\u7684\u542b\u672c\u671f\u7d2f\u8ba1\u7ed3\u7b97\u91cf\u4e3a:settleTotalNum={}", (Object)settleTotalNum);
                            ContractDetailEntity cdEntiey = (ContractDetailEntity)((Object)contractDetailEntityMap.get(key));
                            if (cdEntiey == null) continue;
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355\u6570\u636e\uff1acontractDetailVO={}", (Object)JSONObject.toJSONString((Object)((Object)cdEntiey)));
                            String detailName = cdEntiey.getDetailName();
                            detailName = StringUtils.isBlank((String)detailName) ? "" : detailName;
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355\u540d\u79f0\uff1adetailName={}", (Object)detailName);
                            String detailRule = cdEntiey.getDetailMeasurementRules();
                            detailRule = StringUtils.isBlank((String)detailRule) ? "" : detailRule;
                            this.logger.info("\u5f53\u524d\u8ba1\u91cf\u89c4\u5219\uff1adetailRule={}", (Object)detailRule);
                            BigDecimal detailNum = cdEntiey.getDetailNum() == null ? BigDecimal.ZERO : cdEntiey.getDetailNum();
                            this.logger.info("\u5f53\u524d\u5408\u540c\u91cf\uff1adetailNum={}", (Object)detailNum);
                            BigDecimal conNum = detailNum.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                            this.logger.info("\u5f53\u524d\u5408\u540c\u91cf*" + roleValue.toString() + "%\uff1aconNum={}", (Object)conNum);
                            this.logger.info("\u518d\u6b21\u6253\u5370\u65e5\u5fd7\uff0c\u542b\u672c\u671f\u7d2f\u8ba1\u7ed3\u7b97\u91cf = {}\uff0c\u5408\u540c\u91cf*" + roleValue.toString() + "% = {}", (Object)settleTotalNum, (Object)conNum);
                            if (settleTotalNum.compareTo(conNum) <= 0) continue;
                            BigDecimal overNum = settleTotalNum.subtract(conNum);
                            this.logger.info("\u8d85\u51fa\u6570\u91cf={}", (Object)overNum);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setWarnItem(detailName + detailRule);
                            paramsCheckDsVO.setWarnName("\u8fc7\u7a0b\u7ed3\u7b97\u6570\u91cf\u5927\u4e8e\u5408\u540c\u6570\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u8fc7\u7a0b\u7ed3\u7b97\u6570\u91cf\uff1a").append(settleNum.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u8fc7\u7a0b\u7ed3\u7b97\u6570\u91cf\uff1a").append(settleTotalNum.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%\uff1a").append(conNum.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(overNum.setScale(2, RoundingMode.DOWN));
                            paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            dataSource.add(paramsCheckDsVO);
                            paramsCheck.setDataSource(dataSource);
                        }
                        this.logger.info("\u53c2\u6570\u63a7\u5236--end");
                    } else {
                        paramsCheck.setWarnType(paramsArray[0]);
                    }
                } else {
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
            this.logger.info("ProcessSettleServiceImpl--numCtrl()--end--\u5f53\u524d\u4e3a\u8fc7\u7a0b\u7ed3\u7b97\uff0c\u3010\u5408\u540c\u91cf\u3011\u63a7\u3010\u8fc7\u7a0b\u7ed3\u7b97\u91cf\u3011--\u8fd4\u56de\u7ed3\u679c\uff1aparamsCheckVO={}", (Object)JSONObject.toJSONString((Object)paramsCheck));
            paramsCheckVOList.add(paramsCheck);
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }
}

