package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanChangeHisEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanChangeHisMapper;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.plan.mapper.PlanDetailChangeMapper;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailChangeService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.business.plan.vo.PlanDetailChangeVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包总计划变更实体
 * 
 * @author generator
 * 
 */
@Service("planChangeService")
public class PlanChangeServiceImpl extends BaseServiceImpl<PlanChangeMapper, PlanChangeEntity> implements IPlanChangeService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanService masterPlanService;
    @Autowired
    private PlanChangeMapper planChangeMapper;
    @Autowired
    private PlanDetailChangeMapper masterPlanDetailChangeMapper;
    @Autowired
    private PlanChangeHisMapper masterPlanChangeHisMapper;
    @Autowired
    private IPlanDetailChangeService masterPlanDetailChangeService;

    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @Autowired
    private IPlanService planService;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public PlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper<PlanChangeEntity> query = new QueryWrapper<>();
        query.eq("source_plan_id", sourcePlanId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return planChangeMapper.selectOne(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PlanChangeEntity saveOrUpdatePlanChange(PlanChangeEntity saveEntity, Boolean isControl) {
        if (Boolean.FALSE.equals(isControl)) {
            if(CollectionUtils.isNotEmpty(saveEntity.getPlanDetailList())) {
                //更新子表信息
            /*if(null != saveEntity.getId()) {
                masterPlanDetailChangeMapper.delByPlanId(saveEntity.getId());
            }*/
            }
            super.saveOrUpdate(saveEntity, false);

            PlanEntity planEntity = masterPlanService.selectById(saveEntity.getSourcePlanId());
            if(1 != planEntity.getChangeState()) {
                planEntity.setChangeState(1);
                planEntity.setChangeId(saveEntity.getId());
                masterPlanService.saveOrUpdate(planEntity, false);
            }
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangePlan(List<Long> changeIds) {
        List<PlanChangeEntity> changeList = planChangeMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(PlanChangeEntity::getSourcePlanId).collect(Collectors.toList());

        QueryWrapper<PlanEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<PlanEntity> planList = masterPlanService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<PlanChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_plan_id as planId");
        query.in("source_plan_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_plan_id");

        List<Map<String, Object>> queryResult =masterPlanChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for(PlanEntity plan : planList) {
            plan.setChangeState((null !=hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? 2 : 0); //未变更
            plan.setChangeId(null);
        }

        masterPlanService.saveOrUpdateBatch(planList, planList.size());

        super.removeByIds(changeList.stream().map(PlanChangeEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<PlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<PlanChangeEntity> lambda = Wrappers.<PlanChangeEntity>lambdaQuery();
        lambda.eq(PlanChangeEntity::getSourcePlanId, id);
        lambda.in(PlanChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PlanChangeEntity> entities = super.list(lambda);
        List<PlanChangeHisVO> recordVOList = BeanMapper.mapList(entities, PlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
                    if(recordVO.getChangeVersion() < 10){
                        recordVO.setHistoryCode(recordVO.getBillCode() + "-0" + recordVO.getChangeVersion());
                    }else{
                        recordVO.setHistoryCode(recordVO.getBillCode() + "-" + recordVO.getChangeVersion());
                    }
                }
        );
        return recordVOList;
    }

    @Override
    public PlanChangeVO queryDetail(Long id, boolean detailHasChildren) {
        PlanChangeEntity masterPlanChangeEntity = super.selectById(id);
        PlanChangeVO masterPlanChangeVO = BeanMapper.map(masterPlanChangeEntity, PlanChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<PlanDetailChangeEntity> masterPlanDetailChangeEntities = masterPlanDetailChangeService.queryList(queryParam, false);
        List<PlanDetailChangeEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(masterPlanDetailChangeEntities)) {
            masterPlanDetailChangeEntities.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(PlanDetailChangeEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
            }
            List<PlanDetailChangeVO> resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailChangeVO.class);


            //判断当前清单是否被下游引用，如果引用，则该条数据不能被删除。
            //判断清单是否被下游数据引用（合同、招标）
            List<PlanDetailChangeVO> usefulDetailList = selectUsefulByIds(resultMapList.stream().map(PlanDetailChangeVO::getTargetId).collect(Collectors.toList()));

            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)){
                for (PlanDetailChangeVO c : usefulDetailList){
                    usefulDetailMap.put(c.getId(), c.getUseNum());
                }
            }
            for (PlanDetailChangeVO c : resultMapList){
                if (null != usefulDetailMap.get(c.getTargetId())){
                    //如果被下游引用，则改变rowState不能删除
                    c.setUseNum(1);
                    c.setRowState("edit");
                }else {
                    c.setUseNum(null);
                }
            }


            if(detailHasChildren){
                masterPlanChangeVO.setPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                masterPlanChangeVO.setPlanDetailList(resultMapList);
            }
        } else {
            masterPlanChangeVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailChangeVO.class));
        }

        return masterPlanChangeVO;
    }

    //查询当前明细id集合中的id是否被下游业务使用（合同、定标）
    @Override
    public List<PlanDetailChangeVO> selectUsefulByIds(List<Long> planIdList) {
        return masterPlanDetailChangeMapper.selectUsefulByIds(planIdList);
    }

    @Override
    public ExecutionVO targetCost(PlanChangeVO planChangeVO, String linkUrl, Integer subType, String billTypeCode, boolean lastSourceId){
        ExecutionVO executionVO = new ExecutionVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(planChangeVO.getId());
        totalVO.setTenantId(planChangeVO.getTenantId());
        totalVO.setBillCode(planChangeVO.getBillCode());
        totalVO.setOrgId(planChangeVO.getOrgId());
        totalVO.setBillType(billTypeCode);

        //新增变更并且为控制校验时，将上一版本的Id传入
        if(lastSourceId) {
            if(null == planChangeVO.getId()) {
                totalVO.setLastSourceId(getLastExecutionVO(planChangeVO.getSourcePlanId()).getTotalVO().getSourceId());
            } else {
                PlanChangeEntity change = super.selectById(planChangeVO.getId());
                if(null == change) {
                    totalVO.setLastSourceId(getLastExecutionVO(planChangeVO.getSourcePlanId()).getTotalVO().getSourceId());
                }
            }
        }

        if (subType==0){
            totalVO.setBussinessType(BussinessTypeEnum.劳务分包总计划.getCode());
        }else {
            totalVO.setBussinessType(BussinessTypeEnum.专业分包总计划.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setProjectId(planChangeVO.getProjectId());
        totalVO.setOrgId(planChangeVO.getOrgId());
        totalVO.setMoney(planChangeVO.getTotalPlanMny()); //总计划金额无税
        totalVO.setTaxMoney(planChangeVO.getTotalPlanTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        if(null != planChangeVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(planChangeVO.getCreateTime()));
        }
        totalVO.setMemo(planChangeVO.getChangeReason());

        if (CollectionUtils.isNotEmpty(planChangeVO.getPlanDetailList())) {
            List<PlanDetailChangeVO> planDetailChangeVOS = planChangeVO.getPlanDetailList().stream()
                    .filter(item -> item.getLeafFlag() && !"del".equals(item.getRowState()) && (null == item.getChangeType() || !item.getChangeType().equals(5))).collect(Collectors.toList());
            Assert.notEmpty(planDetailChangeVOS, "清单数据不能为空");
            for (PlanDetailChangeVO planDetailVO : planDetailChangeVOS) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getPlanId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId()); // 档案分类ID
                // 根据档案id判断是否是分类
                if (planDetailVO.getDocId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(false);

                // 根据档案分类id查询档案分类信息
                Assert.notNull(planDetailVO.getDocCategoryId(), "档案分类id不能为空");
                if (0 == subType){
                    // 劳务分包
                    CommonResponse<LabsubCategoryVO> res = shareLabsubApi.queryLabSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类ID:{}",planDetailVO.getDocCategoryId());
                        throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                    }
                    LabsubCategoryVO categoryVO = res.getData();
                    if (categoryVO==null){
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                } else {
                    // 专业分包
                    CommonResponse<ProsubCategoryVO> res = shareLabsubApi.queryMajorSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        logger.error("根据档案分类id查询专业分包档案分类信息失败,档案分类ID:{}",planDetailVO.getDocCategoryId());
                        throw new BusinessException("根据分类ID查询专业分包档案分类信息失败!");
                    }
                    ProsubCategoryVO categoryVO = res.getData();
                    if (categoryVO==null){
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                }

                // 档案id
                Assert.notNull(planDetailVO.getDocId(), "档案id不能为空");
                detailExecutionVO.setDocId(planDetailVO.getDocId());
                if (subType==0){
                    detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                }else {
                    detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setName(planDetailVO.getDetailName());
                // todo: 单位id
                // detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setPrice(planDetailVO.getPlanPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getPlanTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                if(null != planDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(planDetailVO.getCreateTime()));
                }
                detailExecutionVO.setMemo(planDetailVO.getMemo());
                detailExecutionVO.setSpec(planDetailVO.getDetailMeasureRules());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setNum(planDetailVO.getPlanNum());
                detailExecutionVO.setMoney(planDetailVO.getPlanMny());
                detailExecutionVO.setTaxMoney(planDetailVO.getPlanTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ExecutionVO getLastExecutionVO(Long sourcePlanId) {
        QueryWrapper<PlanChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("source_plan_id", sourcePlanId).orderByDesc("create_time");
        List<PlanChangeEntity> list = super.list(wrapper);

        PlanChangeEntity tmp = null;
        String linkUrl = null;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BASE_HOST;
        }
        //判断是否有过变更
        if (!list.isEmpty()){
            tmp = list.get(0);

            QueryWrapper<PlanDetailChangeEntity> detailWrapper = new QueryWrapper<>();
            detailWrapper.eq("plan_id", tmp.getId());
            tmp.setPlanDetailList(masterPlanDetailChangeMapper.selectList(detailWrapper));

            if (tmp.getSubType()==0){
                linkUrl = frontendBaseHost+"ejc-prosub-frontend/#/labSubPlan/changeCard?id="+tmp.getId();
            }else {
                linkUrl = frontendBaseHost+"ejc-prosub-frontend/#/proSubPlan/changeCard?id="+tmp.getId();
            }
            // 变更取原总计划id
            return targetCost(BeanMapper.map(tmp, PlanChangeVO.class), linkUrl, tmp.getSubType(), tmp.getSubType().equals(0) ? ProsubBillTypeEnum.劳务分包总计划变更.getBillTypeCode() : ProsubBillTypeEnum.专业分包总计划变更.getBillTypeCode(), false);
        }else {
            PlanEntity planEntity = planService.selectById(sourcePlanId);
            if (planEntity.getSubType()==0){
                linkUrl = frontendBaseHost+"ejc-prosub-frontend/#/labSubPlan/card?id="+planEntity.getId();
            }else {
                linkUrl = frontendBaseHost+"ejc-prosub-frontend/#/proSubPlan/card?id="+planEntity.getId();
            }
            return planService.targetCost(BeanMapper.map(planEntity, PlanVO.class), linkUrl, planEntity.getSubType());
        }
    }
}
