/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statistic"})
public class StatisticController
implements Serializable {
    @Autowired
    private IRegistrationService service;

    @RequestMapping(value={"/getRegistrationInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getRegistrationInfo(Long projectDepartmentId, String regionDate) {
        JSONObject jo = new JSONObject();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        if (projectDepartmentId != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.select(new String[]{"count(id) AS businessCount , IFNULL(sum(total_tax_mny) , 0 ) AS totalTaxMny"});
            wrapper.in((Object)"bill_state", list);
            wrapper.eq((Object)"org_id", (Object)projectDepartmentId);
            if (StringUtils.isNotBlank((String)regionDate)) {
                String[] split = regionDate.split(",");
                wrapper.ge((Object)"region_date", (Object)split[0]);
                wrapper.le((Object)"region_date", (Object)split[1]);
            }
            RegistrationEntity one = (RegistrationEntity)((Object)this.service.getOne((Wrapper)wrapper));
            jo.put("businessCount", (Object)one.getBusinessCount());
            jo.put("totalTaxMny", (Object)one.getTotalTaxMny());
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jo);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u7f3a\u5c11\u9879\u76ee\u90e8id\uff01", (Object)jo);
    }
}

