package com.ejianc.business.contract.freeze.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * 合同冻结表
 */
@TableName("ejc_prosub_contract_freeze")
public class FreezeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     *  项目Id
     */
    @TableField(value="project_id")
    private java.lang.Long projectId;
    /**
     * 项目名称（带入）
     */
    @TableField(value="project_name")
    private java.lang.String projectName;
    /**
     * 项目编码
     */
    @TableField(value="project_code")
    private java.lang.String projectCode;
    /**
     * 合同名称
     */
    @TableField(value="contract_name")
    private java.lang.String contractName;
    /**
     * 合同id
     */
    @TableField(value="contract_id")
    private java.lang.Long contractId;
    /**
     * 合同编码
     */
    @TableField(value="contract_code")
    private java.lang.String contractCode;
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    @TableField(value="contract_type")
    private java.lang.Integer contractType;
    /**
     * 合同类型：0-主合同 1-补充协议
     */
    @TableField(value="contract_flag")
    private java.lang.Integer contractFlag;
    /**
     * 项目部id
     */
    @TableField(value="org_id")
    private java.lang.Long orgId;
    /**
     * 项目部名称
     */
    @TableField(value="org_name")
    private java.lang.String orgName;
    /**
     * 项目部编码
     */
    @TableField(value="org_code")
    private java.lang.String orgCode;
    /**
     * 项目部所属组织id
     */
    @TableField(value="parent_org_id")
    private java.lang.Long parentOrgId;
    /**
     * 项目部所属组织名称
     */
    @TableField(value="parent_org_name")
    private java.lang.String parentOrgName;
    /**
     * 供应商id(乙方)
     */
    @TableField(value="parent_org_code")
    private java.lang.String parentOrgCode;
    /**
     * 供应商id(乙方)
     */
    @TableField(value="supplier_id")
    private java.lang.Long supplierId;
    /**
     * 供应商名称（乙方）
     */
    @TableField(value="supplier_name")
    private java.lang.String supplierName;
    /**
     * 申请人 即经办人
     */
    @TableField(value="employee_id")
    private java.lang.Long employeeId;
    /**
     * 申请人信息 即经办人
     */
    @TableField(value="employee_name")
    private java.lang.String employeeName;
    /**
     *经办单位id
     */
    @TableField(value="department_id")
    private java.lang.Long departmentId;
    /**
     * 经办单位
     */
    @TableField(value="department_name")
    private java.lang.String departmentName;
    /**
     * 经办单位编码
     */
    @TableField(value="department_code")
    private java.lang.String departmentCode;
    /**
     * 甲方
     */
    @TableField(value="first_party_name")
    private java.lang.String firstPartyName;
    /**
     * 甲方id
     */
    @TableField(value="first_party_id")
    private java.lang.Long firstPartyId;
    /**
     *   冻结/取消冻结 原因
     */
    @TableField(value="freeze_cause")
    private java.lang.String freezeCause;
    /**
     *  合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结
     */
    @TableField(value="performance_status")
    private java.lang.Integer performanceStatus;
    /**
     * 单据编号
     */
    @TableField(value="bill_code")
    private java.lang.String billCode;
    /**
     *  冻结日期（默认当前时间 可修改）
     */
    @TableField(value="freeze_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date freezeDate;
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    @TableField(value="bill_state")
    private java.lang.Integer billState;
    /**
     *
     */
    @TableField(value = "bill_type_code")
    private String billTypeCode;

    @TableField(value = "commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "effective_date")
    private Date effectiveDate; // 生效日期

    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    /**
     * 项目Id
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称（带入）
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称（带入）
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public java.lang.String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(java.lang.String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public java.lang.Integer getContractType() {
        return contractType;
    }

    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public void setContractType(java.lang.Integer contractType) {
        this.contractType = contractType;
    }
    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public java.lang.Integer getSupplementFlag() {
        return contractFlag;
    }

    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public void setSupplementFlag(java.lang.Integer supplementFlag) {
        this.contractFlag = supplementFlag;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public java.lang.String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(java.lang.String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部所属组织id
     */
    public java.lang.Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    public void setParentOrgId(java.lang.Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织名称
     */
    public java.lang.String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(java.lang.String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部所属组织编码
     */
    public java.lang.String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(java.lang.String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 供应商id(乙方)
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id(乙方)
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称（乙方）
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称（乙方）
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 申请人 即经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 申请人 即经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请人信息 即经办人
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 申请人信息 即经办人
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    /**
     * 甲方
     */
    public java.lang.String getFirstPartyName() {
        return firstPartyName;
    }

    /**
     * 甲方
     */
    public void setFirstPartyName(java.lang.String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    /**
     * 甲方id
     */
    public java.lang.Long getFirstPartyId() {
        return firstPartyId;
    }

    /**
     * 甲方id
     */
    public void setFirstPartyId(java.lang.Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    /**
     * 冻结/取消冻结 原因
     */
    public java.lang.String getFreezeCause() {
        return freezeCause;
    }

    /**
     * 冻结/取消冻结 原因
     */
    public void setFreezeCause(java.lang.String freezeCause) {
        this.freezeCause = freezeCause;
    }
    /**
     * 合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结
     */
    public java.lang.Integer getPerformanceStatus() {
        return performanceStatus;
    }

    /**
     * 合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结
     */
    public void setPerformanceStatus(java.lang.Integer performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 冻结日期（默认当前时间 可修改）
     */
    public java.util.Date getFreezeDate() {
        return freezeDate;
    }

    /**
     * 冻结日期（默认当前时间 可修改）
     */
    public void setFreezeDate(java.util.Date freezeDate) {
        this.freezeDate = freezeDate;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }

}
