/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.process.bean.MeasureEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.mapper.MeasureMapper;
import com.ejianc.business.process.service.IMeasureService;
import com.ejianc.business.process.vo.MeasureVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="measureService")
public class MeasureServiceImpl
extends BaseServiceImpl<MeasureMapper, MeasureEntity>
implements IMeasureService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "MEASURE_BILL_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/measure/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/measure/billDel";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    private final String billType = "BT211227000000002";
    private final String LAB_MEASURE_PARAM_CODE = "P-964Bf984";
    private final String PRO_MEASURE_PARAM_CODE = "P-Ctsd6X85";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(MeasureEntity measureEntity, String billTypeCode, CooperateVO cooperate) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + measureEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(measureEntity.getId(), false);
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)measureEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        measureEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        measureEntity.setTenantId(null);
        if (CollectionUtils.isNotEmpty(measureEntity.getMeasureDetailList())) {
            measureEntity.getMeasureDetailList().forEach(item -> item.setTenantId(null));
        }
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MEASURE_BILL_SYNC", (int)600);
            if (!locked) {
                this.executeUpdate(measureEntity.getId(), false);
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "MEASURE_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)((Object)measureEntity)));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(measureEntity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)measureEntity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/measure/billSync", paramMap, measureEntity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        this.executeUpdate(measureEntity.getId(), true);
                        syncFlag = true;
                    } else {
                        this.executeUpdate(measureEntity.getId(), false);
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba1\u91cf\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{measureEntity.getSupplierId(), measureEntity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.executeUpdate(measureEntity.getId(), false);
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba1\u91cf\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{measureEntity.getId(), measureEntity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.executeUpdate(measureEntity.getId(), false);
                this.logger.error("\u83b7\u53d6\u8ba1\u91cf\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)measureEntity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.executeUpdate(measureEntity.getId(), false);
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{measureEntity.getId(), measureEntity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "MEASURE_BILL_SYNC");
        }
        return syncFlag;
    }

    private void executeUpdate(Long id, Boolean flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.update((Wrapper)updateWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.valueOf(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u5355\u636e\u7b7e\u7ae0\u901a\u77e5\uff1aid-{}, supOperatorName-{}, supOperatorPhone-{}, supOperatorUserCode-{}, supOperateTime-{}, nameSourceTypeMapping-{}", new Object[]{billId, supOperatorName, supOperatorPhone, supOperatorUserCode, supOperateTime, nameSourceTypeMapping});
        MeasureEntity measure = (MeasureEntity)((Object)super.selectById((Serializable)((Object)billId)));
        measure.setSupOperateTime(supOperateTime);
        measure.setSupOperatorName(supOperatorName);
        measure.setSupOperatorPhone(supOperatorPhone);
        measure.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT211227000000002::" + measure.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MEASURE_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "MEASURE_BILL_SYNC");
                String string = "\u5355\u636e\u7b7e\u5b57\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, "BT211227000000002", authority, measure.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            measure.setAttachIds(attchIdsList);
            measure.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
            super.saveOrUpdate((Object)measure, false);
            String msgSendResult = this.sendMsg(measure, "\u4f9b\u65b9\u5df2\u7b7e\u5b57\u63d0\u9192", "\u8ba1\u91cf\u5355\u636e[" + measure.getBillCode() + "]\u4f9b\u65b9\u5df2\u7b7e\u5b57\u5b8c\u6210");
            if (null != msgSendResult) {
                this.logger.error("\u5411\u7528\u6237-{}\u53d1\u9001\u5355\u636eid-{}\u7b7e\u5b57\u63d0\u9192\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{StringUtils.join((Object[])new Long[]{measure.getCreateUserId(), measure.getEmployeeId()}), measure.getId(), msgSendResult});
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)measure.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "MEASURE_BILL_SYNC");
        }
        return msg;
    }

    private String sendMsg(MeasureEntity measure, String subject, String content) {
        Object[] msgRecUserIds = new String[]{measure.getCreateUserId().toString(), measure.getEmployeeId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(measure.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delPushBill(MeasureEntity measureEntity, String billTypeCode) {
        boolean locked = false;
        boolean delSuc = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + measureEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u8ba1\u91cf\u5355\u636e-{}\u4f5c\u5e9f\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)measureEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
        }
        measureEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MEASURE_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "MEASURE_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sourceId", measureEntity.getId().toString());
            paramMap.put("sourceSystemId", measureEntity.getSourceSystemId());
            this.logger.info("\u8ba1\u91cf\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)measureEntity.getSupplierId(), (Object)measureEntity.getId());
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/measure/billDel", RequestMethod.POST, JSONObject.toJSONString(paramMap), measureEntity.getSupplierId().toString());
            if (syncReqResp.isSuccess()) {
                CommonResponse supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    delSuc = true;
                } else {
                    this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u8ba1\u91cf\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{measureEntity.getSupplierId(), measureEntity.getId(), supHandleResp.getMsg()});
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{measureEntity.getSupplierId(), measureEntity.getId(), syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)measureEntity.getId(), (Object)e);
        }
        finally {
            this.releaseLock(jedis, locked, key, "MEASURE_BILL_SYNC");
        }
        return delSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public ParamsCheckVO mnyCtrl(MeasureVO measureVO, boolean flag) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == measureVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-964Bf984", measureVO.getOrgId());
        }
        if (1 == measureVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-Ctsd6X85", measureVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheck.getWarnType())) {
                Long contractId = measureVO.getContractId();
                QueryWrapper measureEntityQueryWrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)measureEntityQueryWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"contract_id", (Object)contractId);
                if (flag && measureVO.getId() != null) {
                    measureEntityQueryWrapper.notIn((Object)"id", Arrays.asList(measureVO.getId()));
                }
                measureEntityQueryWrapper.select(new String[]{"sum(total_tax_mny) as totalTaxMny"});
                Map measureMnyMap = super.getMap((Wrapper)measureEntityQueryWrapper);
                BigDecimal totalTaxMny = BigDecimal.ZERO;
                if (measureMnyMap != null) {
                    totalTaxMny = measureMnyMap.get("totalTaxMny") != null ? new BigDecimal(measureMnyMap.get("totalTaxMny").toString()) : BigDecimal.ZERO;
                }
                BigDecimal curTotalTaxMny = measureVO.getTotalTaxMny() != null ? measureVO.getTotalTaxMny() : BigDecimal.ZERO;
                totalTaxMny = totalTaxMny.add(curTotalTaxMny);
                ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
                if (contractEntity == null) {
                    this.logger.info("\u67e5\u8be2\u5408\u540c\u5931\u8d25\uff01");
                    throw new BusinessException("\u67e5\u8be2\u5408\u540c\u5931\u8d25\uff01");
                }
                BigDecimal contractTaxMny = contractEntity.getContractTaxMny();
                contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
                BigDecimal conTaxMny = contractTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                if (totalTaxMny.compareTo(conTaxMny) > 0) {
                    BigDecimal overTaxMny = totalTaxMny.subtract(conTaxMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u8fdb\u5ea6\u8ba1\u91cf\u8d85\u5408\u540c\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8fdb\u5ea6\u8ba1\u91cf\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u8fdb\u5ea6\u8ba1\u91cf\u91d1\u989d\uff1a").append(curTotalTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u8fdb\u5ea6\u8ba1\u91cf\u91d1\u989d\uff1a").append(totalTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(conTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheck.setDataSource(dataSource);
                } else {
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
            paramsCheckVOList.add(paramsCheck);
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }
}

