package com.ejianc.business.settle.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 结算子表-分包清单
 *
 * @author generator
 */
@TableName("ejc_prosub_settle_detail")
public class SettleDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "use_flag")
    private Integer useFlag; // 是否引用过,否-0，是-1
    @TableField(value = "settle_id")
    private Long settleId; // 结算id
    @TableField(value = "contract_id")
    private Long contractId; // 合同id
    @TableField(value = "contract_type")
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    @TableField(value = "settle_type")
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    @TableField(value = "project_id")
    private Long projectId; // 项目Id
    @TableField(value = "settle_date")
    private Date settleDate; // 结算日期
    @TableField(value = "source_type")
    private String sourceType; // 来源:合同，分包计量， 结算单
    @TableField(value = "source_id")
    private Long sourceId; // 来源id
    @TableField(value = "source_bill_id")
    private Long sourceBillId; // 来源主单据id
    @TableField(value = "source_bill_date")
    private Date sourceBillDate; // 来源主单据日期
    @TableField(value = "source_bill_code")
    private String sourceBillCode; // 来源主单据编号
    @TableField(value = "contract_detail_id")
    private Long contractDetailId; // 合同清单id
    @TableField(value = "doc_id")
    private Long docId; // 档案id
    @TableField(value = "doc_category_id")
    private Long docCategoryId; // 档案分类id
    @TableField(value = "detail_name")
    private String detailName; // 清单名称
    @TableField(value = "detail_measurement_rules")
    private String detailMeasurementRules; // 工作计量规则
    @TableField(value = "detail_work_content")
    private String detailWorkContent; // 工作内容
    @TableField(value = "detail_unit")
    private String detailUnit; // 单位
    @TableField(value = "detail_num")
    private BigDecimal detailNum; // 合同量
    @TableField(value = "total_process_num")
    private BigDecimal totalProcessNum; // 含本期累计过程结算量：取该清单在已生效过程结算单中累计结算量+本期结算量；如果有多行对应合同同一个清单，本期结算量是多行的累计值
    @TableField(value = "last_process_num")
    private BigDecimal lastProcessNum; // 历史过程结算量：该清单在已生效过程结算单中累计结算量
    @TableField(value = "total_node_num")
    private BigDecimal totalNodeNum; // 累计节点结算量：取该清单在已生效的节点结算单中累计结算量+本期结算量
    @TableField(value = "last_node_num")
    private BigDecimal lastNodeNum; // 历史节点结算量：该清单在已生效节点结算单中累计结算量
    @TableField(value = "settle_num")
    private BigDecimal settleNum; // 本期结算量：=累计节点结算量—过程累计结算量
    @TableField(value = "detail_tax_price")
    private BigDecimal detailTaxPrice; // 单价(含税)
    @TableField(value = "detail_price")
    private BigDecimal detailPrice; // 单价(无税)
    @TableField(value = "detail_tax_rate")
    private BigDecimal detailTaxRate; // 税率
    @TableField(value = "settle_tax_mny")
    private BigDecimal settleTaxMny; // 本期结算金额
    @TableField(value = "settle_mny")
    private BigDecimal settleMny; // 本期结算金额(无税)
    @TableField(value = "settle_tax")
    private BigDecimal settleTax; // 本期结算税额
    @TableField(value = "process_tax_difference")
    private BigDecimal processTaxDifference; // 过程结算差额
    @TableField(value = "process_difference")
    private BigDecimal processDifference; // 过程结算差额（无税）
    @TableField(value = "node_tax_difference")
    private BigDecimal nodeTaxDifference; // 节点结算差额
    @TableField(value = "node_difference")
    private BigDecimal nodeDifference; // 节点结算差额（无税）
    @TableField(value = "memo")
    private String memo; // 备注

    @TableField("tree_index") //序号
    private String treeIndex;
    @TableField("parent_id") //树形父id
    private Long parentId;

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;
    @TableField("total_settle_dif_num")
    private BigDecimal totalSettleDifNum;//累计结算差量


    @TableField("settle_ratio")
    private BigDecimal settleRatio;//结算比例

    @TableField(value = "detail_artificial_tax_mny")
    private BigDecimal detailArtificialTaxMny; // 人工费金额（含税）

    @TableField("detail_artificial_tax_price")
    private BigDecimal detailArtificialTaxPrice; //人工费单价（含税）

    @TableField(value = "detail_wbs_id")
    private Long detailWbsId; // 核算对象主键
    @TableField(value = "detail_wbs_name")
    private String detailWbsName; // 核算对象名称
    @TableField(value = "detail_wbs_code")
    private String detailWbsCode; // 核算对象编码
    @TableField(value = "detail_subject_id")
    private Long detailSubjectId; // 成本科目主键
    @TableField(value = "detail_subject_name")
    private String detailSubjectName; // 成本科目名称
    @TableField(value = "detail_subject_code")
    private String detailSubjectCode; // 成本科目编码

    @TableField("detail_settle_payment_ratio")
    private BigDecimal detailSettlePaymentRatio;//本期结算支付比例
    @TableField(value = "detail_settle_payment_mny")
    private BigDecimal detailSettlePaymentMny; // 本期结算支付金额
    @TableField(value = "detail_settle_payment_tax_mny")
    private BigDecimal detailSettlePaymentTaxMny; // 本期结算支付金额（含税）


    public Long getDetailWbsId() {
        return detailWbsId;
    }

    public void setDetailWbsId(Long detailWbsId) {
        this.detailWbsId = detailWbsId;
    }

    public String getDetailWbsName() {
        return detailWbsName;
    }

    public void setDetailWbsName(String detailWbsName) {
        this.detailWbsName = detailWbsName;
    }

    public String getDetailWbsCode() {
        return detailWbsCode;
    }

    public void setDetailWbsCode(String detailWbsCode) {
        this.detailWbsCode = detailWbsCode;
    }

    public Long getDetailSubjectId() {
        return detailSubjectId;
    }

    public void setDetailSubjectId(Long detailSubjectId) {
        this.detailSubjectId = detailSubjectId;
    }

    public String getDetailSubjectName() {
        return detailSubjectName;
    }

    public void setDetailSubjectName(String detailSubjectName) {
        this.detailSubjectName = detailSubjectName;
    }

    public String getDetailSubjectCode() {
        return detailSubjectCode;
    }

    public void setDetailSubjectCode(String detailSubjectCode) {
        this.detailSubjectCode = detailSubjectCode;
    }

    public BigDecimal getSettleRatio() {
        return settleRatio;
    }

    public void setSettleRatio(BigDecimal settleRatio) {
        this.settleRatio = settleRatio;
    }

    public BigDecimal getTotalSettleDifNum() {
        return totalSettleDifNum;
    }

    public void setTotalSettleDifNum(BigDecimal totalSettleDifNum) {
        this.totalSettleDifNum = totalSettleDifNum;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }

    public Date getSourceBillDate() {
        return sourceBillDate;
    }

    public void setSourceBillDate(Date sourceBillDate) {
        this.sourceBillDate = sourceBillDate;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }

    public BigDecimal getTotalProcessNum() {
        return totalProcessNum;
    }

    public void setTotalProcessNum(BigDecimal totalProcessNum) {
        this.totalProcessNum = totalProcessNum;
    }

    public BigDecimal getLastProcessNum() {
        return lastProcessNum;
    }

    public void setLastProcessNum(BigDecimal lastProcessNum) {
        this.lastProcessNum = lastProcessNum;
    }

    public BigDecimal getTotalNodeNum() {
        return totalNodeNum;
    }

    public void setTotalNodeNum(BigDecimal totalNodeNum) {
        this.totalNodeNum = totalNodeNum;
    }

    public BigDecimal getLastNodeNum() {
        return lastNodeNum;
    }

    public void setLastNodeNum(BigDecimal lastNodeNum) {
        this.lastNodeNum = lastNodeNum;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }

    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }

    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public BigDecimal getProcessTaxDifference() {
        return processTaxDifference;
    }

    public void setProcessTaxDifference(BigDecimal processTaxDifference) {
        this.processTaxDifference = processTaxDifference;
    }

    public BigDecimal getProcessDifference() {
        return processDifference;
    }

    public void setProcessDifference(BigDecimal processDifference) {
        this.processDifference = processDifference;
    }

    public BigDecimal getNodeTaxDifference() {
        return nodeTaxDifference;
    }

    public void setNodeTaxDifference(BigDecimal nodeTaxDifference) {
        this.nodeTaxDifference = nodeTaxDifference;
    }

    public BigDecimal getNodeDifference() {
        return nodeDifference;
    }

    public void setNodeDifference(BigDecimal nodeDifference) {
        this.nodeDifference = nodeDifference;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public BigDecimal getDetailArtificialTaxMny() {
        return detailArtificialTaxMny;
    }

    public void setDetailArtificialTaxMny(BigDecimal detailArtificialTaxMny) {
        this.detailArtificialTaxMny = detailArtificialTaxMny;
    }

    public BigDecimal getDetailArtificialTaxPrice() {
        return detailArtificialTaxPrice;
    }

    public void setDetailArtificialTaxPrice(BigDecimal detailArtificialTaxPrice) {
        this.detailArtificialTaxPrice = detailArtificialTaxPrice;
    }

    public BigDecimal getDetailSettlePaymentRatio() {
        return detailSettlePaymentRatio;
    }

    public void setDetailSettlePaymentRatio(BigDecimal detailSettlePaymentRatio) {
        this.detailSettlePaymentRatio = detailSettlePaymentRatio;
    }

    public BigDecimal getDetailSettlePaymentMny() {
        return detailSettlePaymentMny;
    }

    public void setDetailSettlePaymentMny(BigDecimal detailSettlePaymentMny) {
        this.detailSettlePaymentMny = detailSettlePaymentMny;
    }

    public BigDecimal getDetailSettlePaymentTaxMny() {
        return detailSettlePaymentTaxMny;
    }

    public void setDetailSettlePaymentTaxMny(BigDecimal detailSettlePaymentTaxMny) {
        this.detailSettlePaymentTaxMny = detailSettlePaymentTaxMny;
    }
}
