package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanMapper;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanContrastV0;
import com.ejianc.business.plan.vo.PlanDetailVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包总计划实体
 * 
 * @author generator
 * 
 */
@Service("planService")
public class PlanServiceImpl extends BaseServiceImpl<PlanMapper, PlanEntity> implements IPlanService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PlanMapper planMapper;
    @Autowired
    private IPlanChangeService planChangeService;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @Override
    public PlanVO queryByCode(String planCode) {
        PlanVO resp = null;
        QueryWrapper<PlanEntity> query = new QueryWrapper<>();
        query.eq("bill_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PlanEntity entity = planMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PlanVO.class);
        }
        return resp;
    }

    @Override
    public PlanVO queryByProjectId(Long projectId, Integer subType) {
        PlanVO resp = null;
        QueryWrapper<PlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("sub_type", subType);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PlanEntity entity = planMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PlanVO.class);
        }
        return resp;
    }

    @Override
    public PlanVO saveOrUpdateMasterPlan(PlanEntity saveEntity, Boolean isControl) {
        if(Boolean.FALSE.equals(isControl)) {
            //更新子表信息
            super.saveOrUpdate(saveEntity, false);
        }
        PlanVO planVO = null;
        List<PlanDetailEntity> detailEntityList = saveEntity.getPlanDetailList();
        if(CollectionUtils.isNotEmpty(detailEntityList)){
            if (Boolean.FALSE.equals(isControl)) {
                planVO = queryDetail(saveEntity.getId(), true);
            } else {
                planVO = BeanMapper.map(saveEntity, PlanVO.class);
            }
        }
        return planVO;
    }

    @Override
    public PlanVO queryDetail(Long id, boolean detailHasChildren) {
        PlanEntity masterPlanEntity = super.selectById(id);
        PlanVO masterPlanVO =  BeanMapper.map(masterPlanEntity, PlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<PlanDetailEntity> detailEntityListDb = planDetailService.queryList(queryParam, false);
        List<PlanDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        //设置总计划详情
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(PlanDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
            }
            List<PlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailVO.class);

            //判断当前清单是否被下游引用，如果引用，则该条数据不能被删除。
            //判断清单是否被下游数据引用（合同、招标）
            List<PlanDetailVO> usefulDetailList = selectUsefulByIds(resultMapList.stream().map(PlanDetailVO::getId).collect(Collectors.toList()));

            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)){
                for (PlanDetailVO c : usefulDetailList){
                    usefulDetailMap.put(c.getId(), c.getUseNum());
                }
            }
            for (PlanDetailVO c : resultMapList){
                if (null != usefulDetailMap.get(c.getId())){
                    //如果被下游引用，则改变rowState不能删除
                    c.setUseNum(1);
                    c.setRowState("edit");
                }else {
                    c.setUseNum(null);
                }
            }


            if(detailHasChildren){
                masterPlanVO.setPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                masterPlanVO.setPlanDetailList(resultMapList);
            }
        } else {
            masterPlanVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailVO.class));
        }

        if(null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0){
            masterPlanVO.setPlanChangeHisList(planChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }

        return masterPlanVO;
    }

    //查询当前明细id集合中的id是否被下游业务使用（合同、定标）
    @Override
    public List<PlanDetailVO> selectUsefulByIds(List<Long> planIdList) {
        return planMapper.selectUsefulByIds(planIdList);
    }

    @Override
    public List<PlanContrastV0> getContrastInfo(Long planId, Long oldPlanId) {
        return planMapper.getContrastInfo(planId,oldPlanId);
    }


    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            }else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<PlanDetailEntity> entities){
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, PlanDetailEntity.class));
        }
    }

    @Override
    public ExecutionVO targetCost(PlanVO planVO, String linkUrl, Integer subType){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(planVO.getId());
        totalVO.setTenantId(planVO.getTenantId());
        totalVO.setBillCode(planVO.getBillCode());
        totalVO.setOrgId(planVO.getOrgId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (subType==0){
            totalVO.setBillType(ProsubBillTypeEnum.劳务分包总计划.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.劳务分包总计划.getCode());
        }else {
            totalVO.setBillType(ProsubBillTypeEnum.专业分包总计划.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.专业分包总计划.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setProjectId(planVO.getProjectId());
        totalVO.setOrgId(planVO.getOrgId());
        totalVO.setMoney(planVO.getTotalPlanMny()); //总计划金额无税
        totalVO.setTaxMoney(planVO.getTotalPlanTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        if(null != planVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(planVO.getCreateTime()));
        }
        totalVO.setMemo(planVO.getMemo());

        if (CollectionUtils.isNotEmpty(planVO.getPlanDetailList())) {
            List<PlanDetailVO> planDetailVOS = planVO.getPlanDetailList().stream().filter(item -> item.getLeafFlag() && !"del".equals(item.getRowState())).collect(Collectors.toList());
            Assert.notEmpty(planDetailVOS, "计划明细不能为空");
            for (PlanDetailVO planDetailVO : planDetailVOS) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getPlanId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId()); // 档案分类id
                // 根据档案id判断是否是分类
                if (planDetailVO.getDocId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(false);

                // 根据档案分类id查询档案分类信息
                Assert.notNull(planDetailVO.getDocCategoryId(), "档案分类id不能为空");
                if (0 == subType){
                    // 劳务分包
                    CommonResponse<LabsubCategoryVO> res = shareLabsubApi.queryLabSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类ID:{}",planDetailVO.getDocCategoryId());
                        throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                    }
                    LabsubCategoryVO categoryVO = res.getData();
                    if (categoryVO==null){
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                } else {
                    // 专业分包
                    CommonResponse<ProsubCategoryVO> res = shareLabsubApi.queryMajorSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        logger.error("根据档案分类id查询专业分包档案分类信息失败,档案分类ID:{}",planDetailVO.getDocCategoryId());
                        throw new BusinessException("根据分类ID查询专业分包档案分类信息失败!");
                    }
                    ProsubCategoryVO categoryVO = res.getData();
                    if (categoryVO==null){
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                }

                // 档案id
                Assert.notNull(planDetailVO.getDocId(), "档案id不能为空");
                detailExecutionVO.setDocId(planDetailVO.getDocId());
                if (subType==0){
                    detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                }else {
                    detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setName(planDetailVO.getDetailName());

                // todo:增加单位id
                // detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setPrice(planDetailVO.getPlanPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getPlanTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                if(null != planDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(planDetailVO.getCreateTime()));
                }
                detailExecutionVO.setMemo(planDetailVO.getMemo());
                detailExecutionVO.setSpec(planDetailVO.getDetailMeasureRules());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setNum(planDetailVO.getPlanNum());
                detailExecutionVO.setMoney(planDetailVO.getPlanMny());
                detailExecutionVO.setTaxMoney(planDetailVO.getPlanTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}
