package com.ejianc.business.process.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.process.vo.RegistrationTeamVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 零工登记主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_oldjob_registration")
public class RegistrationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     *   项目Id
     */
    @TableField(value="project_id")
    private java.lang.Long projectId;
    /**
     * 项目名称（带入）
     */
    @TableField(value="project_name")
    private java.lang.String projectName;
    /**
     * 项目编码
     */
    @TableField(value="project_code")
    private java.lang.String projectCode;
    /**
     * 合同名称
     */
    @TableField(value="contract_name")
    private java.lang.String contractName;
    /**
     * 合同id
     */
    @TableField(value="contract_id")
    private java.lang.Long contractId;
    /**
     * 合同编码
     */
    @TableField(value="contract_code")
    private java.lang.String contractCode;
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    @TableField(value="contract_type")
    private java.lang.Integer contractType;
    /**
     * 合同类别：0-主合同 1-补充协议
     */
    @TableField(value="supplement_flag")
    private java.lang.Integer supplementFlag;
    /**
     * 项目部id
     */
    @TableField(value="org_id")
    private java.lang.Long orgId;
    /**
     * 项目部名称
     */
    @TableField(value="org_name")
    private java.lang.String orgName;
    /**
     * 项目部编码
     */
    @TableField(value="org_code")
    private java.lang.String orgCode;
    /**
     * 项目部所属组织id
     */
    @TableField(value="parent_org_id")
    private java.lang.Long parentOrgId;
    /**
     * 项目部所属组织名称
     */
    @TableField(value="parent_org_name")
    private java.lang.String parentOrgName;
    /**
     *  项目部所属组织编码
     */
    @TableField(value="parent_org_code")
    private java.lang.String parentOrgCode;
    @TableField(value = "first_party_id")
    private Long firstPartyId;// 甲方Id
    @TableField(value = "first_party_name")
    private String firstPartyName;// 甲方名称
    /**
     * 供应商id(乙方)
     */
    @TableField(value="supplier_id")
    private java.lang.Long supplierId;
    /**
     * 供应商名称（乙方）
     */
    @TableField(value="supplier_name")
    private java.lang.String supplierName;
    /**
     * 申请人 即经办人
     */
    @TableField(value="employee_id")
    private java.lang.Long employeeId;
    /**
     * 申请人信息 即经办人
     */
    @TableField(value="employee_name")
    private java.lang.String employeeName;
    /**
     *  经办部门id
     */
    @TableField(value="department_id")
    private Long departmentId;
    /**
     *  经办部门
     */
    @TableField(value="department_name")
    private String departmentName;
    /**
     *  用工内容 手动输入 1-50个字，必填项
    /**
     *来源：0-自制、1-申请单—单据编号
     */
    @TableField(value="bill_type")
    private java.lang.Integer billType;
    /**
     *  来源名称
     */
    @TableField(value="bill_type_name")
    private String billTypeName;
    /**
     * 用工类型id
     */
    @TableField(value = "use_work_type_id")
    private Long useWorkTypeId;
    /**
     * 用工类型名称
     */
    @TableField(value = "use_work_type_name")
    private String useWorkTypeName;
    /**
     *  用工内容 手动输入 1-50个字，必填项
     */
    @TableField(value="use_work_detail")
    private java.lang.String useWorkDetail;
    /**
     *零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    @TableField(value="total_tax_mny")
    private java.math.BigDecimal totalTaxMny;
    /**
     *零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    @TableField(value="total_mny")
    private java.math.BigDecimal totalMny;

    @TableField(value="total_tax")
    private java.math.BigDecimal totalTax;

    /**
     *签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
     */
    @TableField(value="supplier_sign_status")
    private java.lang.Integer supplierSignStatus;
    /**
     * 单据编号
     */
    @TableField(value="bill_code")
    private java.lang.String billCode;
    /**
     *单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    @TableField(value="bill_state")
    private java.lang.Integer billState;

    @TableField(value = "commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value = "application_id")
    private Long applicationId;//申请单id
    @TableField(value = "region_type")
    private Integer regionType;//登记类型 0- 零工登记； 1-零工转扣


    /**
     * 用工日期
     */
    @TableField(value = "region_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date regionDate;

    @TableField(exist = false)
    private List<Long> fileIds;//文件id


    /**
     *   班组id
     */
    @TableField(value="team_id")
    private Long teamId;
    /**
     * 班组名称（带入）
     */
    @TableField(value="team_name")
    private String teamName;
    /**
     * 班组编码
     */
    @TableField(value="team_code")
    private String teamCode;


    /**
     *零工登记 子表 清单明细
     */
    @TableField(exist=false)
    @SubEntity(serviceName="registrationDetailService",pidName = "registrationId")
    private List<RegistrationDetailEntity> detailList = new ArrayList<>();

    /**
     *零工登记子表 转扣表实体
     */
    @TableField(exist=false)
    @SubEntity(serviceName="registrationDeductService" ,pidName = "registrationId")
    private List<RegistrationDeductEntity> deductList = new ArrayList<>();
    /**
     *零工登记子表 班组转扣表实体
     */
    @TableField(exist=false)
    @SubEntity(serviceName="registrationTeamService" ,pidName = "registrationId")
    private List<RegistrationTeamEntity> teamList = new ArrayList<>(); // 零工登记子表 转扣表实体


    /**
     * 制单人Id
     */
    @TableField(value = "create_user_id")
    private Long createUserId;

    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;

    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String sourceSystemId;

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;

    /**
     * 业务笔数 门户统计使用
     */
    @TableField(exist = false)
    private Integer businessCount;

    public Integer getBusinessCount() {
        return businessCount;
    }

    public void setBusinessCount(Integer businessCount) {
        this.businessCount = businessCount;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    /***  协同需要字段 END  ***/


    public Integer getRegionType() {
        return regionType;
    }

    public void setRegionType(Integer regionType) {
        this.regionType = regionType;
    }
    public List<Long> getFileIds() {
        return fileIds;
    }

    public void setFileIds(List<Long> fileIds) {
        this.fileIds = fileIds;
    }
    public BigDecimal getTotalTax() {
        return totalTax;
    }

    public void setTotalTax(BigDecimal totalTax) {
        this.totalTax = totalTax;
    }

    public Date getRegionDate() {
        return regionDate;
    }

    public void setRegionDate(Date regionDate) {
        this.regionDate = regionDate;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /**
     * 项目Id
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称（带入）
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称（带入）
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public java.lang.String getContractCode() {
        return contractCode;
    }

    public List<RegistrationTeamEntity> getTeamList() {
        return teamList;
    }

    public void setTeamList(List<RegistrationTeamEntity> teamList) {
        this.teamList = teamList;
    }

    /**
     * 合同编码
     */
    public void setContractCode(java.lang.String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public java.lang.Integer getContractType() {
        return contractType;
    }

    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public void setContractType(java.lang.Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    /**
     * 项目部id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public java.lang.String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(java.lang.String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部所属组织id
     */
    public java.lang.Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    public void setParentOrgId(java.lang.Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织名称
     */
    public java.lang.String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(java.lang.String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部所属组织编码
     */
    public java.lang.String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(java.lang.String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    /**
     * 供应商id(乙方)
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id(乙方)
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称（乙方）
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称（乙方）
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 申请人 即经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 申请人 即经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请人信息 即经办人
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 申请人信息 即经办人
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * 来源：0-自制、1-申请单—单据编号
     */
    public java.lang.Integer getBillType() {
        return billType;
    }

    /**
     * 来源：0-自制、1-申请单—单据编号
     */
    public void setBillType(java.lang.Integer billType) {
        this.billType = billType;
    }

    /**
     * 来源名称
     */
    public String getBillTypeName() {
        return billTypeName;
    }

    /**
     * 来源名称
     */
    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    /**
     * 用工类型id
     */
    public Long getUseWorkTypeId() {
        return useWorkTypeId;
    }

    /**
     * 用工类型id
     */
    @ReferDeserialTransfer
    public void setUseWorkTypeId(Long useWorkTypeId
    ) {
        this.useWorkTypeId = useWorkTypeId;
    }

    /**
     * 用工类型名称
     */
    public String getUseWorkTypeName() {
        return useWorkTypeName;
    }

    /**
     * 用工类型名称
     */
    public void setUseWorkTypeName(String useWorkTypeName) {
        this.useWorkTypeName = useWorkTypeName;
    }

    /**
     * 用工内容 手动输入 1-50个字，必填项
     */
    public java.lang.String getUseWorkDetail() {
        return useWorkDetail;
    }

    /**
     * 用工内容 手动输入 1-50个字，必填项
     */
    public void setUseWorkDetail(java.lang.String useWorkDetail) {
        this.useWorkDetail = useWorkDetail;
    }
    /**
     * 零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    public java.math.BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    /**
     * 零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    public void setTotalTaxMny(java.math.BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }
    /**
     * 零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    public java.math.BigDecimal getTotalMny() {
        return totalMny;
    }

    /**
     * 零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    public void setTotalMny(java.math.BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    /**
     * 签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
     */
    public java.lang.Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    /**
     * 签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
     */
    public void setSupplierSignStatus(java.lang.Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    
    /**
     * 零工登记 子表 清单明细
     */
    public List<RegistrationDetailEntity> getDetailList() {
        return detailList;
    }

    /**
     * 零工登记 子表 清单明细
     */
    public void setDetailList(List<RegistrationDetailEntity> detailList) {
        this.detailList = detailList;
    }
    /**
     * 零工登记子表 转扣表实体
     */
    public List<RegistrationDeductEntity> getDeductList() {
        return deductList;
    }

    /**
     * 零工登记子表 转扣表实体
     */
    public void setDeductList(List<RegistrationDeductEntity> deductList) {
        this.deductList = deductList;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }
}
