package com.ejianc.business.settle.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 签章状态
 */
public enum SignStatusEnum {

    /**
     * 签字状态：1、未签字
     */
    未签字(1, "未签字"),
    /**
     * 签字状态：2、待乙方签字；
     */
    待乙方签字(2, "待乙方签字"),
    /**
     * 签字状态：3、待甲方签字；
     */
    待甲方签字(3, "待甲方签字"),
    /**
     * 签字状态：4、已签字；
     */
    已签字(4, "已签字");


    private static Map<Integer, SignStatusEnum> enumMap = new HashMap<>();

    static {
        enumMap = EnumSet.allOf(SignStatusEnum.class).stream().collect(Collectors.toMap(SignStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    private final Integer code;
    private final String description;

    SignStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static SignStatusEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }
}
