package com.ejianc.business.settle.mapper;


import com.ejianc.business.prosub.settlePayment.SettlePaymentVO;
import com.ejianc.business.prosub.vo.SourceBliVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.vo.SettleDeductVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 结算主实体
 *
 * @author generator
 */
@Mapper
public interface SettleMapper extends BaseCrudMapper<SettleEntity> {
    /**
     * 查找结算日期最大值
     *
     */
    Date selectMaxSettleDate(Long contractId);

    /**
     * 查询 领料结算 累计过程结算金额
     * @param contractId
     * @return
     */
    SettleVO selectPickingProcessTaxMny(@Param(value = "contractId") Long contractId);

    /**
     * 查询 零工登记 累计过程结算金额
     * @param contractId
     * @return
     */
    SettleVO selectOddjobProcessTaxMny(@Param(value = "contractId") Long contractId);

    /**
     * 查询 奖罚扣款单 累计过程结算金额
     * @param contractId
     * @return
     */
    List<SettleDeductVO> selectDeductList(@Param(value = "contractId") Long contractId);

    /**
     * 查询 其他费用 累计过程结算金额
     * @param contractId
     * @return
     */
    SettleVO selectOtherProcessTaxMny(@Param(value = "contractId") Long contractId);


    SourceBliVO getSourceBliVO(@Param("supplierId") Long supplierId, @Param("orgIds") List<Long> orgIds, @Param("dateIn") String dateIn);


    List<Long> queryCanCostPush();

    /**
     * 通过合同id查询跟该合同有关的节点结算、支付比例确认单总数
     * @param contractId
     * @return
     */
    int queryContractSettleNumOfNode(@Param("contractId") Long contractId);

    /**
     * 通过合同id查询 已提交或审批通过的节点结算的 结算金额之和
     * @param contractId
     * @return
     */
    SettlePaymentVO selectTotalNodeSettleMny(@Param("contractId") Long contractId);
}
