/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.process.bean.SalaryEntity;
import com.ejianc.business.process.mapper.SalaryMapper;
import com.ejianc.business.process.service.ISalaryService;
import com.ejianc.business.process.vo.ImprotSalaryDetailVO;
import com.ejianc.business.process.vo.SalaryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="salaryService")
public class SalaryServiceImpl
extends BaseServiceImpl<SalaryMapper, SalaryEntity>
implements ISalaryService {
    @Autowired
    private SalaryMapper salaryMapper;
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex = "/(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)/";

    @Override
    public List<SalaryVO> checkContract(Long contractId, String belongMonth) {
        return this.salaryMapper.checkContract(contractId, belongMonth);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImprotSalaryDetailVO> successList = new ArrayList<ImprotSalaryDetailVO>();
        ArrayList<ImprotSalaryDetailVO> errorList = new ArrayList<ImprotSalaryDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 13) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ImprotSalaryDetailVO salaryDetailVO = new ImprotSalaryDetailVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    salaryDetailVO.setErrorMessage("\u540d\u5b57\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(0)).length() > 20 || ((String)datas.get(0)).length() == 1) {
                    salaryDetailVO.setErrorMessage("\u540d\u5b57\u586b\u5199\u957f\u5ea6\u4e3a1~20\u5b57");
                }
                salaryDetailVO.setWorkerName((String)datas.get(0));
                if (((String)datas.get(1)).length() > 20) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u5de5\u79cd\u957f\u5ea6\u4e3a0~20\u5b57");
                }
                salaryDetailVO.setWorkType((String)datas.get(1));
                if (((String)datas.get(2)).length() > 18) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u7801\u957f\u5ea6\u4e3a18\u5b57");
                }
                if (datas.get(2) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) && !((String)datas.get(2)).matches(IdCardRegex)) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef");
                }
                salaryDetailVO.setIdCard((String)datas.get(2));
                if (!((String)datas.get(3)).matches(regex)) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u94f6\u884c\u5361\u53f7\u957f\u5ea6\u4e3a18\u586b\u5199\u9519\u8bef");
                }
                salaryDetailVO.setBankCard((String)datas.get(3));
                if (((String)datas.get(4)).length() > 20) {
                    salaryDetailVO.setErrorMessage("\u586b\u5199\u5f00\u6237\u884c\u957f\u5ea6\u4e3a0~20\u5b57");
                }
                salaryDetailVO.setBankName((String)datas.get(4));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    salaryDetailVO.setErrorMessage("\u8ba1\u91cf\u65b9\u5f0f\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(5)).length() != 2) {
                    salaryDetailVO.setErrorMessage("\u8ba1\u91cf\u65b9\u5f0f\u586b\u5199\u9519\u8bef");
                } else if (((String)datas.get(5)).equals("\u8ba1\u65e5")) {
                    salaryDetailVO.setMeasurementType("0");
                } else if (((String)datas.get(5)).equals("\u8ba1\u4ef6")) {
                    salaryDetailVO.setMeasurementType("1");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        salaryDetailVO.setWorkload(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5de5\u4f5c\u91cf\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u5de5\u4f5c\u91cf\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        salaryDetailVO.setPrice(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u586b\u9879");
                }
                if (((String)datas.get(8)).equals("\u8ba1\u65e5")) {
                    salaryDetailVO.setOvertimeMeasureType("0");
                } else if (((String)datas.get(8)).equals("\u8ba1\u4ef6")) {
                    salaryDetailVO.setOvertimeMeasureType("1");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    try {
                        salaryDetailVO.setOvertimeNum(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u52a0\u73ed\u5de5\u4f5c\u91cf\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    try {
                        salaryDetailVO.setShouldSalaryMny(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5e94\u53d1\u5de5\u8d44\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    salaryDetailVO.setErrorMessage("\u5e94\u53d1\u5de5\u8d44\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    try {
                        salaryDetailVO.setDeductMny(new BigDecimal((String)datas.get(11)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u6263\u6b3e\u8d39\u7528\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    try {
                        salaryDetailVO.setSalaryMny(new BigDecimal((String)datas.get(12)));
                    }
                    catch (Exception e) {
                        salaryDetailVO.setErrorMessage("\u5b9e\u53d1\u5de5\u8d44\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((CharSequence)salaryDetailVO.getErrorMessage())) {
                    successList.add(salaryDetailVO);
                    continue;
                }
                errorList.add(salaryDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

