/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.mapper.SettleDetailMapper;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleDetailService")
public class SettleDetailServiceImpl
extends BaseServiceImpl<SettleDetailMapper, SettleDetailEntity>
implements ISettleDetailService {
    @Autowired
    private SettleDetailMapper settleDetailMapper;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;
    @Autowired
    private IContractService contractService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<SettleDetailVO> selectDetailRecordAndTotalProcessNum(Long contractId) {
        return this.settleDetailMapper.selectDetailRecordAndTotalProcessNum(contractId);
    }

    @Override
    public List<SettleDetailVO> selectDetailTotalNodeNum(Long contractId) {
        return this.settleDetailMapper.selectDetailTotalNodeNum(contractId);
    }

    @Override
    public List<SettleDetailEntity> queryDetailList(Integer settleType, Long contractId, Date settleDate) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        List<SettleDetailEntity> settleDetailEntities = this.settleDetailMapper.queryDetailList(settleType, contractId, settleDate);
        for (SettleDetailEntity entity : settleDetailEntities) {
            CommonResponse res;
            if (entity.getDocId() == null) continue;
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(entity.getDocId());
            if (contractEntity == null || contractEntity.getContractType() == null) continue;
            if (contractEntity.getContractType() == 0) {
                res = this.labsubApi.queryLabsubItemByIds(ids);
                if (!res.isSuccess()) {
                    this.logger.error("\u7f51\u7edc\u9519\u8bef \u67e5\u8be2\u6863\u6848\u5931\u8d25:" + res.getMsg());
                }
                if (!CollectionUtil.isNotEmpty((Collection)((Collection)res.getData())) || ((LabsubItemVO)((List)res.getData()).get(0)).getSubjectId() == null || ((LabsubItemVO)((List)res.getData()).get(0)).getSubjectName() == null) continue;
                entity.setDetailSubjectId(((LabsubItemVO)((List)res.getData()).get(0)).getSubjectId());
                entity.setDetailSubjectName(((LabsubItemVO)((List)res.getData()).get(0)).getSubjectName());
                continue;
            }
            if (contractEntity.getContractType() != 1) continue;
            res = this.prosubApi.queryProsubItemByIds(ids);
            if (!res.isSuccess()) {
                this.logger.error("\u7f51\u7edc\u9519\u8bef \u67e5\u8be2\u6863\u6848\u5931\u8d25:" + res.getMsg());
            }
            if (!CollectionUtil.isNotEmpty((Collection)((Collection)res.getData())) || ((ProsubItemVO)((List)res.getData()).get(0)).getSubjectId() == null || ((ProsubItemVO)((List)res.getData()).get(0)).getSubjectName() == null) continue;
            entity.setDetailSubjectId(((ProsubItemVO)((List)res.getData()).get(0)).getSubjectId());
            entity.setDetailSubjectName(((ProsubItemVO)((List)res.getData()).get(0)).getSubjectName());
        }
        return settleDetailEntities;
    }

    @Override
    public IPage<SettleDetailEntity> selectPageDetail(Page<SettleDetailEntity> page, Integer settleType, Long contractId, String searchText, List<String> oldDelIdList) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        IPage<SettleDetailEntity> detailList = this.settleDetailMapper.queryPageDetail(page, settleType, contractId, searchText, oldDelIdList);
        for (SettleDetailEntity entity : detailList.getRecords()) {
            CommonResponse res;
            if (entity.getDocId() == null) continue;
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(entity.getDocId());
            if (contractEntity == null || contractEntity.getContractType() == null) continue;
            if (contractEntity.getContractType() == 0) {
                res = this.labsubApi.queryLabsubItemByIds(ids);
                if (!res.isSuccess()) {
                    this.logger.error("\u7f51\u7edc\u9519\u8bef \u67e5\u8be2\u6863\u6848\u5931\u8d25:" + res.getMsg());
                }
                if (!CollectionUtil.isNotEmpty((Collection)((Collection)res.getData())) || ((LabsubItemVO)((List)res.getData()).get(0)).getSubjectId() == null || ((LabsubItemVO)((List)res.getData()).get(0)).getSubjectName() == null) continue;
                entity.setDetailSubjectId(((LabsubItemVO)((List)res.getData()).get(0)).getSubjectId());
                entity.setDetailSubjectName(((LabsubItemVO)((List)res.getData()).get(0)).getSubjectName());
                continue;
            }
            if (contractEntity.getContractType() != 1) continue;
            res = this.prosubApi.queryProsubItemByIds(ids);
            if (!res.isSuccess()) {
                this.logger.error("\u7f51\u7edc\u9519\u8bef \u67e5\u8be2\u6863\u6848\u5931\u8d25:" + res.getMsg());
            }
            if (!CollectionUtil.isNotEmpty((Collection)((Collection)res.getData())) || ((ProsubItemVO)((List)res.getData()).get(0)).getSubjectId() == null || ((ProsubItemVO)((List)res.getData()).get(0)).getSubjectName() == null) continue;
            entity.setDetailSubjectId(((ProsubItemVO)((List)res.getData()).get(0)).getSubjectId());
            entity.setDetailSubjectName(((ProsubItemVO)((List)res.getData()).get(0)).getSubjectName());
        }
        return this.settleDetailMapper.queryPageDetail(page, settleType, contractId, searchText, oldDelIdList);
    }

    @Override
    public List<SettleDetailVO> addDetail(Long contractId) {
        List<SettleDetailVO> settleNodeAndProcessNum = this.settleDetailMapper.queryNodeAndProcessNum(contractId);
        ArrayList<SettleDetailVO> numList = new ArrayList<SettleDetailVO>();
        for (SettleDetailVO settleDetail : settleNodeAndProcessNum) {
            if (settleDetail.getNodeNum().compareTo(settleDetail.getProcessNum()) <= 0) continue;
            settleDetail.setSettleNum(settleDetail.getNodeNum().subtract(settleDetail.getProcessNum()));
            settleDetail.setDetailArtificialTaxPrice(settleDetail.getDetailArtificialTaxPrice());
            settleDetail.setTotalProcessNum(null != settleDetail.getTotalProcessNum() ? settleDetail.getTotalProcessNum() : BigDecimal.ZERO);
            settleDetail.setId(Long.valueOf(IdWorker.getId()));
            numList.add(settleDetail);
        }
        this.logger.info("\u5224\u65ad\u662f\u5426\u6709\u7ed3\u7b97\u5355\u6765\u6e90\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(numList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return numList;
    }

    @Override
    public List<SettleDetailEntity> queryContractDetail(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        List<SettleDetailEntity> settleDetailEntities = this.settleDetailMapper.queryContractDetail(contractId);
        for (SettleDetailEntity entity : settleDetailEntities) {
            CommonResponse res;
            if (entity.getDocId() == null) continue;
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(entity.getDocId());
            if (contractEntity.getContractType() == 0) {
                res = this.labsubApi.queryLabsubItemByIds(ids);
                if (!res.isSuccess()) {
                    this.logger.error("\u7f51\u7edc\u9519\u8bef \u67e5\u8be2\u6863\u6848\u5931\u8d25:{}", (Object)JSONObject.toJSONString((Object)res));
                }
                if (!CollectionUtil.isNotEmpty((Collection)((Collection)res.getData())) || ((LabsubItemVO)((List)res.getData()).get(0)).getSubjectId() == null || ((LabsubItemVO)((List)res.getData()).get(0)).getSubjectName() == null) continue;
                entity.setDetailSubjectId(((LabsubItemVO)((List)res.getData()).get(0)).getSubjectId());
                entity.setDetailSubjectName(((LabsubItemVO)((List)res.getData()).get(0)).getSubjectName());
                continue;
            }
            if (contractEntity.getContractType() != 1) continue;
            res = this.prosubApi.queryProsubItemByIds(ids);
            if (!res.isSuccess()) {
                this.logger.error("\u7f51\u7edc\u9519\u8bef \u67e5\u8be2\u6863\u6848\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)res));
            }
            if (!CollectionUtil.isNotEmpty((Collection)((Collection)res.getData())) || ((ProsubItemVO)((List)res.getData()).get(0)).getSubjectId() == null || ((ProsubItemVO)((List)res.getData()).get(0)).getSubjectName() == null) continue;
            entity.setDetailSubjectId(((ProsubItemVO)((List)res.getData()).get(0)).getSubjectId());
            entity.setDetailSubjectName(((ProsubItemVO)((List)res.getData()).get(0)).getSubjectName());
        }
        return settleDetailEntities;
    }
}

