package com.ejianc.business.prosub.settlePayment.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.prosub.settlePayment.*;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.INodeSettleService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.prosub.settlePayment.mapper.SettlePaymentMapper;
import com.ejianc.business.prosub.settlePayment.bean.SettlePaymentEntity;
import com.ejianc.business.prosub.settlePayment.service.ISettlePaymentService;

import java.math.BigDecimal;
import java.util.*;

/**
 * 节点结算支付比例确认单主表
 * 
 * @author generator
 * 
 */
@Service("settlePaymentService")
public class SettlePaymentServiceImpl extends BaseServiceImpl<SettlePaymentMapper, SettlePaymentEntity> implements ISettlePaymentService{

    @Autowired
    private INodeSettleService nodeSettleService;

    @Autowired
    private SettleMapper settleMapper;

    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public SettlePaymentVO addConvertBySettleId(Long settleId) {

        SettleEntity settleEntity = nodeSettleService.selectById(settleId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter(QueryParam.EQ, settleId));
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        List<SettlePaymentEntity> settlePaymentList = super.queryList(queryParam);

        SettlePaymentVO settlePaymentVO = new SettlePaymentVO();

        settlePaymentVO.setSettleType(2);
        settlePaymentVO.setSettleId(settleId);
        settlePaymentVO.setSettleCode(settleEntity.getBillCode());
        settlePaymentVO.setSettleName(settleEntity.getBillCode());
        settlePaymentVO.setSettleDate(settleEntity.getSettleDate());
        settlePaymentVO.setBillDate(new Date());
        settlePaymentVO.setContractId(settleEntity.getContractId());
        settlePaymentVO.setContractName(settleEntity.getContractName());
        settlePaymentVO.setContractCode(settleEntity.getContractCode());
        settlePaymentVO.setContractType(settleEntity.getContractType());
        settlePaymentVO.setOrgId(settleEntity.getOrgId());
        settlePaymentVO.setOrgCode(settleEntity.getOrgCode());
        settlePaymentVO.setOrgName(settleEntity.getOrgName());
        settlePaymentVO.setParentOrgId(settleEntity.getParentOrgId());
        settlePaymentVO.setParentOrgCode(settleEntity.getParentOrgCode());
        settlePaymentVO.setParentOrgName(settleEntity.getParentOrgName());
        settlePaymentVO.setSupplementFlag(settleEntity.getSupplementFlag());
        settlePaymentVO.setProjectId(settleEntity.getProjectId());
        settlePaymentVO.setProjectName(settleEntity.getProjectName());
        settlePaymentVO.setProjectCode(settleEntity.getProjectCode());
        settlePaymentVO.setSupplierId(settleEntity.getSupplierId());
        settlePaymentVO.setSupplierName(settleEntity.getSupplierName());

        settlePaymentVO.setPaymentRatioNum(settlePaymentList.size() + 1);

        settlePaymentVO.setSettleTaxMny(settleEntity.getTaxMny());
        settlePaymentVO.setSettleMny(settleEntity.getMny());

        settlePaymentVO.setSettlePaymentTaxMny(BigDecimal.ZERO);
        settlePaymentVO.setSettlePaymentMny(BigDecimal.ZERO);

        //赋值款项信息字段用于计算
        settlePaymentVO.setPickingTaxMny(settleEntity.getPickingTaxMny());
        settlePaymentVO.setPickingMny(settleEntity.getPickingMny());
        settlePaymentVO.setDeductTaxMny(settleEntity.getDeductTaxMny());
        settlePaymentVO.setDeductMny(settleEntity.getDeductMny());
        settlePaymentVO.setOddjobTaxMny(settleEntity.getOddjobTaxMny());
        settlePaymentVO.setOddjobMny(settleEntity.getOddjobMny());
        settlePaymentVO.setOtherTaxMny(settleEntity.getOtherTaxMny());
        settlePaymentVO.setOtherMny(settleEntity.getOtherMny());

        //查询已提交或审批通过的节点结算的 结算金额之和
        SettlePaymentVO settlePaymentDataVO = settleMapper.selectTotalNodeSettleMny(settleEntity.getContractId());
        if (null != settlePaymentVO){
            settlePaymentVO.setContractTotalSettleTaxMny(settlePaymentDataVO.getContractTotalSettleTaxMny());
            settlePaymentVO.setContractTotalSettleMny(settlePaymentDataVO.getContractTotalSettleMny());
        }
        CommonResponse<List<PaymentApplyVO>> paymentApplyData = paymentApplyApi.queryListByContractId(settleEntity.getContractId());
        if (!paymentApplyData.isSuccess()){
            logger.error("当前合同支付申请查询失败，失败信息：{}", paymentApplyData.getMsg());
            throw  new BusinessException("当前合同支付申请查询失败，失败信息：" + paymentApplyData.getMsg());
        }
        //设置实付金额
        if (null != paymentApplyData.getData() && CollectionUtils.isNotEmpty(paymentApplyData.getData())){
            BigDecimal contractTotalPayMny = paymentApplyData.getData().stream().filter(item -> item.getActualMny() != null).map(PaymentApplyVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            settlePaymentVO.setContractTotalPayMny(contractTotalPayMny);
        }else {
            settlePaymentVO.setContractTotalPayMny(BigDecimal.ZERO);
        }

        if (settlePaymentList.size() == 0){//第一次新建确认单
            settlePaymentVO.setLastSettlePaymentTaxMny(settleEntity.getSettlePaymentTaxMny());
            settlePaymentVO.setLastSettlePaymentMny(settleEntity.getSettlePaymentMny());
            settlePaymentVO.setTotalSettlePaymentTaxMny(settleEntity.getSettlePaymentTaxMny());
            settlePaymentVO.setTotalSettlePaymentMny(settleEntity.getSettlePaymentMny());

            settlePaymentVO.setTotalDetailSettlePaymentTaxMny(BigDecimal.ZERO);
            settlePaymentVO.setTotalDetailSettlePaymentMny(BigDecimal.ZERO);
        }else {
            settlePaymentVO.setLastSettlePaymentTaxMny(settlePaymentList.get(0).getTotalSettlePaymentTaxMny());
            settlePaymentVO.setLastSettlePaymentMny(settlePaymentList.get(0).getTotalSettlePaymentMny());
            settlePaymentVO.setTotalSettlePaymentTaxMny(settlePaymentList.get(0).getTotalSettlePaymentTaxMny());
            settlePaymentVO.setTotalSettlePaymentMny(settlePaymentList.get(0).getTotalSettlePaymentMny());

            settlePaymentVO.setTotalDetailSettlePaymentTaxMny(BigDecimal.ZERO);
            settlePaymentVO.setTotalDetailSettlePaymentMny(BigDecimal.ZERO);
        }


        //清单详情 重置id 设置 settleId
        settlePaymentVO.setSettlePaymentDetailList(BeanMapper.mapList(settleEntity.getSettleDetailList(), SettlePaymentDetailVO.class));
        if (CollectionUtils.isNotEmpty(settleEntity.getSettleDetailList())){
            //如果第一次创建确认单 将结算单的本次结算支付金额赋值给 确认单的上次结算支付金额
            List<SettlePaymentDetailVO> settlePaymentDetailVOList = new ArrayList<>();
            if (settlePaymentList.size() == 0) {
                settlePaymentDetailVOList = BeanMapper.mapList(settleEntity.getSettleDetailList(), SettlePaymentDetailVO.class);
                Map<Long, Long> idMap = new HashMap<>();
                for (SettlePaymentDetailVO detailVO : settlePaymentDetailVOList) {
                    detailVO.setSourceSettleId(settleId);
                    detailVO.setSourceSettleDetailId(detailVO.getId());
                    detailVO.setId(IdWorker.getId());
                    idMap.put(detailVO.getSourceSettleDetailId(), detailVO.getId());


                    detailVO.setDetailLastSettlePaymentTaxMny(detailVO.getDetailSettlePaymentTaxMny());
                    detailVO.setDetailLastSettlePaymentMny(detailVO.getDetailSettlePaymentMny());
                    detailVO.setDetailLastSettlePaymentRatio(detailVO.getDetailSettlePaymentRatio());

                    detailVO.setDetailTotalSettlePaymentTaxMny(detailVO.getDetailSettlePaymentTaxMny());
                    detailVO.setDetailTotalSettlePaymentMny(detailVO.getDetailSettlePaymentMny());
                    detailVO.setDetailTotalSettlePaymentRatio(detailVO.getDetailSettlePaymentRatio());
                    detailVO.setDetailSettlePaymentTaxMny(null);
                    detailVO.setDetailSettlePaymentMny(null);
                    detailVO.setDetailSettlePaymentRatio(null);
                }
                for (SettlePaymentDetailVO detailVO : settlePaymentDetailVOList){
                    if (null != detailVO.getParentId() && null != idMap.get(detailVO.getParentId())){
                        detailVO.setParentId(idMap.get(detailVO.getParentId()));
                    }
                    detailVO.setTid(String.valueOf(detailVO.getId()));
                    detailVO.setTpid(detailVO.getParentId() != null && detailVO.getParentId() > 0 ? String.valueOf(detailVO.getParentId()) : null);
                }
            }else {
                /*
                    非第一次新增确认单赋值
                    a. 上次结算支付比例：  上次的【分包结算支付比例确认单】“累计结算支付比例”
                    b. 上次结算支付金额：  上次的【分包结算支付比例确认单】“累计结算支付金额”
                 */
                SettlePaymentEntity settlePaymentEntity = super.selectById(settlePaymentList.get(0).getId());
                settlePaymentDetailVOList = BeanMapper.mapList(settlePaymentEntity.getSettlePaymentDetailList(), SettlePaymentDetailVO.class);
                Map<Long, Long> idMap = new HashMap<>();
                for (SettlePaymentDetailVO detailVO : settlePaymentDetailVOList) {
                    Long oldId = detailVO.getId();
                    detailVO.setId(IdWorker.getId());
                    idMap.put(oldId, detailVO.getId());

                    detailVO.setDetailLastSettlePaymentTaxMny(detailVO.getDetailTotalSettlePaymentTaxMny());
                    detailVO.setDetailLastSettlePaymentMny(detailVO.getDetailTotalSettlePaymentMny());
                    detailVO.setDetailLastSettlePaymentRatio(detailVO.getDetailTotalSettlePaymentRatio());

                    detailVO.setDetailSettlePaymentTaxMny(null);
                    detailVO.setDetailSettlePaymentMny(null);
                    detailVO.setDetailSettlePaymentRatio(null);
                }
                for (SettlePaymentDetailVO detailVO : settlePaymentDetailVOList){
                    if (null != detailVO.getParentId() && null != idMap.get(detailVO.getParentId())){
                        detailVO.setParentId(idMap.get(detailVO.getParentId()));
                    }
                    detailVO.setTid(String.valueOf(detailVO.getId()));
                    detailVO.setTpid(detailVO.getParentId() != null && detailVO.getParentId() > 0 ? String.valueOf(detailVO.getParentId()) : null);
                }
            }
            settlePaymentVO.setSettlePaymentDetailList(TreeNodeBUtil.buildTree(settlePaymentDetailVOList));
        }

        //奖罚单
        if (CollectionUtils.isNotEmpty(settleEntity.getSettleDeductList())){
            List<SettlePaymentDeductVO> settlePaymentDeductVOList = BeanMapper.mapList(settleEntity.getSettleDeductList(), SettlePaymentDeductVO.class);
            settlePaymentDeductVOList.forEach(item -> {
                item.setSourceSettleId(settleId);
                item.setSourceSettleDeductId(item.getId());
                item.setId(IdWorker.getId());
            });
            settlePaymentVO.setSettlePaymentDeductList(settlePaymentDeductVOList);
        }
        //零工
        if (CollectionUtils.isNotEmpty(settleEntity.getSettleOddjobList())){
            List<SettlePaymentOddjobVO> settlePaymentOddjobVOList = BeanMapper.mapList(settleEntity.getSettleOddjobList(), SettlePaymentOddjobVO.class);
            settlePaymentOddjobVOList.forEach(item -> {
                item.setSourceSettleId(settleId);
                item.setSourceSettleOddjobId(item.getId());
                item.setId(IdWorker.getId());
            });
            settlePaymentVO.setSettlePaymentOddjobList(settlePaymentOddjobVOList);
        }
        //借扣款
        if (CollectionUtils.isNotEmpty(settleEntity.getSettlePickingList())){
            List<SettlePaymentPickingVO> settlePaymentPickingVOList = BeanMapper.mapList(settleEntity.getSettlePickingList(), SettlePaymentPickingVO.class);
            settlePaymentPickingVOList.forEach(item -> {
                item.setSourceSettleId(settleId);
                item.setSourceSettlePickingId(item.getId());
                item.setId(IdWorker.getId());
            });
            settlePaymentVO.setSettlePaymentPickingList(settlePaymentPickingVOList);
        }
        //其他费用
        if (CollectionUtils.isNotEmpty(settleEntity.getSettleOtherList())){
            List<SettlePaymentOtherVO> settlePaymentOtherVOList = BeanMapper.mapList(settleEntity.getSettleOtherList(), SettlePaymentOtherVO.class);
            settlePaymentOtherVOList.forEach(item -> {
                item.setSourceSettleId(settleId);
                item.setSourceSettleOtherId(item.getId());
                item.setId(IdWorker.getId());
            });
            settlePaymentVO.setSettlePaymentOtherList(settlePaymentOtherVOList);
        }

        return settlePaymentVO;
    }
}
