package com.ejianc.business.settle.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.mapper.SettleDetailMapper;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 结算子表-分包清单
 *
 * @author generator
 */
@Service("settleDetailService")
public class SettleDetailServiceImpl extends BaseServiceImpl<SettleDetailMapper, SettleDetailEntity> implements ISettleDetailService {

    @Autowired
    private SettleDetailMapper settleDetailMapper;
    @Autowired
    private IShareLabsubApi labsubApi;

    @Autowired
    private IShareProsubApi prosubApi;

    @Autowired
    private IContractService contractService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<SettleDetailVO> selectDetailRecordAndTotalProcessNum(Long contractId) {
        return settleDetailMapper.selectDetailRecordAndTotalProcessNum(contractId);
    }

    @Override
    public List<SettleDetailVO> selectDetailTotalNodeNum(Long contractId) {
        return settleDetailMapper.selectDetailTotalNodeNum(contractId);
    }

    @Override
    public List<SettleDetailEntity> queryDetailList(Integer settleType, Long contractId, Date settleDate) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        List<SettleDetailEntity> settleDetailEntities = settleDetailMapper.queryDetailList(settleType, contractId, settleDate);
        for (SettleDetailEntity entity:settleDetailEntities){
            if (entity.getDocId()!=null){
                List<Long> ids = new ArrayList<>();
                ids.add(entity.getDocId());
                if (contractEntity!=null&&contractEntity.getContractType()!=null){
                    if (contractEntity.getContractType()==0){
                        CommonResponse<List<LabsubItemVO>> res = labsubApi.queryLabsubItemByIds(ids);
                        if (!res.isSuccess()){
                            logger.error("网络错误 查询档案失败:"+res.getMsg());
                        }
                        if (CollectionUtil.isNotEmpty(res.getData())){
                            if (res.getData().get(0).getSubjectId()!=null&&res.getData().get(0).getSubjectName()!=null){
                                //当前档案关联了成本科目
                                entity.setDetailSubjectId(res.getData().get(0).getSubjectId());
                                entity.setDetailSubjectName(res.getData().get(0).getSubjectName());
                            }
                        }
                    }else if (contractEntity.getContractType()==1){
                        CommonResponse<List<ProsubItemVO>> res = prosubApi.queryProsubItemByIds(ids);
                        if (!res.isSuccess()){
                            logger.error("网络错误 查询档案失败:"+res.getMsg());
                        }
                        if (CollectionUtil.isNotEmpty(res.getData())){
                            if (res.getData().get(0).getSubjectId()!=null&&res.getData().get(0).getSubjectName()!=null){
                                //当前档案关联了成本科目
                                entity.setDetailSubjectId(res.getData().get(0).getSubjectId());
                                entity.setDetailSubjectName(res.getData().get(0).getSubjectName());
                            }
                        }
                    }
                }
            }
        }
        return settleDetailEntities;
    }

    @Override
    public IPage<SettleDetailEntity> selectPageDetail(Page<SettleDetailEntity> page, Integer settleType, Long contractId, String searchText, List<String> oldDelIdList) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        IPage<SettleDetailEntity> detailList = settleDetailMapper.queryPageDetail(page, settleType, contractId, searchText, oldDelIdList);
        for (SettleDetailEntity entity:detailList.getRecords()){
            if (entity.getDocId()!=null){
                List<Long> ids = new ArrayList<>();
                ids.add(entity.getDocId());
                if (contractEntity!=null&&contractEntity.getContractType()!=null){


                    if (contractEntity.getContractType()==0){
                        CommonResponse<List<LabsubItemVO>> res = labsubApi.queryLabsubItemByIds(ids);
                        if (!res.isSuccess()){
                            logger.error("网络错误 查询档案失败:"+res.getMsg());
                        }
                        if (CollectionUtil.isNotEmpty(res.getData())){
                            if (res.getData().get(0).getSubjectId()!=null&&res.getData().get(0).getSubjectName()!=null){
                                //当前档案关联了成本科目
                                entity.setDetailSubjectId(res.getData().get(0).getSubjectId());
                                entity.setDetailSubjectName(res.getData().get(0).getSubjectName());
                            }
                        }
                    }else if (contractEntity.getContractType()==1){
                        CommonResponse<List<ProsubItemVO>> res = prosubApi.queryProsubItemByIds(ids);
                        if (!res.isSuccess()){
                            logger.error("网络错误 查询档案失败:"+res.getMsg());
                        }
                        if (CollectionUtil.isNotEmpty(res.getData())){
                            if (res.getData().get(0).getSubjectId()!=null&&res.getData().get(0).getSubjectName()!=null){
                                //当前档案关联了成本科目
                                entity.setDetailSubjectId(res.getData().get(0).getSubjectId());
                                entity.setDetailSubjectName(res.getData().get(0).getSubjectName());
                            }
                        }
                    }
                }
            }
        }
        return settleDetailMapper.queryPageDetail(page, settleType, contractId, searchText, oldDelIdList);
    }
    @Override
    public List<SettleDetailVO> addDetail(Long contractId) {
        //如果累计节点结算量大于累计过程结算量，则在结算清单中加入一条数据
        List<SettleDetailVO> settleNodeAndProcessNum = settleDetailMapper.queryNodeAndProcessNum(contractId);
        List<SettleDetailVO> numList = new ArrayList<>();
        for (SettleDetailVO settleDetail : settleNodeAndProcessNum) {
            if (settleDetail.getNodeNum().compareTo(settleDetail.getProcessNum()) > 0){
                settleDetail.setSettleNum(settleDetail.getNodeNum().subtract(settleDetail.getProcessNum()));
                settleDetail.setDetailArtificialTaxPrice(settleDetail.getDetailArtificialTaxPrice());
                settleDetail.setTotalProcessNum(null != settleDetail.getTotalProcessNum() ? settleDetail.getTotalProcessNum() : BigDecimal.ZERO);
                settleDetail.setId(IdWorker.getId());
                settleDetail.setOldId(settleDetail.getId());
                settleDetail.setOriginalPid(settleDetail.getParentId());
                numList.add(settleDetail);
            }
        }
//        logger.info("判断是否有结算单来源的数据：{}", JSONObject.toJSONString(numList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return numList;
    }

    @Override
    public List<SettleDetailEntity> queryContractDetail(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);

        List<SettleDetailEntity> settleDetailEntities = settleDetailMapper.queryContractDetail(contractId);
        for (SettleDetailEntity entity:settleDetailEntities){
            if (entity.getDocId()!=null){
                List<Long> ids = new ArrayList<>();
                ids.add(entity.getDocId());
                if (contractEntity.getContractType()==0){
                    CommonResponse<List<LabsubItemVO>> res = labsubApi.queryLabsubItemByIds(ids);
                    if (!res.isSuccess()){
                        logger.error("网络错误 查询档案失败:{}",JSONObject.toJSONString(res));
                    }
                    if (CollectionUtil.isNotEmpty(res.getData())){
                        if (res.getData().get(0).getSubjectId()!=null&&res.getData().get(0).getSubjectName()!=null){
                            //当前档案关联了成本科目
                            entity.setDetailSubjectId(res.getData().get(0).getSubjectId());
                            entity.setDetailSubjectName(res.getData().get(0).getSubjectName());
                        }
                    }
                }else if (contractEntity.getContractType()==1){
                    CommonResponse<List<ProsubItemVO>> res = prosubApi.queryProsubItemByIds(ids);
                    if (!res.isSuccess()){
                        logger.error("网络错误 查询档案失败：{}", JSONObject.toJSONString(res));
                    }
                    if (CollectionUtil.isNotEmpty(res.getData())){
                        if (res.getData().get(0).getSubjectId()!=null&&res.getData().get(0).getSubjectName()!=null){
                            //当前档案关联了成本科目
                            entity.setDetailSubjectId(res.getData().get(0).getSubjectId());
                            entity.setDetailSubjectName(res.getData().get(0).getSubjectName());
                        }
                    }
                }



            }
        }
        return settleDetailEntities;
    }
}
