package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.DeductionEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IDeductionService;
import com.ejianc.business.process.vo.DeductionVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 扣奖罚单
 *
 * @author generator
 */
@RestController
@RequestMapping("deduction")
public class DeductionController {
    private static final String BILL_CODE = "DEDUC_";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDeductionService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IContractService contractService;


    private final String billTypeCode = "BT211230000000006";

    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/deduction/card";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<DeductionVO> saveOrUpdate(@RequestBody DeductionVO saveOrUpdateVO) {
        saveOrUpdateVO.setCreateUserId(InvocationInfoProxy.getUserid());
        DeductionEntity entity = BeanMapper.map(saveOrUpdateVO, DeductionEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置当前制单人Id
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            //设置签章状态
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方未签字.getCode());
            //保存单据制单人Id
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        // 金额计算
        if (entity.getTaxRate() == null) {
            return CommonResponse.error("税率不能为空！");
        }
        if (entity.getTaxMny() == null) {
            return CommonResponse.error("含税金额不能为空！");
        }
        BigDecimal taxRate = entity.getTaxRate().divide(new BigDecimal("100"), 8, RoundingMode.HALF_UP);
        BigDecimal tax = entity.getTaxMny().divide(BigDecimal.ONE.add(taxRate), 8, RoundingMode.HALF_UP).multiply(taxRate);
        BigDecimal mny = tax.divide(taxRate, 8, RoundingMode.HALF_UP);
        entity.setMny(mny);
        entity.setTax(tax);
        service.saveOrUpdate(entity, false);
        DeductionVO vo = BeanMapper.map(entity, DeductionVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<DeductionVO> queryDetail(Long id) {
        DeductionEntity entity = service.selectById(id);
        DeductionVO vo = BeanMapper.map(entity, DeductionVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<DeductionVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeductionVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DeductionVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<DeductionVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        List<DeductionEntity> dataList = new ArrayList<>();
        IPage<DeductionEntity> page = null;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        //移动端查询
        if (StringUtils.isNotBlank(authOrgIds)) {
            //移动端有默认项目的存在，故传递默认项目对应项目部Id时，查询其本下数据，若未传递，则返回空数据
            if (null == param.getParams().get("orgId")) {
                page = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            } else {
                page = service.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            //pc端查询
            //查询本下范围内日的合同
            Long orgId = InvocationInfoProxy.getOrgId();
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            page = service.queryPage(param, false);
            dataList = page.getRecords();
        }

        IPage<DeductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeductionVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 文件导出
     *
     * @param param
     * @param response
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");

        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<DeductionEntity> pageData = service.queryPage(param, false);
//        导出数据
        logger.info("导出数据----{}",JSONObject.toJSONString(pageData));
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<DeductionVO> list = BeanMapper.mapList(pageData.getRecords(), DeductionVO.class);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DecimalFormat decimalFormat = new DecimalFormat("#,###.00");
            decimalFormat.setRoundingMode(RoundingMode.HALF_DOWN);

            for (DeductionVO item:list){
                item.setBillStateStr(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
                item.setContractTypeStr(null != item.getContractType() && item.getContractType().equals(1)?"专业分包合同":"劳务分包合同");
                item.setSupplierSignStatusStr(null != item.getSupplierSignStatus() && item.getSupplierSignStatus().equals(1)?"乙方已签字":"乙方未签字");
                item.setTimeStr(sdf.format(item.getCreateTime()));
                item.setRewardDeductionTypeName(item.getRewardDeductionType() == 0 ? "奖励" : item.getRewardDeductionType() == 1 ? "扣款" : "罚款");
                item.setTaxMnyStr((item.getRewardDeductionType().equals(0) ? "" : "-") + decimalFormat.format(item.getTaxMny()));
            }
            Map<String, Object> beans = new HashMap<>(list.size());
            beans.put("records", list);
            ExcelExport.getInstance().export("deduct-export.xlsx", beans, response);
        }
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @GetMapping(value = "/getBillShareLink")
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        DeductionEntity entity = service.selectById(id);
        if(SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(BeanMapper.map(entity, DeductionEntity.class), billTypeCode, cooperateResp.getData());
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }

    /**
     * @return
     * @param id 合同Id
     */
    @RequestMapping(value = "/contractDeductRecord", method = RequestMethod.GET)
    public CommonResponse<JSONObject> contractDeductRecord(@RequestParam Long id) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(id);

        QueryWrapper<DeductionEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contract.getId());
        query.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc("create_time");

        List<DeductionEntity> list = service.list(query);
        resp.put("deductList", BeanMapper.mapList(list, DeductionVO.class));

        BigDecimal totalDeductTaxMny = BigDecimal.ZERO;
        for(DeductionEntity item : list) {
            if(null != item.getRewardDeductionType() && item.getRewardDeductionType().equals(0)) {
                totalDeductTaxMny = totalDeductTaxMny.add(item.getTaxMny());
            } else {
                totalDeductTaxMny = totalDeductTaxMny.subtract(item.getTaxMny());
            }
        }

        resp.put("contractTaxMny", contract.getContractTaxMny());
        resp.put("totalDeductTaxMny", totalDeductTaxMny);
        resp.put("deductRatio", totalDeductTaxMny.divide(contract.getContractTaxMny(), 8, BigDecimal.ROUND_HALF_UP));

        return CommonResponse.success("查询详情数据成功！", resp);
    }
}
