/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.TeamDetailEntity;
import com.ejianc.business.process.bean.TeamEntity;
import com.ejianc.business.process.enums.TeamStatusEnum;
import com.ejianc.business.process.service.ITeamDetailService;
import com.ejianc.business.process.service.ITeamService;
import com.ejianc.business.process.vo.TeamDetailVO;
import com.ejianc.business.process.vo.TeamVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"team"})
public class TeamController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TEAM_USE";
    @Autowired
    private ITeamService service;
    @Autowired
    private ITeamDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TeamVO> saveOrUpdate(@RequestBody TeamVO saveOrUpdateVO) {
        TeamEntity entity = (TeamEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TeamEntity.class));
        if (entity.getId() == null) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"contract_id", (Object)entity.getContractId());
            query.eq((Object)"dr", (Object)0);
            int count = this.service.count((Wrapper)query);
            if (count > 0) {
                this.logger.info("\u5f53\u524d{}\u5408\u540c\u5df2\u5b58\u5728\u73ed\u7ec4\u5355 \u4e00\u4e2a\u5408\u540c\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a", (Object)entity.getContractName());
                throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u73ed\u7ec4\u5355\uff0c \u8bf7\u66f4\u6362\u5408\u540c\uff01");
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<TeamDetailEntity> teamDetailList = entity.getTeamDetailList();
        StringBuilder teamUsers = new StringBuilder();
        for (TeamDetailEntity detailEntity : teamDetailList) {
            if (!StringUtils.isNotEmpty((CharSequence)detailEntity.getTeamDetailName())) continue;
            if (teamUsers.length() > 0) {
                teamUsers.append(",");
            }
            teamUsers.append(detailEntity.getTeamDetailName());
        }
        entity.setTeamUsers(teamUsers.toString());
        this.service.saveOrUpdate((Object)entity, false);
        TeamVO vo = (TeamVO)BeanMapper.map((Object)((Object)entity), TeamVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TeamVO> queryDetail(Long id) {
        TeamEntity entity = (TeamEntity)((Object)this.service.selectById(id));
        TeamVO vo = (TeamVO)BeanMapper.map((Object)((Object)entity), TeamVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TeamVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TeamVO object : vos) {
            }
        }
        List collect = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : collect) {
            Boolean data;
            List<Long> detailIds;
            CommonResponse<Boolean> commonResponse;
            TeamEntity teamEntity = (TeamEntity)((Object)this.service.selectById(id));
            List<TeamDetailEntity> detailList = teamEntity.getTeamDetailList();
            if (!CollectionUtil.isNotEmpty(detailList) || !(commonResponse = this.service.queryReferenceTeam(detailIds = detailList.stream().map(BaseEntity::getId).collect(Collectors.toList()))).isSuccess() || (data = (Boolean)commonResponse.getData()).booleanValue()) continue;
            return CommonResponse.error((String)(teamEntity.getContractName() + commonResponse.getMsg()));
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("compileName");
        fuzzyFields.add("billCode");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TeamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("create_time", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), TeamVO.class);
            for (TeamVO vo : list) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                vo.setCompileDateStr(sdf.format(vo.getCompileDate()));
            }
            HashMap<String, List> beans = new HashMap<String, List>(list.size());
            this.logger.error(JSONObject.toJSONString((Object)list));
            beans.put("records", list);
            ExcelExport.getInstance().export("team-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refTeamData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> refTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TeamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refTeamDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TeamDetailVO>> refTeamDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (condition.contains("contractId")) {
                param.getParams().put("team_contract_id", new Parameter("eq", (Object)_con.getString("contractId")));
            } else if (condition.contains("projectId")) {
                param.getParams().put("project_id", new Parameter("eq", (Object)_con.getString("projectId")));
            } else {
                return CommonResponse.error((String)"\u8bf7\u4f20\u5165\u5408\u540cid\uff01\u6216\u8005\u4f20\u5165\u9879\u76eeid");
            }
            String excludeIdStr = _con.getString("excludeIds");
            if (StringUtils.isNotBlank((CharSequence)excludeIdStr)) {
                param.getParams().put("id", new Parameter("not_in", (Object)Lists.newArrayList((Object[])excludeIdStr.split(","))));
            }
        } else {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        List teamEntities = this.service.queryList(param);
        Page pageData = new Page(1L, 10L, 0L);
        if (CollectionUtils.isNotEmpty((Collection)teamEntities)) {
            List collect = teamEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            List fuzzyFields = queryParam.getFuzzyFields();
            fuzzyFields.add("team_detail_name");
            queryParam.setPageSize(pageSize.intValue());
            queryParam.setPageIndex(pageNumber.intValue());
            queryParam.setSearchText(searchText);
            queryParam.setSearchObject(searchObject);
            queryParam.getParams().put("team_id", new Parameter("in", collect));
            queryParam.getParams().put("team_detail_status", new Parameter("eq", (Object)TeamStatusEnum.\u542f\u7528.getCode()));
            String searchText1 = queryParam.getSearchText();
            IPage page = this.detailService.queryPage(queryParam, false);
            pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TeamDetailVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryContractTeamDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TeamDetailVO>> queryContractTeamDetailData(String contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("team_contract_id", new Parameter("eq", (Object)contractId));
        param.getParams().put("team_detail_status", new Parameter("eq", (Object)TeamStatusEnum.\u542f\u7528.getCode()));
        List teamDetailEntities = this.detailService.queryList(param, false);
        List teamDetailVOS = BeanMapper.mapList((Iterable)teamDetailEntities, TeamDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)teamDetailVOS);
    }

    @RequestMapping(value={"/queryReferenceTeam"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> queryReferenceTeam(@RequestBody List<TeamDetailVO> vos) {
        return this.service.queryReferenceTeam(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
    }
}

