/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.pricelib.service.impl;

import com.ejianc.business.prosub.pricelib.bean.PriceContractCollectEntity;
import com.ejianc.business.prosub.pricelib.bean.PriceContractEntity;
import com.ejianc.business.prosub.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.prosub.pricelib.mapper.PriceContractCollectMapper;
import com.ejianc.business.prosub.pricelib.service.IPriceContractCollectService;
import com.ejianc.business.prosub.pricelib.service.IPriceContractService;
import com.ejianc.business.prosub.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceContractCollectService")
public class PriceContractCollectServiceImpl
extends BaseServiceImpl<PriceContractCollectMapper, PriceContractCollectEntity>
implements IPriceContractCollectService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceContractService priceContractService;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;

    @Override
    public void savePriceContractToHistoryByTiming() {
        this.logger.info("---\u5386\u53f2\u4ef7\u683cinit\u5f00\u59cb---");
        this.logger.info("---\u6570\u636e\u5168\u5220\u9664\u64cd\u4f5c\u5f00\u59cb---");
        ((PriceContractCollectMapper)this.baseMapper).delPriceContractCollectAll();
        this.logger.info("---\u6570\u636e\u63d2\u5165\u64cd\u4f5c\u5f00\u59cb---");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("outFlag", new Parameter("eq", (Object)0));
        List priceContractList = this.priceContractService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)priceContractList)) {
            return;
        }
        ArrayList<PriceContractCollectEntity> priceContractCollectList = new ArrayList<PriceContractCollectEntity>();
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getDocId));
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            List<PriceContractEntity> value = entry.getValue();
            List priceList = value.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List taxPriceList = value.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            PriceContractEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal maxPrice = ((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = ((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxMaxPrice = ((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = ((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            PriceContractCollectEntity priceContractCollectEntity = new PriceContractCollectEntity();
            priceContractCollectEntity.setDocId(priceContract.getDocId());
            priceContractCollectEntity.setDocCode(priceContract.getDocCode());
            priceContractCollectEntity.setDocName(priceContract.getDocName());
            priceContractCollectEntity.setDocCategoryId(priceContract.getDocCategoryId());
            priceContractCollectEntity.setDocCategoryName(priceContract.getDocCategoryName());
            priceContractCollectEntity.setDocInnerCode(priceContract.getDocInnerCode());
            priceContractCollectEntity.setUnitId(priceContract.getUnitId());
            priceContractCollectEntity.setUnitName(priceContract.getUnitName());
            priceContractCollectEntity.setPriceTypeName(priceContract.getPriceTypeName());
            priceContractCollectEntity.setContractMaxPrice(maxPrice);
            priceContractCollectEntity.setContractMinPrice(minPrice);
            priceContractCollectEntity.setContractPriceArea(priceArea);
            priceContractCollectEntity.setContractTaxMaxPrice(taxMaxPrice);
            priceContractCollectEntity.setContractTaxMinPrice(taxMinPrice);
            priceContractCollectEntity.setContractTaxPriceArea(taxPriceArea);
            priceContractCollectList.add(priceContractCollectEntity);
        }
        this.logger.info("\u4fdd\u5b58\u6570\u636e\u5927\u5c0f{}\u6761", (Object)priceContractCollectList.size());
        super.saveOrUpdateBatch(priceContractCollectList);
        this.logger.info("---\u6570\u636e\u63d2\u5165\u64cd\u4f5c\u7ed3\u675f---");
    }

    @Override
    public List<PriceContractCollectVO> getPriceContractByDocIds(List<Long> docIds) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("docId", new Parameter("in", docIds));
        List priceContractCollectVOList = BeanMapper.mapList((Iterable)super.queryList(queryParam), PriceContractCollectVO.class);
        List<PriceContractCollectVO> guideDetailList = this.getGuidePriceAreaByDocIds(docIds);
        if (CollectionUtils.isNotEmpty(guideDetailList)) {
            Map guidePriceMap = guideDetailList.stream().collect(Collectors.toMap(PriceContractCollectVO::getDocId, Function.identity(), (key1, key2) -> key2));
            if (CollectionUtils.isNotEmpty((Collection)priceContractCollectVOList)) {
                for (PriceContractCollectVO priceContractCollectVO : priceContractCollectVOList) {
                    if (!guidePriceMap.containsKey(priceContractCollectVO.getDocId())) continue;
                    priceContractCollectVO.setGuidePriceArea(((PriceContractCollectVO)guidePriceMap.get(priceContractCollectVO.getDocId())).getGuidePriceArea());
                    priceContractCollectVO.setGuideTaxPriceArea(((PriceContractCollectVO)guidePriceMap.get(priceContractCollectVO.getDocId())).getGuideTaxPriceArea());
                    guidePriceMap.remove(priceContractCollectVO.getDocId());
                }
            }
            if (guidePriceMap != null) {
                guidePriceMap.keySet().stream().forEach(key -> {
                    PriceContractCollectVO priceContractCollectVO = new PriceContractCollectVO();
                    priceContractCollectVO.setDocId(((PriceContractCollectVO)guidePriceMap.get(key)).getDocId());
                    priceContractCollectVO.setGuidePriceArea(((PriceContractCollectVO)guidePriceMap.get(key)).getGuidePriceArea());
                    priceContractCollectVO.setGuideTaxPriceArea(((PriceContractCollectVO)guidePriceMap.get(key)).getGuideTaxPriceArea());
                    priceContractCollectVOList.add(priceContractCollectVO);
                });
            }
        }
        return priceContractCollectVOList;
    }

    @Override
    public List<PriceContractCollectVO> getGuidePriceAreaByDocIds(List<Long> docIds) {
        List<PriceGuideDetailEntity> list = this.priceGuideDetailService.queryPriceGuideDetailByDocIds(docIds);
        ArrayList<PriceContractCollectVO> PriceContractCollectVOList = new ArrayList<PriceContractCollectVO>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            for (PriceGuideDetailEntity guide : list) {
                PriceContractCollectVO priceContractCollectVO = new PriceContractCollectVO();
                BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
                BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
                min = min.divide(BigDecimal.ONE, 4, 4);
                max = max.divide(BigDecimal.ONE, 4, 4);
                priceContractCollectVO.setGuidePriceArea(min + "-" + max);
                min = guide.getMinTaxPrice() == null ? BigDecimal.ZERO : guide.getMinTaxPrice();
                max = guide.getMaxTaxPrice() == null ? BigDecimal.ZERO : guide.getMaxTaxPrice();
                min = min.divide(BigDecimal.ONE, 4, 4);
                max = max.divide(BigDecimal.ONE, 4, 4);
                priceContractCollectVO.setGuideTaxPriceArea(min + "-" + max);
                priceContractCollectVO.setDocId(guide.getDocId());
                PriceContractCollectVOList.add(priceContractCollectVO);
            }
        }
        return PriceContractCollectVOList;
    }
}

