/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanChangeHisEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeHisEntity;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailChangeHisService;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planChange")
public class PlanChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPlanService masterPlanService;
    @Autowired
    private IPlanDetailService masterPlanDetailService;
    @Autowired
    private IPlanChangeService masterPlanChangeService;
    @Autowired
    private IPlanChangeHisService masterPlanChangeHisService;
    @Autowired
    private IPlanDetailChangeHisService planDetailChangeHisService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        PlanChangeEntity planChange = (PlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        PlanEntity newPlanEntity = null;
        PlanEntity oldPlan = (PlanEntity)((Object)this.masterPlanService.selectById(planChange.getSourcePlanId()));
        planChange.setEffectiveDate(new Date());
        PlanChangeHisEntity recordEntity = (PlanChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldPlan), PlanChangeHisEntity.class));
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03, \u603b\u8ba1\u5212\u53d8\u66f4\u4fe1\u606f\uff1a\u3010{}\u3011, \u53d8\u66f4\u524d\u603b\u8ba1\u5212\u4fe1\u606f: \u3010{}\u3011", (Object)JSON.toJSONString((Object)((Object)planChange)), (Object)JSON.toJSONString((Object)((Object)oldPlan)));
        recordEntity.setSourcePlanId(oldPlan.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getPlanDetailList())) {
            recordEntity.getPlanDetailList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setOriginalPlanTaxMny(oldPlan.getTotalPlanTaxMny());
        recordEntity.setOriginalPlanMny(oldPlan.getTotalPlanMny());
        recordEntity.setTotalPlanTaxMny(planChange.getTotalPlanTaxMny());
        recordEntity.setTotalPlanMny(planChange.getTotalPlanMny());
        recordEntity.setChangePlanId(oldPlan.getChangeId());
        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if (null == recordEntity.getTotalPlanTaxMny()) {
            recordEntity.setTotalPlanTaxMny(BigDecimal.ZERO.setScale(8));
        }
        if (null == recordEntity.getTotalPlanMny()) {
            recordEntity.setTotalPlanMny(BigDecimal.ZERO.setScale(8));
        }
        if (null == recordEntity.getOriginalPlanTaxMny()) {
            recordEntity.setOriginalPlanTaxMny(BigDecimal.ZERO.setScale(8));
        }
        if (null == recordEntity.getOriginalPlanMny()) {
            recordEntity.setOriginalPlanMny(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeMny(recordEntity.getTotalPlanTaxMny().subtract(recordEntity.getOriginalPlanTaxMny()));
        if (recordEntity.getOriginalPlanTaxMny().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(new BigDecimal("0"));
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeMny().divide(recordEntity.getOriginalPlanTaxMny(), 8, 4).multiply(new BigDecimal(100)).setScale(2, 4));
        }
        this.masterPlanChangeHisService.saveOrUpdate((Object)recordEntity, false);
        recordEntity.getPlanDetailList().forEach(item -> {
            if (item.getParentId() != null) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"target_id", (Object)item.getParentId());
                query.eq((Object)"plan_id", (Object)item.getPlanId());
                PlanDetailChangeHisEntity one = (PlanDetailChangeHisEntity)((Object)((Object)this.planDetailChangeHisService.getOne((Wrapper)query)));
                if (one != null) {
                    item.setParentId(one.getId());
                }
            }
        });
        this.masterPlanChangeHisService.saveOrUpdate((Object)recordEntity, false);
        this.masterPlanChangeService.saveOrUpdate((Object)planChange, false);
        newPlanEntity = (PlanEntity)((Object)BeanMapper.map((Object)((Object)planChange), PlanEntity.class));
        newPlanEntity.setChangeState(PlanVO.PLAN_CHANGE_STATE_CHANGED);
        newPlanEntity.setChangeId(null);
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        ArrayList<Long> notDelDetailIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(planChange.getPlanDetailList())) {
            ArrayList<PlanDetailEntity> list = new ArrayList<PlanDetailEntity>();
            PlanDetailEntity tmp = null;
            Map<Long, PlanDetailEntity> map = oldPlan.getPlanDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, e -> e));
            List<PlanDetailEntity> oldList = oldPlan.getPlanDetailList();
            for (PlanDetailChangeEntity detail2 : planChange.getPlanDetailList()) {
                notDelDetailIds.add(detail2.getTargetId());
                tmp = (PlanDetailEntity)((Object)BeanMapper.map((Object)((Object)detail2), PlanDetailEntity.class));
                if (null != detail2.getTargetId()) {
                    tmp.setId(detail2.getTargetId());
                    tmp.setVersion(map.get(detail2.getTargetId()).getVersion());
                    if ("5".equals(detail2.getChangeType().toString())) {
                        delDetailIds.add(detail2.getTargetId());
                        continue;
                    }
                    tmp.setRowState("edit");
                    tmp.setId(tmp.getTargetId());
                    for (PlanDetailEntity planDetail : oldList) {
                        if (!planDetail.getId().equals(tmp.getTargetId())) continue;
                        tmp.setParentId(planDetail.getParentId());
                    }
                    list.add(tmp);
                    continue;
                }
                tmp.setRowState("add");
                for (PlanDetailEntity planDetail : oldList) {
                    if (!planDetail.getSourceId().equals(tmp.getDocCategoryId())) continue;
                    tmp.setParentId(planDetail.getId());
                    tmp.setTargetId(tmp.getId());
                }
                list.add(tmp);
            }
            newPlanEntity.setPlanDetailList(list);
        }
        this.logger.info("\u8ba1\u5212\u53d8\u66f4\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f85\u5220\u9664\u7ec8\u6b62\u9879\uff1adetailIds-{}", (Object)JSONObject.toJSONString(delDetailIds));
        if (CollectionUtils.isNotEmpty(delDetailIds) && oldPlan.getId() != null) {
            QueryWrapper removeWrapper = new QueryWrapper();
            removeWrapper.eq((Object)"plan_id", (Object)oldPlan.getId());
            removeWrapper.in((Object)"id", delDetailIds);
            this.masterPlanDetailService.remove((Wrapper)removeWrapper);
        }
        List<PlanDetailEntity> masterPlanDetailList = newPlanEntity.getPlanDetailList();
        HashMap idMap = new HashMap();
        masterPlanDetailList.forEach(cdEntity -> idMap.put(cdEntity.getTid(), cdEntity.getId()));
        masterPlanDetailList.forEach(cdEntity -> {
            if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        });
        newPlanEntity.setPlanDetailList(masterPlanDetailList);
        if (this.masterPlanService.saveOrUpdate((Object)newPlanEntity, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            CommonResponse.success((String)"\u6709\u5ba1\u6279\u6d41\u7a0b\u7684\u53d8\u66f4\u603b\u8ba1\u5212\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        PlanChangeEntity planChange = (PlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"change_plan_id", (Object)billId);
        PlanChangeHisEntity hisEntity = (PlanChangeHisEntity)((Object)this.masterPlanChangeHisService.getOne((Wrapper)hisQuery));
        if (null != hisEntity) {
            PlanEntity newPlanEntity = null;
            PlanEntity oldPlan = (PlanEntity)((Object)this.masterPlanService.selectById(planChange.getSourcePlanId()));
            this.logger.info("\u603b\u8ba1\u5212\u6267\u884c\u5f03\u5ba1\u6570\u636e\u6062\u590d\u903b\u8f91\uff0c\u5f53\u524d\u6570\u636e\u3010{}\u3011\uff0c\u5f85\u6062\u590d\u6570\u636e\u3010{}\u3011", (Object)oldPlan, (Object)hisEntity);
            newPlanEntity = (PlanEntity)((Object)BeanMapper.map((Object)((Object)hisEntity), PlanEntity.class));
            newPlanEntity.setChangeId(hisEntity.getChangePlanId());
            newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
            newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
            newPlanEntity.setCreateTime(oldPlan.getCreateTime());
            newPlanEntity.setId(oldPlan.getId());
            newPlanEntity.setVersion(oldPlan.getVersion());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion());
            newPlanEntity.setChangeState(PlanVO.PLAN_CHANGE_STATE_CHANGING);
            newPlanEntity.setTotalPlanTaxMny(hisEntity.getOriginalPlanTaxMny());
            newPlanEntity.setTotalPlanMny(hisEntity.getOriginalPlanMny());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);
            ArrayList<Long> delDetailIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(planChange.getPlanDetailList())) {
                ArrayList<PlanDetailEntity> list = new ArrayList<PlanDetailEntity>();
                PlanDetailEntity tmp = null;
                Map<Long, Integer> map = oldPlan.getPlanDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                for (PlanDetailChangeEntity detail : planChange.getPlanDetailList()) {
                    tmp = (PlanDetailEntity)((Object)BeanMapper.map((Object)((Object)detail), PlanDetailEntity.class));
                    if (null != detail.getTargetId()) {
                        tmp.setVersion(map.get(detail.getTargetId()));
                        tmp.setId(detail.getTargetId());
                        if (detail.getChangeType().equals("1")) {
                            delDetailIds.add(detail.getId());
                            continue;
                        }
                        list.add(tmp);
                        continue;
                    }
                    delDetailIds.add(detail.getId());
                }
                newPlanEntity.setPlanDetailList(list);
            }
            if (CollectionUtils.isNotEmpty(delDetailIds)) {
                this.masterPlanDetailService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
            }
            this.masterPlanChangeHisService.removeById(hisEntity.getId(), false);
            this.masterPlanService.saveOrUpdate((Object)newPlanEntity, false);
        }
        if (this.masterPlanChangeService.saveOrUpdate((Object)planChange, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }
}

