/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.service.INodeSettleService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="nodeSettle")
public class NodeSettleBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private INodeSettleService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u8282\u70b9\u7ed3\u7b97-\u63d0\u4ea4\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String msg;
        CommonResponse cooperateResp;
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity != null) {
            settleEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            settleEntity.setCommitDate(new Date());
            settleEntity.setCommitUserCode(userContext.getUserCode());
            settleEntity.setCommitUserName(userContext.getUserName());
        }
        if (!(cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode)).isSuccess()) {
            this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)billTypeCode, (Object)cooperateResp.getMsg());
            settleEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.service.saveOrUpdate((Object)settleEntity, false);
        if (cooperateResp.isSuccess()) {
            this.settleService.pushBillToSupCenter((SettleEntity)((Object)BeanMapper.map((Object)((Object)settleEntity), SettleEntity.class)), billTypeCode, (CooperateVO)cooperateResp.getData());
        }
        if (StringUtils.isNotBlank((CharSequence)(msg = this.settleService.pushSettleToPool((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class))))) {
            this.logger.error("\u8282\u70b9\u7ed3\u7b97\u5355-\u3010{}\u3011\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity)), (Object)msg);
        }
        this.updateContractPoolTotalSettleMnyAfterSettle(settleEntity, "approve");
        return CommonResponse.success((String)"\u8282\u70b9\u7ed3\u7b97\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        this.logger.info("\u8282\u70b9\u7ed3\u7b97\u5f03\u5ba1/\u64a4\u56de\u524d\u56de\u8c03\u7ed3\u7b97\u5b9e\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode().equals(settleEntity.getSupplierSignStatus())) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5df2\u7b7e\u5b57\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (!statusList.contains(settleEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u8d70\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)settleEntity.getContractId());
        lambda.eq(SettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
        int resultCount = this.settleService.count((Wrapper)lambda);
        this.logger.info("\u67e5\u8be2\u5b8c\u5de5\u7ed3\u7b97\u4fe1\u606f\uff1acontractId-" + settleEntity.getContractId());
        this.logger.info("\u67e5\u8be2\u7ed3\u679c\uff1aresultCount-" + resultCount);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6240\u7528\u5408\u540c\u5df2\u88ab\u5b8c\u5de5\u7ed3\u7b97\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)settleEntity.getContractId());
        settleLambda.ne(BaseEntity::getId, (Object)billId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = this.settleService.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = null != ((SettleEntity)((Object)resultList.get(0))).getSettleType() ? SettleTypeEnum.getDescriptionByCode(((SettleEntity)((Object)resultList.get(0))).getSettleType()).getDescription() : "";
            return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684" + settleTypeName + "\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!"));
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)settleEntity.getContractId()));
        param.getOrderMap().put("create_time", "desc");
        List settleList = this.settleService.queryList(param);
        this.logger.info("\u67e5\u8be2\u8282\u70b9\u7ed3\u7b97\u4fe1\u606f\uff1acontractId-" + settleEntity.getContractId());
        if (CollectionUtils.isNotEmpty((Collection)settleList) && null != settleList.get(0)) {
            this.logger.info("\u67e5\u8be2\u6700\u65b0\u7684\u8282\u70b9\u7ed3\u7b97\u5355\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(settleList.get(0), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            SettleEntity nodeSettle = (SettleEntity)((Object)settleList.get(0));
            this.logger.info("nodeSettle.id-" + nodeSettle.getId());
            this.logger.info("billId-" + billId);
            if (!nodeSettle.getId().equals(billId)) {
                // empty if block
            }
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(settleEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(settleEntity.getBillState())) {
            String unPushRes = this.settleService.delSettleFromPool(settleEntity.getId());
            if (!StringUtils.isBlank((CharSequence)unPushRes)) {
                this.logger.error("\u5c06\u8282\u70b9\u7ed3\u7b97\u5355-{}\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25\uff01", (Object)settleEntity);
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + unPushRes));
            }
            settleEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.updateContractPoolTotalSettleMnyAfterSettle(settleEntity, "back");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(settleEntity.getBillPushFlag())) {
            boolean pushResult = this.settleService.delPushBill(settleEntity, billTypeCode);
            if (!pushResult) {
                return CommonResponse.error((String)"\u8282\u70b9\u7ed3\u7b97\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5220\u9664\u534f\u540c\u670d\u52a1\u5355\u636e\u5931\u8d25\uff01");
            }
            settleEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.service.saveOrUpdate((Object)settleEntity, false);
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    private void updateContractPoolTotalSettleMnyAfterSettle(SettleEntity settleEntity, String type) {
        boolean updateRes = this.settleService.updateContractPoolTotalSettleMnyAfterSettle(settleEntity, type);
        if (updateRes) {
            this.logger.info("\u7ed3\u7b97\u5ba1\u6279\u901a\u8fc7\u540e/\u64a4\u56de\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u6210\u529f");
        } else {
            this.logger.error("\u7ed3\u7b97\u5ba1\u6279\u901a\u8fc7\u540e/\u64a4\u56de\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u5931\u8d25");
        }
    }
}

