package com.ejianc.business.prosub.settlePayment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prosub.settlePayment.bean.SettlePaymentEntity;
import com.ejianc.business.prosub.settlePayment.service.ISettlePaymentService;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service("settlePayment") 
public class SettlePaymentBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
	private ISettlePaymentService service;

    @Autowired
	private ISettleService settleService;

	@Autowired
	private SessionManager sessionManager;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};


	/**
	 * 有审批流提交完回调
	 *
	 * @param
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		SettlePaymentEntity settlePaymentEntity = service.selectById(billId);
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			UserContext userContext = sessionManager.getUserContext();
			settlePaymentEntity.setCommitDate(new Date());
			settlePaymentEntity.setCommitUserCode(userContext.getUserCode());
			settlePaymentEntity.setCommitUserName(userContext.getUserName());
		}

		service.saveOrUpdate(settlePaymentEntity, false);

		return CommonResponse.success("节点结算支付比例确认单审批回调处理成功！");
	}




	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};



	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SettlePaymentEntity settlePaymentEntity = service.selectById(billId);
		if (settlePaymentEntity != null) {
			settlePaymentEntity.setEffectiveDate(new Date());
		}
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			UserContext userContext = sessionManager.getUserContext();
			settlePaymentEntity.setCommitDate(new Date());
			settlePaymentEntity.setCommitUserCode(userContext.getUserCode());
			settlePaymentEntity.setCommitUserName(userContext.getUserName());
		}
		service.saveOrUpdate(settlePaymentEntity, false);

		SettleEntity settleEntity = settleService.selectById(settlePaymentEntity.getSettleId());
		settleEntity.setTotalSettlePaymentTaxMny(settlePaymentEntity.getTotalSettlePaymentTaxMny());
		settleEntity.setTotalSettlePaymentMny(settlePaymentEntity.getTotalSettlePaymentMny());
		settleService.saveOrUpdate(settleEntity, false);
		// 结算池推送
		logger.info("结算支付比例推送结算池对象settleEntity-{}", JSONObject.toJSONString(settleEntity));
		String msg = settleService.pushSettleToPool(BeanMapper.map(settleEntity, SettleVO.class));
		if(StringUtils.isNotBlank(msg)) {
			logger.error("节点结算单-更新累计结算支付金额-【{}】推送结算池失败, 原因：{}", JSONObject.toJSONString(settleEntity), msg);
		}
		return CommonResponse.success("结算支付比例确认单终审回调成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}


	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		SettlePaymentEntity settlePaymentEntity = service.selectById(billId);

		QueryWrapper<SettlePaymentEntity> listQueryOrderByTime = new QueryWrapper<>();
		listQueryOrderByTime.eq("settle_id", settlePaymentEntity.getSettleId());
		listQueryOrderByTime.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
		listQueryOrderByTime.orderByDesc("create_time");
		List<SettlePaymentEntity> listOrderByTime = service.list(listQueryOrderByTime);
		if (CollectionUtils.isNotEmpty(listOrderByTime) && null != listOrderByTime.get(0)){
			if (!listOrderByTime.get(0).getId().equals(billId)){
				return CommonResponse.error("当前单据不是最新的支付比例确认单，不能弃审/撤回！");
			}
		}

		if (settlePaymentEntity != null) {
			settlePaymentEntity.setEffectiveDate(null);
			settlePaymentEntity.setCommitDate(null);
			settlePaymentEntity.setCommitUserCode(null);
			settlePaymentEntity.setCommitUserName(null);
		}
		service.saveOrUpdate(settlePaymentEntity, false);

		SettleEntity settleEntity = settleService.selectById(settlePaymentEntity.getSettleId());
		settleEntity.setTotalSettlePaymentTaxMny(settlePaymentEntity.getLastSettlePaymentTaxMny());
		settleEntity.setTotalSettlePaymentMny(settlePaymentEntity.getLastSettlePaymentMny());
		settleService.saveOrUpdate(settleEntity, false);
		// 结算池推送
		String msg = settleService.pushSettleToPool(BeanMapper.map(settleEntity, SettleVO.class));
		if(StringUtils.isNotBlank(msg)) {
			logger.error("节点结算单-更新累计结算支付金额-【{}】推送结算池失败, 原因：{}", JSONObject.toJSONString(settleEntity), msg);
		}
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
