package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.bean.RegistrationDeductEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.DraftTypeEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("application") 
public class ApplicationBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IApplicationService service;
	@Autowired
	private IBillTypeApi billTypeApi;


	/**
	 * 提交完回调
	 *
	 * @param billId 单据id
	 * @param state 单据当前状态
	 * @return 返回当前成功信息
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ApplicationEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(e, false);
		return CommonResponse.success("零工申请审批回调处理成功");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId 单据id
	 * @param state 单据当前状态
	 * @return 返回当前成功信息
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}


	/**
	 * 终审审核完回调
	 * 判断当前是否有转扣单 有就为当前转扣单的合同创建的类型为转扣的 零工登记单
	 * @param billId 单据id
	 * @param state 单据当前状态
	 * @return 返回当前成功信息
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ApplicationEntity entity = service.selectById(billId);
		if (entity != null) {
			entity.setEffectiveDate(new Date());
		}
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			UserContext userContext = sessionManager.getUserContext();
			entity.setCommitDate(new Date());
			entity.setCommitUserCode(userContext.getUserCode());
			entity.setCommitUserName(userContext.getUserName());
		}

		service.saveOrUpdate(entity, false);
		return CommonResponse.success("零工申请审批回调成功！");
	}



	/**
	 * 弃审后事件回调
	 *
	 * @param billId 单据id
	 * @param state 单据当前状态
	 * @return 返回当前成功信息
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		ApplicationEntity entity = service.selectById(billId);
		if(entity.getUseFlag()==1){
			return CommonResponse.error("当前单据已被下游业务引用， 不能弃审！");
		}
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}


}
