/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class SettleSignFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISettleService settleService;

    @PostMapping(value={"/finishSettleFileUpdate/updateFileInfo"})
    public CommonResponse<JSONObject> updateFinishSignFileInfo(@RequestBody JSONObject updateData) {
        return this.updateSignFileInfo(updateData);
    }

    @PostMapping(value={"/nodeSettleFileUpdate/updateFileInfo"})
    public CommonResponse<JSONObject> updateNodeSignFileInfo(@RequestBody JSONObject updateData) {
        return this.updateSignFileInfo(updateData);
    }

    @PostMapping(value={"/processSettleFileUpdate/updateFileInfo"})
    public CommonResponse<JSONObject> updateProcessSettleFileInfo(@RequestBody JSONObject updateData) {
        return this.updateSignFileInfo(updateData);
    }

    private CommonResponse<JSONObject> updateSignFileInfo(JSONObject updateData) {
        JSONObject resp = new JSONObject();
        SettleEntity entity = (SettleEntity)((Object)this.settleService.selectById(updateData.getLong("billId")));
        entity.setContractFileId(updateData.getLong("fileId"));
        entity.setContractFileHighlightId(updateData.getLong("fileId"));
        entity.setContractFilePath(updateData.getString("fileOnlinePath"));
        entity.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        this.settleService.saveOrUpdate((Object)entity, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)entity);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"/nodeSettleFileUpdate/getSignedFileInfo"})
    public CommonResponse<JSONObject> getNodeSettleSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        return this.getSignedFileInfo(billId);
    }

    @GetMapping(value={"/processSettleFileUpdate/getSignedFileInfo"})
    public CommonResponse<JSONObject> getProcessSettleSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        return this.getSignedFileInfo(billId);
    }

    @GetMapping(value={"/finishSettleFileUpdate/getSignedFileInfo"})
    public CommonResponse<JSONObject> getFinishSettleSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        return this.getSignedFileInfo(billId);
    }

    private CommonResponse<JSONObject> getSignedFileInfo(Long billId) {
        JSONObject resp = new JSONObject();
        CommonResponse signResp = this.signatureManageApi.previewContract(billId, Arrays.asList(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", (Object)billId, (Object)signResp.getMsg());
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        List fileList = (List)signResp.getData();
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return CommonResponse.error((String)"\u4e3a\u83b7\u53d6\u5230\u5355\u636e\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
        SettleEntity entity = (SettleEntity)((Object)this.settleService.selectById(billId));
        entity.setSignedFileId(signedFileInfo.getFileId());
        this.settleService.saveOrUpdate((Object)entity, false);
        resp.put("fileId", (Object)signedFileInfo.getFileId());
        resp.put("filePath", (Object)signedFileInfo.getFilePath());
        resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

