/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.prosub.vo.SourceBliVO;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping
public class ContractApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService service;
    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private IOrgApi iOrgApi;

    @PostMapping(value={"/api/contract/updatePerformanceStatusById"})
    public CommonResponse<ContractVO> updatePerformanceStatusById(@RequestBody ContractVO vo) {
        if (this.service.updatePerformanceStatusById(vo.getId())) {
            CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u4fee\u6539\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/api/contract/getLinkUrl"})
    public CommonResponse<String> getLinkUrl(@RequestParam(value="contractId") Long contractId) {
        String linkUrl = this.service.getLinkUrl(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u7a7f\u900fURL\u6210\u529f\uff01", (Object)linkUrl);
    }

    @PostMapping(value={"/api/contract/updatePerformanceStatusByContractId"})
    public CommonResponse<ContractVO> updatePerformanceStatusByContractId(@RequestBody ContractVO vo) {
        this.logger.info("\u63a5\u6536\u5408\u540c\u540c\u6b65\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)vo));
        ContractVO resp = this.service.updatePerformanceStatusByContractId(vo);
        return CommonResponse.success((String)"\u66f4\u65b0\u5408\u540c\u6c60\u4e2d\u5408\u540c\u7684\u5c65\u7ea6\u72b6\u6001\u6210\u529f", (Object)resp);
    }

    @GetMapping(value={"/api/contract/getSourceBliVO"})
    @ResponseBody
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="dateIn", required=false) String dateIn) {
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        SourceBliVO vo = this.settleMapper.getSourceBliVO(supplierId, orgIds, dateIn);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)vo);
    }

    @GetMapping(value={"/api/contract/queryContractByTargetResultId"})
    @ResponseBody
    CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam(value="targetResultIdList") List<String> targetResultIdList) {
        if (CollectionUtils.isNotEmpty(targetResultIdList)) {
            this.logger.info("\u63a5\u6536\u5b9a\u6807id\u96c6\u5408\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(targetResultIdList));
            List<SignContractVo> signContractVoList = this.service.queryContractByTargetResultId(targetResultIdList);
            return CommonResponse.success((String)"\u6839\u636e\u62db\u6807id\u67e5\u8be2\u5408\u540c\u96c6\u5408\u6210\u529f\uff01", signContractVoList);
        }
        return CommonResponse.error((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5b9a\u6807id\u96c6\u53c2\u6570\uff01");
    }
}

