package com.ejianc.business.process.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.process.bean.MeasureDetailEntity;
import com.ejianc.business.process.mapper.MeasureDetailMapper;
import com.ejianc.business.process.service.IMeasureDetailService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分包计量计量清单实体
 *
 * @author generator
 */
@Service("measureDetailService")
public class MeasureDetailServiceImpl extends BaseServiceImpl<MeasureDetailMapper, MeasureDetailEntity> implements IMeasureDetailService {
    /**
     * 查询清单历史计量
     *
     * @param listId 合同清单id
     * @return 清单历史计量
     */
    @Override
    public BigDecimal queryLastWorkNum(Long listId, Long detailId) {
        QueryWrapper<MeasureDetailEntity> query = new QueryWrapper<>();
        query.eq("list_id", listId);
        query.select("ifnull(sum(measure),0) as lastTotalNum");
        if(null != detailId) {
            query.ne("id", detailId);
        }
        Map<String, Object> rs = super.getMap(query);
        return new BigDecimal(rs.get("lastTotalNum").toString());
    }

    @Override
    public Map<Long, BigDecimal> queryLastWorkNumByIds(List<Long> listIds) {
        QueryWrapper<MeasureDetailEntity> query = new QueryWrapper<>();
        query.in("list_id", listIds);
        query.select("list_id as listId, ifnull(sum(measure),0) as lastTotalNum");
        query.groupBy("list_id");

        List<Map<String, Object>> rs = super.listMaps(query);
        Map<Long, BigDecimal> result = new HashMap<>();
        rs.stream().forEach(r -> {
            result.put(Long.valueOf(r.get("listId").toString()), new BigDecimal(r.get("lastTotalNum").toString()));
        });

        for(Long listId : listIds) {
            if(!result.containsKey(listId)) {
                result.put(listId, BigDecimal.ZERO);
            }
        }

        return result;
    }
}
