/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.service.IFinishSettleService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="finishSettle")
public class FinishSettleBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IFinishSettleService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IFinishSettleService finishSettleService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u5b8c\u5de5\u7ed3\u7b97-\u63d0\u4ea4\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String msg;
        CommonResponse cooperateResp;
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity != null) {
            settleEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            settleEntity.setCommitDate(new Date());
            settleEntity.setCommitUserCode(userContext.getUserCode());
            settleEntity.setCommitUserName(userContext.getUserName());
        }
        if (!(cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode)).isSuccess()) {
            this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)billTypeCode, (Object)cooperateResp.getMsg());
            settleEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.service.saveOrUpdate((Object)settleEntity, false);
        if (cooperateResp.isSuccess()) {
            this.settleService.pushBillToSupCenter((SettleEntity)((Object)BeanMapper.map((Object)((Object)settleEntity), SettleEntity.class)), billTypeCode, (CooperateVO)cooperateResp.getData());
        }
        if (StringUtils.isNotBlank((CharSequence)(msg = this.settleService.pushSettleToPool((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class))))) {
            this.logger.error("\u6700\u7ec8\u7ed3\u7b97-\u3010{}\u3011\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c \u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity)), (Object)msg);
        }
        this.updateContractPoolTotalSettleMnyAfterSettle(settleEntity, "approve");
        this.settleService.costPush(settleEntity);
        SettleVO settleVO = this.service.getPushTargetCostSettleVO(settleEntity);
        String linkUrl = settleVO.getContractType() == 0 ? this.BaseHost + "ejc-prosub-frontend/#/finishSettle/laborsub/card?id=" + settleVO.getId() : this.BaseHost + "ejc-prosub-frontend/#/finishSettle/prosub/card?id=" + settleVO.getId();
        ExecutionVO executionVO = this.finishSettleService.targetCost(settleVO, linkUrl, settleVO.getContractType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u5b8c\u5de5\u7ed3\u7b97\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        this.executionAggDel(settleEntity);
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private void executionAggDel(SettleEntity settleEntity) {
        List<SettleDetailEntity> detailEntities = settleEntity.getSettleDetailList().stream().filter(item -> item.getSettleNum() != null).collect(Collectors.toList());
        settleEntity.setSettleDetailList(detailEntities);
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ExecutionVO executionVO = this.finishSettleService.targetCost((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), "", settleEntity.getContractType());
        totalExecutionVOList.add(executionVO.getTotalVO());
        this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25," + response.getMsg());
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        this.executionAggDel(settleEntity);
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5b8c\u5de5\u5355\u636ebillId-{}, state-{}, billTypeCode-{}\u64a4\u56de\u524d\u6821\u9a8c", new Object[]{billId, state, billTypeCode});
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        this.logger.info("\u5b8c\u5de5\u7ed3\u7b97\u5f03\u5ba1/\u64a4\u56de\u524d\u56de\u8c03\u7ed3\u7b97\u5b9e\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode().equals(settleEntity.getSupplierSignStatus())) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5df2\u7b7e\u5b57\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (!statusList.contains(settleEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u8d70\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(settleEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(settleEntity.getBillState())) {
            String unPushRes = this.settleService.delSettleFromPool(settleEntity.getId());
            if (!StringUtils.isBlank((CharSequence)unPushRes)) {
                this.logger.error("\u5c06\u5b8c\u5de5\u7ed3\u7b97\u5355-{}\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25\uff01", (Object)settleEntity);
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + unPushRes));
            }
            settleEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.updateContractPoolTotalSettleMnyAfterSettle(settleEntity, "back");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(settleEntity.getBillPushFlag())) {
            boolean pushResult = this.settleService.delPushBill(settleEntity, billTypeCode);
            if (!pushResult) {
                return CommonResponse.error((String)"\u5b8c\u5de5\u7ed3\u7b97\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5220\u9664\u534f\u540c\u670d\u52a1\u5355\u636e\u5931\u8d25\uff01");
            }
            settleEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.service.saveOrUpdate((Object)settleEntity, false);
        }
        if ("1".equals(settleEntity.getRelationFlag())) {
            this.settleService.costDeletePush(settleEntity);
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    private void updateContractPoolTotalSettleMnyAfterSettle(SettleEntity settleEntity, String type) {
        boolean updateRes = this.settleService.updateContractPoolTotalSettleMnyAfterSettle(settleEntity, type);
        if (updateRes) {
            this.logger.info("\u7ed3\u7b97\u5ba1\u6279\u901a\u8fc7\u540e/\u64a4\u56de\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u6210\u529f");
        } else {
            this.logger.error("\u7ed3\u7b97\u5ba1\u6279\u901a\u8fc7\u540e/\u64a4\u56de\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u5931\u8d25");
        }
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            SettleEntity entity = (SettleEntity)((Object)this.settleService.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

