package com.ejianc.business.prosub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;

import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.prosub.vo.SourceBliVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 分包合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping
public class ContractApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService service;

    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private IOrgApi iOrgApi;

    // 更新合同履约状态为 封张
    @PostMapping(value = "/api/contract/updatePerformanceStatusById")
    public CommonResponse<ContractVO> updatePerformanceStatusById(@RequestBody ContractVO vo) {
        if (service.updatePerformanceStatusById(vo.getId())) {
            CommonResponse.success("修改合同履约状态成功！");
        }
        return CommonResponse.error("修改合同履约状态失败！");
    }

    // 查询合同穿透URL
    @GetMapping(value = "/api/contract/getLinkUrl")
    public CommonResponse<String> getLinkUrl(@RequestParam("contractId") Long contractId) {
        String linkUrl = service.getLinkUrl(contractId);
        return CommonResponse.success("查询合同穿透URL成功！", linkUrl);
    }



    // 更新合同履约状态
    @PostMapping(value = "/api/contract/updatePerformanceStatusByContractId")
    public CommonResponse<ContractVO> updatePerformanceStatusByContractId(@RequestBody ContractVO vo) {
        logger.info("接收合同同步数据: {}", JSONObject.toJSONString(vo));
        ContractVO resp = service.updatePerformanceStatusByContractId(vo);
        return CommonResponse.success("更新合同池中合同的履约状态成功", resp);
    }
    @GetMapping(value = "/api/contract/getSourceBliVO")
    @ResponseBody
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId, @RequestParam(value = "dateIn",required = false) String dateIn){
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        SourceBliVO vo= settleMapper.getSourceBliVO(supplierId,orgIds,dateIn);
        return CommonResponse.success("查询成功", vo);
    }


    /**
     * 根据招标id查询合同集合
     * @param targetResultIdList
     * @return
     */
    @GetMapping(value = "/api/contract/queryContractByTargetResultId")
    @ResponseBody
    CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam(value = "targetResultIdList") List<String> targetResultIdList){
        if (CollectionUtils.isNotEmpty(targetResultIdList)){
            logger.info("接收定标id集合数据：{}", JSONObject.toJSONString(targetResultIdList));
            List<SignContractVo> signContractVoList = service.queryContractByTargetResultId(targetResultIdList);
            return CommonResponse.success("根据招标id查询合同集合成功！", signContractVoList);
        }else {
            return CommonResponse.error("请传入正确的定标id集参数！");
        }
    }

}
