package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.process.vo.ImprotSalaryDetailVO;
import com.ejianc.business.process.vo.SalaryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.process.mapper.SalaryMapper;
import com.ejianc.business.process.bean.SalaryEntity;
import com.ejianc.business.process.service.ISalaryService;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 工人工资单主实体
 * 
 * @author generator
 * 
 */
@Service("salaryService")
public class SalaryServiceImpl extends BaseServiceImpl<SalaryMapper, SalaryEntity> implements ISalaryService{
    @Autowired
    private SalaryMapper salaryMapper;
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static  final  String IdCardRegex="/(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)/";
    @Override
    public List<SalaryVO> checkContract(Long contractId, String belongMonth) {
        return salaryMapper.checkContract(contractId,belongMonth);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImprotSalaryDetailVO> successList = new ArrayList<>();
            List<ImprotSalaryDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 13) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=10000){
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ImprotSalaryDetailVO salaryDetailVO = new ImprotSalaryDetailVO();
                    //WorkerName
                    if (StringUtils.isBlank(datas.get(0))) {
                        salaryDetailVO.setErrorMessage("名字为必填项");
                    }
                    else if (datas.get(0).length() > 20 || datas.get(0).length()==1 ) {
                        salaryDetailVO.setErrorMessage("名字填写长度为1~20字");
                    }
                    salaryDetailVO.setWorkerName(datas.get(0));

                    //WorkType
                    if (datas.get(1).length() > 20) {
                        salaryDetailVO.setErrorMessage("填写工种长度为0~20字");
                    }
                    salaryDetailVO.setWorkType(datas.get(1));
                    //IdCard
                    if (datas.get(2).length() > 18) {
                        salaryDetailVO.setErrorMessage("填写身份证号码长度为18字");
                    }
                    if ((datas.get(2)!=null) && (StringUtils.isNotBlank(datas.get(2)))){
                        if (!datas.get(2).matches(IdCardRegex)){
                            salaryDetailVO.setErrorMessage("填写身份证号错误");
                        }
                    }
                    salaryDetailVO.setIdCard(datas.get(2));

                    //BankCard
                    if (!datas.get(3).matches(regex)){
                        salaryDetailVO.setErrorMessage("填写银行卡号长度为18填写错误");
                    }
                    salaryDetailVO.setBankCard(datas.get(3));
                    //BankName
                    if (datas.get(4).length()>20){
                        salaryDetailVO.setErrorMessage("填写开户行长度为0~20字");
                    }
                    salaryDetailVO.setBankName(datas.get(4));
                    //MeasurementType
                    if (StringUtils.isBlank(datas.get(5))) {
                        salaryDetailVO.setErrorMessage("计量方式为必填项");
                    }
                    else if (datas.get(5).length()!=2) {
                        salaryDetailVO.setErrorMessage("计量方式填写错误");
                    }
                    else if (datas.get(5).equals("计日") ) {
                        salaryDetailVO.setMeasurementType("0");
                    }
                    else if (datas.get(5).equals("计件") ) {
                        salaryDetailVO.setMeasurementType("1");
                    }
                    //Workload
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            salaryDetailVO.setWorkload(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("工作量为必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("工作量为必填项");
                    }
                    //Price
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            salaryDetailVO.setPrice(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("单价为必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("单价为必填项");
                    }
                    //OvertimeMeasureType
                    if (datas.get(8).equals("计日") ) {
                        salaryDetailVO.setOvertimeMeasureType("0");
                    }
                    else if (datas.get(8).equals("计件") ) {
                        salaryDetailVO.setOvertimeMeasureType("1");
                    }
                    //OvertimeNum
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                            salaryDetailVO.setOvertimeNum(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("加班工作量为必须为数字");
                        }
                    }
                    //setShouldSalaryMmy
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        try {
                            salaryDetailVO.setShouldSalaryMny(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("应发工资为必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("应发工资为必填项");
                    }
                    //setDeductMny
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        try {
                            salaryDetailVO.setDeductMny(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("扣款费用为必须为数字");
                        }
                    }
                    //
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        try {
                            salaryDetailVO.setSalaryMny(new BigDecimal(datas.get(12)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("实发工资为必须为数字");
                        }
                    }
                    if (StringUtils.isBlank(salaryDetailVO.getErrorMessage())) {
                        successList.add(salaryDetailVO);
                    }else {
                        errorList.add(salaryDetailVO);
                    }
                }
            }
            //errorListTable
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}
