package com.ejianc.business.contract.relieve.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contract.relieve.vo.ContractRelieveVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 合同解除实体
 *
 * @author generator
 */
@RestController
@RequestMapping("contractRelieve")
public class ContractRelieveController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "RELIEVE_CON";

    @Autowired
    private IContractRelieveService service;

    @Autowired
    private IContractService contractService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectSetApi projectSetApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<ContractRelieveVO> saveOrUpdate(@RequestBody ContractRelieveVO saveOrUpdateVO) {
        //成本关门后 不允许变更
        CommonResponse<ProjectPoolSetVO> projectRes = projectSetApi.getProjectId(saveOrUpdateVO.getProjectId());
        if(projectRes.isSuccess()&&("16").equals(projectRes.getData().getCapitalStatus())){
            throw new BusinessException("该项目资金管控状态为【成本关门】，不允许此操作!");
        }
        ContractRelieveEntity entity = BeanMapper.map(saveOrUpdateVO, ContractRelieveEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 查询合同状态：不是履约中不可以解除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());
        if (contractEntity == null || !PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())) {
            throw new BusinessException("查询不到合同或合同状态非履约中！");
        }
        // 添加校验
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, entity.getContractId()));
        List<ContractRelieveEntity> list = service.queryList(param);
        if (list.size() > 1) {
            throw new BusinessException("一个合同只能有一份合同解除协议!");
        }
        // 起草方式 1、上传解除协议，初始化签章状态为；1-未签章
        if (entity.getDraftType() == 1) {
            entity.setSignatureStatus("1");
        }
        service.saveOrUpdate(entity, false);
        ContractRelieveVO vo = BeanMapper.map(entity, ContractRelieveVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<ContractRelieveVO> queryDetail(Long id) {
        ContractRelieveEntity entity = service.selectById(id);
        ContractRelieveVO vo = BeanMapper.map(entity, ContractRelieveVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<ContractRelieveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractRelieveVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ContractRelieveVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<ContractRelieveVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ContractRelieveEntity> page = service.queryPage(param, false);
        IPage<ContractRelieveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRelieveVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 合同解除参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractRelieveRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> contractRelieveRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText){

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        //设置模糊查询
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (!(null != conditionMap.get("orgId") || null != conditionMap.get("projectId"))){
            return CommonResponse.error("当前传入项目id 或 组织id为空！");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")){
            return CommonResponse.error("当前传入组织类型为空！");
        }
        if(null != conditionMap.get("contractType")) {
            queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ, conditionMap.get("contractType")));
        }
        if (null != conditionMap.get("projectId")){
            Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }else {

            //查询本下范围内日的合同
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("filing_status", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        IPage<ContractRelieveEntity> pageData= service.queryPage(queryParam,false);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractRelieveVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同解除数据成功！",page);
    }

    /**
     * 合同解除参照查询--劳务
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractRelieveLaborRef",method = RequestMethod.GET)
    public CommonResponse<IPage<ContractRelieveVO>> contractRelieveLaborRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                            String condition,
                                                                            String searchObject,
                                                                            String searchText){

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);

        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        // 合同类型
        queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ, 0));

        IPage<ContractRelieveEntity> page = service.queryPage(queryParam,false);
        IPage<ContractRelieveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRelieveVO.class));
        return CommonResponse.success("查询分包合同解除数据成功！",pageData);
    }

    /**
     * 合同解除参照查询--专业
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractRelieveSubRef",method = RequestMethod.GET)
    public CommonResponse<IPage<ContractRelieveVO>> contractRelieveSubRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                          String condition,
                                                                          String searchObject,
                                                                          String searchText){

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);

        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        // 合同类型
        queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ, 1));

        IPage<ContractRelieveEntity> page = service.queryPage(queryParam,false);
        IPage<ContractRelieveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRelieveVO.class));
        return CommonResponse.success("查询分包合同解除数据成功！",pageData);
    }
}
