package com.ejianc.business.process.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.TeamDetailEntity;
import com.ejianc.business.process.bean.TeamEntity;
import com.ejianc.business.process.enums.TeamStatusEnum;
import com.ejianc.business.process.service.ITeamDetailService;
import com.ejianc.business.process.service.ITeamService;
import com.ejianc.business.process.vo.TeamDetailVO;
import com.ejianc.business.process.vo.TeamVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 班组主表
 *
 * @author generator
 */
@Controller
@RequestMapping("team")
public class TeamController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TEAM_USE";//此处需要根据实际修改

    @Autowired
    private ITeamService service;
    @Autowired
    private ITeamDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TeamVO> saveOrUpdate(@RequestBody TeamVO saveOrUpdateVO) {
        TeamEntity entity = BeanMapper.map(saveOrUpdateVO, TeamEntity.class);
        if (entity.getId() == null) {
            //根据当前合同查询是否已经又dr为0 的合同关联数据
            QueryWrapper<TeamEntity> query = new QueryWrapper<>();
            query.eq("contract_id", entity.getContractId());
            query.eq("dr", 0);
            int count = service.count(query);
            if (count > 0) {
                logger.info("当前{}合同已存在班组单 一个合同下只能有一个", entity.getContractName());
                throw new BusinessException("一个合同下只能有一个班组单， 请更换合同！");
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

        }
        List<TeamDetailEntity> teamDetailList = entity.getTeamDetailList();

        StringBuilder teamUsers = new StringBuilder();
        for (TeamDetailEntity detailEntity : teamDetailList) {
            if (StringUtils.isNotEmpty(detailEntity.getTeamDetailName())) {
                if (teamUsers.length() > 0) {
                    teamUsers.append(",");
                }
                teamUsers.append(detailEntity.getTeamDetailName());
            }
        }
        entity.setTeamUsers(teamUsers.toString());
        service.saveOrUpdate(entity, false);
        TeamVO vo = BeanMapper.map(entity, TeamVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TeamVO> queryDetail(Long id) {
        TeamEntity entity = service.selectById(id);
        TeamVO vo = BeanMapper.map(entity, TeamVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TeamVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TeamVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> collect = vos.stream().map(TeamVO::getId).collect(Collectors.toList());
        for (Long id:collect){
            TeamEntity teamEntity = service.selectById(id);
            List<TeamDetailEntity> detailList = teamEntity.getTeamDetailList();
            if(CollectionUtil.isNotEmpty(detailList)){
                List<Long> detailIds = detailList.stream().map(TeamDetailEntity::getId).collect(Collectors.toList());
                CommonResponse commonResponse = service.queryReferenceTeam(detailIds);
                if(commonResponse.isSuccess()){
                    Boolean data = (Boolean) commonResponse.getData();
                    if (!data){
                        return CommonResponse.error(teamEntity.getContractName()+commonResponse.getMsg());
                    }
                }else {

                }
            }
        }
        service.removeByIds(vos.stream().map(TeamVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> queryList(@RequestBody QueryParam param) {

        //模糊搜索配置字段示例
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("compileName");
        fuzzyFields.add("billCode");

        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<TeamEntity> page = service.queryPage(param, false);
        IPage<TeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TeamVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        //查询所有满足的数据 按照创建时间倒叙
        param.getOrderMap().put("create_time", QueryParam.DESC);
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<TeamEntity> pageData = service.queryPage(param, false);

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<TeamVO> list = BeanMapper.mapList(pageData.getRecords(), TeamVO.class);
            for (TeamVO vo:list){
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                vo.setCompileDateStr(sdf.format(vo.getCompileDate()));
            }
            Map<String, Object> beans = new HashMap<>(list.size());
            logger.error(JSONObject.toJSONString(list));
            beans.put("records", list);
            ExcelExport.getInstance().export("team-export.xlsx", beans, response);
        }
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refTeamData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> refTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TeamEntity> page = service.queryPage(param, false);
        IPage<TeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TeamVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 参照
     * @Return void
     * 传入合同id:必传   excludeIds:可选 逗号分割 本次查询不查询传入的班组id
     */
    @RequestMapping(value = "/refTeamDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TeamDetailVO>> refTeamDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
//        param.setPageSize(pageSize);
//        param.setPageIndex(pageNumber);
//        param.setSearchText(searchText);
//        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 合同id
            if (condition.contains("contractId")) {
                param.getParams().put("team_contract_id", new Parameter(QueryParam.EQ, _con.getString("contractId")));
            } else if (condition.contains("projectId")){

                param.getParams().put("project_id", new Parameter(QueryParam.EQ, _con.getString("projectId")));

            }else {
                return CommonResponse.error("请传入合同id！或者传入项目id");

            }
            // 封装查询时排除的数据的结算池数据的ID
            String excludeIdStr = _con.getString("excludeIds");
            if (StringUtils.isNotBlank(excludeIdStr)) {
                param.getParams().put("id", new Parameter(QueryParam.NOT_IN, Lists.newArrayList(excludeIdStr.split(","))));
            }
        } else {
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        List<TeamEntity> teamEntities = service.queryList(param);
        IPage<TeamDetailVO> pageData = new Page<>(1,10, 0);
        if (CollectionUtils.isNotEmpty(teamEntities)){
            List<Long> collect = teamEntities.stream().map(TeamEntity::getId).collect(Collectors.toList());

            QueryParam queryParam = new QueryParam();
            List<String> fuzzyFields = queryParam.getFuzzyFields();
            fuzzyFields.add("team_detail_name");
            queryParam.setPageSize(pageSize);
            queryParam.setPageIndex(pageNumber);
            queryParam.setSearchText(searchText);
            queryParam.setSearchObject(searchObject);
            queryParam.getParams().put("team_id",new Parameter(QueryParam.IN,collect));
            /** 查询到启用的子表*/
            queryParam.getParams().put("team_detail_status", new Parameter(QueryParam.EQ, TeamStatusEnum.启用.getCode()));
            String searchText1 = queryParam.getSearchText();
            IPage<TeamDetailEntity> page = detailService.queryPage(queryParam, false);
             pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), TeamDetailVO.class));
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }



    /**
     * @Description 参照
     * @Return void
     * 传入合同id:必传   excludeIds:可选 逗号分割 本次查询不查询传入的班组id
     */
    @RequestMapping(value = "/queryContractTeamDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<TeamDetailVO>> queryContractTeamDetailData(String contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("team_contract_id", new Parameter(QueryParam.EQ, contractId));
        /** 查询到启用的子表*/
        param.getParams().put("team_detail_status", new Parameter(QueryParam.EQ, TeamStatusEnum.启用.getCode()));
        List<TeamDetailEntity> teamDetailEntities = detailService.queryList(param, false);
        List<TeamDetailVO> teamDetailVOS = BeanMapper.mapList(teamDetailEntities, TeamDetailVO.class);
        return CommonResponse.success("查询参照数据成功！", teamDetailVOS);
    }
    /**
     * @Description 校验子表数据是否可以删除
     * @Param [vos]
     */
    @RequestMapping(value = "/queryReferenceTeam", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> queryReferenceTeam(@RequestBody List<TeamDetailVO> vos) {
        return service.queryReferenceTeam(vos.stream().map(TeamDetailVO::getId).collect(Collectors.toList()));
    }
}
