package com.ejianc.business.prosub.mapper;

import com.ejianc.business.market.vo.ProjectSetVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.prosub.bean.AccountEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 劳务纠纷台账实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface AccountMapper extends BaseCrudMapper<AccountEntity> {


    @Select("SELECT * FROM `ejc_prosub_account`\n" +
            "where dr = 0 and bill_state in (1,3)\n" +
            "and DATE_SUB(CURDATE(), INTERVAL 3 DAY) <= date(create_time)\n" +
            "and project_id in (\n" +
            "select project_id from `ejc-proincome`.ejc_income_contract_register where dr = 0 and bill_state in (1,3) and contract_tax_mny >= 2000000\n" +
            ") and project_id in (\n" +
            "select id from `ejc-promarket`.ejc_promarket_project_set where dr = 0 and bill_state in (1,3) and business_status = 2\n" +
            ")")
    List<AccountEntity> accountCreateWarn();


    @Select("SELECT * FROM `ejc_prosub_account`\n" +
            "where dr = 0 and bill_state in (1,3) and processing_status in (1597414811027640322,1597414847241261057)\n" +
            "and DATE_SUB(CURDATE(), INTERVAL 2 DAY) <= date(solutions_date)\n" +
            "and project_id in (\n" +
            "select project_id from `ejc-proincome`.ejc_income_contract_register where dr = 0 and bill_state in (1,3) and contract_tax_mny >= 2000000\n" +
            ") and project_id in (\n" +
            "select id from `ejc-promarket`.ejc_promarket_project_set where dr = 0 and bill_state in (1,3) and business_status = 2\n" +
            ")")
    List<AccountEntity> accountUpdateWarn();


    @Select("select * from `ejc-promarket`.ejc_promarket_project_set where dr = 0 and bill_state in (1,3) and business_status = 2\n" +
            "and id in (select project_id from `ejc-proincome`.ejc_income_contract_register where dr = 0 and bill_state in (1,3) and contract_tax_mny >= 2000000)\n" +
            "and id not in (SELECT project_id FROM `ejc_prosub_oldjob_registration`\n" +
            "where dr = 0 and bill_state in (1,3) and DATE_SUB(CURDATE(), INTERVAL 62 DAY) <= date(commit_date)\n" +
            "GROUP BY project_id)\n" +
            "and id not in (SELECT project_id FROM `ejc_prosub_deduction`\n" +
            "where dr = 0 and bill_state in (1,3) and DATE_SUB(CURDATE(), INTERVAL 62 DAY) <= date(commit_date)\n" +
            "GROUP BY project_id)")
    List<ProjectSetVO> noDeductionWarn();
}
