package com.ejianc.business.prosub.warn;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.vo.ApplicationVO;
import com.ejianc.business.prosub.bean.AccountEntity;
import com.ejianc.business.prosub.mapper.AccountMapper;
import com.ejianc.business.prosub.mapper.ContractMapper;
import com.ejianc.business.prosub.subSalary.vo.SubSalaryVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.IProcessSettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/accountWarn/")
public class AccountWarnController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-prosub-frontend/#/account/card?id=";


    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private AccountMapper accountMapper;

    /**
     * 新增劳务纠纷
     */
    @PostMapping(value = "accountWarn")
    public CommonResponse<String> accountWarn(@RequestBody JSONArray jsonParam) {
        logger.info("accountWarn接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<AccountEntity> warnEntities = accountMapper.accountCreateWarn();
            logger.info("本次共获取单据数量{}条",warnEntities.size());
            if (ListUtil.isNotEmpty(warnEntities)) {
                for (AccountEntity pvo : warnEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = pvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                high = true;
                                useSetHigh = set;
                            }else if ("中".equals(set.getString("warningLevel"))) {
                                meddle = true;
                                useSetMeddle = set;
                            }else if ("低".equals(set.getString("warningLevel"))) {
                                low = true;
                                useSetLow = set;
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName("-劳务纠纷-"+pvo.getBillCode());
                            vo.setPcTitle("新增劳务纠纷");
                            vo.setPcUrl(PC_URL+pvo.getId());
                            vo.setOrgId(pvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(pvo.getOrgId() + "");
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(pvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                        .replaceAll("#contractName#",
                                                pvo.getContractName() != null ? pvo.getContractName() : "无")
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                .replaceAll("#contractName#",
                                                        pvo.getContractName() != null ? pvo.getContractName() : "无")
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                .replaceAll("#contractName#",
                                                        pvo.getContractName() != null ? pvo.getContractName() : "无")
                                );
                            }
                            warnList.add(vo);
                        }
                    }

                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    /**
     * 劳务纠纷消除
     */
    @PostMapping(value = "accountUpdateWarn")
    public CommonResponse<String> accountUpdateWarn(@RequestBody JSONArray jsonParam) {
        logger.info("accountUpdateWarn接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<AccountEntity> warnEntities = accountMapper.accountUpdateWarn();
            logger.info("本次共获取单据数量{}条",warnEntities.size());
            if (ListUtil.isNotEmpty(warnEntities)) {
                for (AccountEntity pvo : warnEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = pvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                high = true;
                                useSetHigh = set;
                            }else if ("中".equals(set.getString("warningLevel"))) {
                                meddle = true;
                                useSetMeddle = set;
                            }else if ("低".equals(set.getString("warningLevel"))) {
                                low = true;
                                useSetLow = set;
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName("-劳务纠纷-"+pvo.getBillCode());
                            vo.setPcTitle("劳务纠纷消除");
                            vo.setPcUrl(PC_URL+pvo.getId());
                            vo.setOrgId(pvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(pvo.getOrgId() + "");
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(pvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                        .replaceAll("#contractName#",
                                                pvo.getContractName() != null ? pvo.getContractName() : "无")
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                .replaceAll("#contractName#",
                                                        pvo.getContractName() != null ? pvo.getContractName() : "无")
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                .replaceAll("#contractName#",
                                                        pvo.getContractName() != null ? pvo.getContractName() : "无")
                                );
                            }
                            warnList.add(vo);
                        }
                    }

                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    /**
     * 劳务纠纷消除
     */
    @PostMapping(value = "noDeductionWarn")
    public CommonResponse<String> noDeductionWarn(@RequestBody JSONArray jsonParam) {
        logger.info("accountUpdateWarn接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ProjectSetVO> warnEntities = accountMapper.noDeductionWarn();
            logger.info("本次共获取单据数量{}条",warnEntities.size());
            if (ListUtil.isNotEmpty(warnEntities)) {
                for (ProjectSetVO pvo : warnEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = pvo.getProjectDepartmentId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                high = true;
                                useSetHigh = set;
                            }else if ("中".equals(set.getString("warningLevel"))) {
                                meddle = true;
                                useSetMeddle = set;
                            }else if ("低".equals(set.getString("warningLevel"))) {
                                low = true;
                                useSetLow = set;
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName("-无零工、奖罚单-"+pvo.getName());
                            vo.setPcTitle("未做零工登记、奖罚单");
                            vo.setPcUrl(PC_URL+pvo.getId());
                            vo.setOrgId(pvo.getProjectDepartmentId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(pvo.getProjectDepartmentId() + "");
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(pvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                );
                            }
                            warnList.add(vo);
                        }
                    }

                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }

}
