/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.settlePayment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prosub.settlePayment.bean.SettlePaymentEntity;
import com.ejianc.business.prosub.settlePayment.service.ISettlePaymentService;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="settlePayment")
public class SettlePaymentBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISettlePaymentService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SettlePaymentEntity settlePaymentEntity = (SettlePaymentEntity)((Object)this.service.selectById(billId));
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            settlePaymentEntity.setCommitDate(new Date());
            settlePaymentEntity.setCommitUserCode(userContext.getUserCode());
            settlePaymentEntity.setCommitUserName(userContext.getUserName());
        }
        this.service.saveOrUpdate((Object)settlePaymentEntity, false);
        return CommonResponse.success((String)"\u8282\u70b9\u7ed3\u7b97\u652f\u4ed8\u6bd4\u4f8b\u786e\u8ba4\u5355\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettlePaymentEntity settlePaymentEntity = (SettlePaymentEntity)((Object)this.service.selectById(billId));
        if (settlePaymentEntity != null) {
            settlePaymentEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            settlePaymentEntity.setCommitDate(new Date());
            settlePaymentEntity.setCommitUserCode(userContext.getUserCode());
            settlePaymentEntity.setCommitUserName(userContext.getUserName());
        }
        this.service.saveOrUpdate((Object)settlePaymentEntity, false);
        SettleEntity settleEntity = (SettleEntity)((Object)this.settleService.selectById(settlePaymentEntity.getSettleId()));
        settleEntity.setTotalSettlePaymentTaxMny(settlePaymentEntity.getTotalSettlePaymentTaxMny());
        settleEntity.setTotalSettlePaymentMny(settlePaymentEntity.getTotalSettlePaymentMny());
        this.settleService.saveOrUpdate((Object)settleEntity, false);
        this.logger.info("\u7ed3\u7b97\u652f\u4ed8\u6bd4\u4f8b\u63a8\u9001\u7ed3\u7b97\u6c60\u5bf9\u8c61settleEntity-{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity)));
        String msg = this.settleService.pushSettleToPool((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u8282\u70b9\u7ed3\u7b97\u5355-\u66f4\u65b0\u7d2f\u8ba1\u7ed3\u7b97\u652f\u4ed8\u91d1\u989d-\u3010{}\u3011\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity)), (Object)msg);
        }
        return CommonResponse.success((String)"\u7ed3\u7b97\u652f\u4ed8\u6bd4\u4f8b\u786e\u8ba4\u5355\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        SettlePaymentEntity settlePaymentEntity = (SettlePaymentEntity)((Object)this.service.selectById(billId));
        QueryWrapper listQueryOrderByTime = new QueryWrapper();
        listQueryOrderByTime.eq((Object)"settle_id", (Object)settlePaymentEntity.getSettleId());
        listQueryOrderByTime.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQueryOrderByTime.orderByDesc((Object)"create_time");
        List listOrderByTime = this.service.list((Wrapper)listQueryOrderByTime);
        if (CollectionUtils.isNotEmpty((Collection)listOrderByTime) && null != listOrderByTime.get(0) && !((SettlePaymentEntity)((Object)listOrderByTime.get(0))).getId().equals(billId)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6700\u65b0\u7684\u652f\u4ed8\u6bd4\u4f8b\u786e\u8ba4\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        if (settlePaymentEntity != null) {
            settlePaymentEntity.setEffectiveDate(null);
            settlePaymentEntity.setCommitDate(null);
            settlePaymentEntity.setCommitUserCode(null);
            settlePaymentEntity.setCommitUserName(null);
        }
        this.service.saveOrUpdate((Object)settlePaymentEntity, false);
        SettleEntity settleEntity = (SettleEntity)((Object)this.settleService.selectById(settlePaymentEntity.getSettleId()));
        settleEntity.setTotalSettlePaymentTaxMny(settlePaymentEntity.getLastSettlePaymentTaxMny());
        settleEntity.setTotalSettlePaymentMny(settlePaymentEntity.getLastSettlePaymentMny());
        this.settleService.saveOrUpdate((Object)settleEntity, false);
        String msg = this.settleService.pushSettleToPool((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u8282\u70b9\u7ed3\u7b97\u5355-\u66f4\u65b0\u7d2f\u8ba1\u7ed3\u7b97\u652f\u4ed8\u91d1\u989d-\u3010{}\u3011\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity)), (Object)msg);
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

