CREATE TABLE `ejc_prosub_settle_payment`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '创建者账号',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建时间',
  `create_time` datetime(0) DEFAULT NULL COMMENT '修改者账号',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) DEFAULT NULL COMMENT '版本号',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单据编码',
  `bill_state` tinyint(4) DEFAULT NULL COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
  `settle_type` tinyint(4) DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `commit_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '提交人账号',
  `commit_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT ' 提交人名称',
  `commit_date` datetime(0) DEFAULT NULL COMMENT '提交日期',
  `effective_date` datetime(0) DEFAULT NULL COMMENT ' 生效日期',
  `settle_id` bigint(20) DEFAULT NULL COMMENT '节点结算主表ID',
  `settle_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '节点结算编码',
  `settle_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '节点结算名称',
  `settle_date` date DEFAULT NULL COMMENT '结算日期：默认显示当天,必须大于该合同的最近一次生效的结算日期（含过程结算、节点结算）；',
  `bill_date` date DEFAULT NULL COMMENT '单据日期',
  `contract_id` bigint(20) DEFAULT NULL COMMENT ' 合同id',
  `contract_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '合同名称',
  `contract_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `org_id` bigint(20) DEFAULT NULL COMMENT '项目部id',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目部编码',
  `org_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '组织名称',
  `parent_org_id` bigint(20) DEFAULT NULL COMMENT '项目部所属组织id',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目部所属组织编码',
  `parent_org_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目部所属组织名称',
  `supplement_flag` tinyint(4) DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
  `project_id` bigint(20) DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目名称',
  `project_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目编号',
  `supplier_id` bigint(20) DEFAULT NULL COMMENT '乙方id',
  `supplier_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '乙方名称',
  `payment_ratio_num` tinyint(4) DEFAULT NULL COMMENT '确认支付比例次数',
  `employee_id` bigint(20) DEFAULT NULL COMMENT '经办人id',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '经办人名称',
  `department_id` bigint(20) DEFAULT NULL COMMENT '经办部门id',
  `department_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT ' 经办部门名称',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注 非必填，0-300字',
  `settle_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额',
  `settle_mny` decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额(无税)',
  `last_settle_payment_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT ' 不含本期累计结算支付金额',
  `last_settle_payment_mny` decimal(28, 8) DEFAULT NULL COMMENT '不含本期累计结算支付金额(无税)',
  `settle_payment_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '本次结算支付金额',
  `settle_payment_mny` decimal(28, 8) DEFAULT NULL COMMENT '本次结算支付金额(无税)',
  `total_settle_payment_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT ' 累计结算支付金额',
  `total_settle_payment_mny` decimal(28, 8) DEFAULT NULL COMMENT '累计结算支付金额(无税)',
  `total_detail_settle_payment_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '清单中本期结算支付金额之和（含税）',
  `total_detail_settle_payment_mny` decimal(28, 8) DEFAULT NULL COMMENT '清单中本期结算支付金额之和',
  `picking_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '领料扣款金额',
  `picking_mny` decimal(28, 8) DEFAULT NULL COMMENT '领料扣款金额(无税)',
  `oddjob_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '零工金额金额',
  `oddjob_mny` decimal(28, 8) DEFAULT NULL COMMENT '零工金额金额(无税)',
  `deduct_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '奖罚扣款单金额',
  `deduct_mny` decimal(28, 8) DEFAULT NULL COMMENT '奖罚扣款单金额(无税)',
  `other_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '其他金额',
  `other_mny` decimal(28, 8) DEFAULT NULL COMMENT '其他金额(无税)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '节点结算支付比例确认单主表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_settle_payment_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `create_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `update_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者名称',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) DEFAULT NULL COMMENT '版本锁',
  `settle_type` tinyint(4) DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `settle_date` date DEFAULT NULL COMMENT '结算日期',
  `source_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '来源:合同，分包计量',
  `settle_payment_id` bigint(20) DEFAULT NULL COMMENT '节点结算支付比例确认单id（父id）',
  `source_settle_id` bigint(20) DEFAULT NULL COMMENT '来源结算单id',
  `source_settle_detail_id` bigint(20) DEFAULT NULL COMMENT '来源子表id',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '清单名称',
  `detail_measurement_rules` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '工作计量规则',
  `detail_work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '工作内容',
  `detail_unit` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单位',
  `detail_num` decimal(28, 8) DEFAULT NULL COMMENT '合同量',
  `settle_num` decimal(28, 8) DEFAULT NULL COMMENT '本期结算量：=累计节点结算量—过程累计结算量',
  `detail_tax_price` decimal(28, 8) DEFAULT NULL COMMENT '综合单价(含税)',
  `detail_price` decimal(28, 8) DEFAULT NULL COMMENT '综合单价(无税)',
  `detail_tax_rate` decimal(28, 8) DEFAULT NULL COMMENT '税率',
  `settle_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额',
  `settle_mny` decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额(无税)',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '树形-父id',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '树形-序号',
  `detail_last_settle_payment_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT ' 不含本期累计结算支付金额',
  `detail_last_settle_payment_mny` decimal(28, 8) DEFAULT NULL COMMENT ' 不含本期累计结算支付金额（无税）',
  `detail_last_settle_payment_ratio` decimal(28, 8) DEFAULT NULL COMMENT '不含本期累计结算支付比例',
  `detail_settle_payment_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '本次结算支付金额',
  `detail_settle_payment_mny` decimal(28, 8) DEFAULT NULL COMMENT '本次结算支付金额（无税）',
  `detail_settle_payment_ratio` decimal(28, 8) DEFAULT NULL COMMENT '本次结算支付比例',
  `detail_total_settle_payment_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT ' 累计结算支付金额',
  `detail_total_settle_payment_mny` decimal(28, 8) DEFAULT NULL COMMENT ' 累计结算支付金额（无税）',
  `detail_total_settle_payment_ratio` decimal(28, 8) DEFAULT NULL COMMENT '累计结算支付比例',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '节点结算支付比例确认单-分包清单子表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_settle_payment_deduct`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) DEFAULT NULL COMMENT '乐观锁',
  `use_flag` tinyint(4) DEFAULT NULL COMMENT '是否引用过,否-0，是-1',
  `settle_type` tinyint(4) DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `settle_date` date DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) DEFAULT NULL COMMENT '奖罚扣款单id',
  `source_bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单据单号',
  `reward_deduction_type` tinyint(4) DEFAULT NULL COMMENT '单据类型:默认奖励,奖励-0、扣款-1、罚款-2',
  `deduct_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '金额',
  `deduct_mny` decimal(28, 8) DEFAULT NULL COMMENT '金额(无税)',
  `deduct_tax` decimal(28, 8) DEFAULT NULL COMMENT '税额',
  `deduct_tax_rate` decimal(28, 8) DEFAULT NULL COMMENT '税率',
  `input_cost_flag` tinyint(4) DEFAULT NULL COMMENT '是否入成本,否-0，是-1',
  `happen_date` date DEFAULT NULL COMMENT '发生日期',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '非必填，0-30字',
  `settle_payment_id` bigint(20) DEFAULT NULL COMMENT '节点结算支付比例确认单id（父id）',
  `source_settle_id` bigint(20) DEFAULT NULL COMMENT '来源结算单id',
  `source_settle_deduct_id` bigint(20) DEFAULT NULL COMMENT '来源结算单子表id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '节点结算支付比例确认单-扣款结算子表' ROW_FORMAT = Dynamic;


CREATE TABLE `ejc_prosub_settle_payment_oddjob`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) DEFAULT NULL COMMENT '乐观锁',
  `settle_type` tinyint(4) DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `settle_date` date DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) DEFAULT NULL COMMENT '零工id',
  `source_bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单据单号',
  `oddjob_type` tinyint(4) DEFAULT NULL COMMENT '类别 0.零工登记,1.零工转扣',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注 默认为空，非必填，0-30字',
  `oddjob_mny` decimal(28, 8) DEFAULT NULL COMMENT '金额(无税)',
  `oddjob_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '金额',
  `oddjob_tax` decimal(28, 8) DEFAULT NULL COMMENT '税额',
  `oddjob_date` datetime(0) DEFAULT NULL COMMENT '用工日期',
  `use_work_detail` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '用工内容',
  `settle_payment_id` bigint(20) DEFAULT NULL COMMENT '节点结算支付比例确认单id（父id）',
  `source_settle_id` bigint(20) DEFAULT NULL COMMENT '来源结算单id',
  `source_settle_oddjob_id` bigint(20) DEFAULT NULL COMMENT '来源结算单子表id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '节点结算支付比例确认单-零工登记子表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_settle_payment_other`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) DEFAULT NULL COMMENT '乐观锁',
  `settle_type` tinyint(4) DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `settle_date` date DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) DEFAULT NULL COMMENT '其他费用id',
  `cost_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '费用名称',
  `cost_tax_price` decimal(28, 8) DEFAULT NULL COMMENT '单价',
  `cost_price` decimal(28, 8) DEFAULT NULL COMMENT '单价（无税）',
  `cost_tax_rate` decimal(28, 8) DEFAULT NULL COMMENT '税率',
  `cost_num` decimal(28, 8) DEFAULT NULL COMMENT '合同量',
  `num` decimal(28, 8) DEFAULT NULL COMMENT '本期结算量',
  `tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额，本期结算金额=本期结算量*单价',
  `mny` decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额(无税)',
  `tax` decimal(28, 8) DEFAULT NULL COMMENT '本期结算税额',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `settle_payment_id` bigint(20) DEFAULT NULL COMMENT '节点结算支付比例确认单id（父id）',
  `source_settle_id` bigint(20) DEFAULT NULL COMMENT '来源结算单id',
  `source_settle_other_id` bigint(20) DEFAULT NULL COMMENT '来源结算单子表id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '节点结算支付比例确认单-其他费用子表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_settle_payment_picking`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) DEFAULT NULL COMMENT '乐观锁',
  `settle_type` tinyint(4) DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `settle_date` date DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) DEFAULT NULL COMMENT '领料结算id',
  `source_bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单据单号',
  `picking_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '领料扣款金额',
  `picking_mny` decimal(28, 8) DEFAULT NULL COMMENT '领料扣款金额(无税)',
  `picking_tax` decimal(28, 8) DEFAULT NULL COMMENT '领料扣款金额税额',
  `picking_date` datetime(0) DEFAULT NULL COMMENT '领料结算日期',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注 默认为空，非必填，0-30字',
  `settle_payment_id` bigint(20) DEFAULT NULL COMMENT '节点结算支付比例确认单id（父id）',
  `source_settle_id` bigint(20) DEFAULT NULL COMMENT '来源结算单id',
  `source_settle_picking_id` bigint(20) DEFAULT NULL COMMENT '来源结算单子表id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '节点结算支付比例确认单-领料结算子表' ROW_FORMAT = Dynamic;