package com.ejianc.business.pro.supplier.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/***
 *合同类型和供应商对应关系
 *
 */
public enum SupplyTypeEnum {
    周转材合同("rmat", "周转材合同","material"),
    专业分包合同("proSub", "专业分包合同","major"),
    劳务分包合同("laborSub", "劳务分包合同","labor"),
    物资采购合同("contractMaterial", "物资采购合同","material"),
    其他收入合同("otherIn", "其他收入合同","other"),
    设备租赁("equipmentRent", "设备租赁","equipment"),
    设备采购("equipmentPurchase", "设备采购","equipment"),
    临时设备("tempEquip", "临时设备","equipment"),
    混凝土("contractConcrete", "混凝土合同","material");
    private String typeCode;
    private String typeName;
    private String supplyType;
    private static Map<String, SupplyTypeEnum> enumMap = new HashMap();

    private SupplyTypeEnum(String typeCode, String typeName,String supplyType) {
        this.typeCode = typeCode;
        this.typeName = typeName;
        this.supplyType=supplyType;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }

    public static Map<String, SupplyTypeEnum> getEnumMap() {
        return enumMap;
    }

    public static void setEnumMap(Map<String, SupplyTypeEnum> enumMap) {
        SupplyTypeEnum.enumMap = enumMap;
    }

    public static SupplyTypeEnum getByCode(String code) {
        return (SupplyTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map)EnumSet.allOf(SupplyTypeEnum.class).stream().collect(Collectors.toMap(SupplyTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
