package com.ejianc.business.pro.supplier.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商准入邀请表
 *
 * @author generator
 */
public class InviteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 单据编号
    private String name; // 供应商名称、个人姓名、分包负责人名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String applyOrgName; // 申请合作单位
    private Long applyOrgId; // 申请合作单位id
    private String applyPerson; // 申请人
    private Long applyPersonId; // 申请人id
    private Date applyTime; // 申请时间
    private String handlePerson; // 处理人
    private Long handlePersonId; // 处理人id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleTime; // 处理时间
    private String canInNum; // 准入编号
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    private String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
    private String supplyTypeName; // 供方类别名称
    private String personal; // 个人：p，企业：e，分包负责人：s
    private String materialContentId; // 物资供货内容id
    private String materialContent; // 物资供货内容名称
    private String materialMemo; // 物资补充描述
    private String equipmentContentId; // 设备供货内容id
    private String equipmentContent; // 设备供货内容
    private String equipmentMemo; // 设备补充描述
    private String majorContentId; // 专业分包供货内容id
    private String majorContent; // 专业分包供货内容
    private String majorMemo; // 专业分包补充描述
    private String laborContentId; // 劳务分包供货内容id
    private String laborContent; // 劳务分包供货内容
    private String laborMemo; // 劳务分包补充描述
    private String subContentId; // 分包班组供货内容id
    private String subContent; // 分包班组供货内容
    private String subMemo; // 分包班组补充描述
    private String otherContentId; // 其他供货内容id
    private String otherContent; // 其他供货内容
    private String otherMemo; // 其他补充描述
    private String revolvMaterialContentId;//周转材供货内容id
    private String revolvMaterialContent;//周转材供货内容
    private String revolvMaterialMemo;//周转材补充描述
    private String consultContentId;//咨询供货内容id
    private String consultContent;//咨询供货内容
    private String consultMemo;//咨询补充描述
    private Long enterpriseNature; // 企业性质id
    private String enterpriseNatureName; // 企业性质名称
    private String taxpayerNum; // 纳税人识别号/身份证号
    private String legalPerson; // 法人代表/别名
    private String legalPhone; // 法人电话/联系电话
    private String area; // 所在地区
    private String areaName; // 所在地区名称
    private String address; // 公司地址
    private String businessRange; // 经营范围
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date timeOut; // 有效期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerDate; // 注册日期
    private BigDecimal registerMny; // 注册资金
    private BigDecimal turnover; // 年营业额

    private String mainBusinessCategory; // 主营类别
    private String distributerOrManufactor; // 厂家经销商
    private String taxpayerType;//纳税人类型
    private String billingAddress;//开票地址
    private String billingPhone;//开票电话
    private Long bankAccountId;//开票银行
    private String bankAccountName;//开票银行
    private String bankAccountCode;//开票银行账户
    private Long inviteId;//邀请供应商主键
    private String businessPerson;	//业务代表
    private String businessPhone;	//业务代表电话

    /** 分包负责人邀请使用字段 */
    private Long supplierId;//供应商id

    private List<BankVO> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    private List<CertsVO> certs = new ArrayList<>(); // 供应商准入---证书

    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }

    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }

    public String getMainBusinessCategory() {
        return mainBusinessCategory;
    }

    public void setMainBusinessCategory(String mainBusinessCategory) {
        this.mainBusinessCategory = mainBusinessCategory;
    }

    public String getDistributerOrManufactor() {
        return distributerOrManufactor;
    }

    public void setDistributerOrManufactor(String distributerOrManufactor) {
        this.distributerOrManufactor = distributerOrManufactor;
    }

    public String getTaxpayerType() {
        return taxpayerType;
    }

    public void setTaxpayerType(String taxpayerType) {
        this.taxpayerType = taxpayerType;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getBillingPhone() {
        return billingPhone;
    }

    public void setBillingPhone(String billingPhone) {
        this.billingPhone = billingPhone;
    }
    @ReferSerialTransfer(referCode="support-bank")
    public Long getBankAccountId() {
        return bankAccountId;
    }
    @ReferDeserialTransfer
    public void setBankAccountId(Long bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public String getBankAccountName() {
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public String getBankAccountCode() {
        return bankAccountCode;
    }

    public void setBankAccountCode(String bankAccountCode) {
        this.bankAccountCode = bankAccountCode;
    }

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public List<BankVO> getBanks() {
        return banks;
    }

    public void setBanks(List<BankVO> banks) {
        this.banks = banks;
    }

    public List<CertsVO> getCerts() {
        return certs;
    }

    public void setCerts(List<CertsVO> certs) {
        this.certs = certs;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    @ReferDeserialTransfer
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }

    public Long getApplyPersonId() {
        return applyPersonId;
    }

    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getHandlePerson() {
        return handlePerson;
    }

    public void setHandlePerson(String handlePerson) {
        this.handlePerson = handlePerson;
    }

    public Long getHandlePersonId() {
        return handlePersonId;
    }

    public void setHandlePersonId(Long handlePersonId) {
        this.handlePersonId = handlePersonId;
    }

    public Date getHandleTime() {
        return handleTime;
    }

    public void setHandleTime(Date handleTime) {
        this.handleTime = handleTime;
    }

    public String getCanInNum() {
        return canInNum;
    }

    public void setCanInNum(String canInNum) {
        this.canInNum = canInNum;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }

    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }

    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getRevolvMaterialContentId() {
        return revolvMaterialContentId;
    }
    @ReferDeserialTransfer
    public void setRevolvMaterialContentId(String revolvMaterialContentId) {
        this.revolvMaterialContentId = revolvMaterialContentId;
    }

    public String getRevolvMaterialContent() {
        return revolvMaterialContent;
    }

    public void setRevolvMaterialContent(String revolvMaterialContent) {
        this.revolvMaterialContent = revolvMaterialContent;
    }

    public String getRevolvMaterialMemo() {
        return revolvMaterialMemo;
    }

    public void setRevolvMaterialMemo(String revolvMaterialMemo) {
        this.revolvMaterialMemo = revolvMaterialMemo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getConsultContentId() {
        return consultContentId;
    }
    @ReferDeserialTransfer
    public void setConsultContentId(String consultContentId) {
        this.consultContentId = consultContentId;
    }

    public String getConsultContent() {
        return consultContent;
    }

    public void setConsultContent(String consultContent) {
        this.consultContent = consultContent;
    }

    public String getConsultMemo() {
        return consultMemo;
    }

    public void setConsultMemo(String consultMemo) {
        this.consultMemo = consultMemo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getMaterialContentId() {
        return materialContentId;
    }

    @ReferDeserialTransfer
    public void setMaterialContentId(String materialContentId) {
        this.materialContentId = materialContentId;
    }

    public String getMaterialContent() {
        return materialContent;
    }

    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }

    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getEquipmentContentId() {
        return equipmentContentId;
    }

    @ReferDeserialTransfer
    public void setEquipmentContentId(String equipmentContentId) {
        this.equipmentContentId = equipmentContentId;
    }

    public String getEquipmentContent() {
        return equipmentContent;
    }

    public void setEquipmentContent(String equipmentContent) {
        this.equipmentContent = equipmentContent;
    }

    public String getEquipmentMemo() {
        return equipmentMemo;
    }

    public void setEquipmentMemo(String equipmentMemo) {
        this.equipmentMemo = equipmentMemo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getMajorContentId() {
        return majorContentId;
    }

    @ReferDeserialTransfer
    public void setMajorContentId(String majorContentId) {
        this.majorContentId = majorContentId;
    }

    public String getMajorContent() {
        return majorContent;
    }

    public void setMajorContent(String majorContent) {
        this.majorContent = majorContent;
    }

    public String getMajorMemo() {
        return majorMemo;
    }

    public void setMajorMemo(String majorMemo) {
        this.majorMemo = majorMemo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getLaborContentId() {
        return laborContentId;
    }

    @ReferDeserialTransfer
    public void setLaborContentId(String laborContentId) {
        this.laborContentId = laborContentId;
    }

    public String getLaborContent() {
        return laborContent;
    }

    public void setLaborContent(String laborContent) {
        this.laborContent = laborContent;
    }

    public String getLaborMemo() {
        return laborMemo;
    }

    public void setLaborMemo(String laborMemo) {
        this.laborMemo = laborMemo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getSubContentId() {
        return subContentId;
    }

    @ReferDeserialTransfer
    public void setSubContentId(String subContentId) {
        this.subContentId = subContentId;
    }

    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public String getSubMemo() {
        return subMemo;
    }

    public void setSubMemo(String subMemo) {
        this.subMemo = subMemo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getOtherContentId() {
        return otherContentId;
    }

    @ReferDeserialTransfer
    public void setOtherContentId(String otherContentId) {
        this.otherContentId = otherContentId;
    }

    public String getOtherContent() {
        return otherContent;
    }

    public void setOtherContent(String otherContent) {
        this.otherContent = otherContent;
    }

    public String getOtherMemo() {
        return otherMemo;
    }

    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    @ReferDeserialTransfer
    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }

    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }

    public String getTaxpayerNum() {
        return taxpayerNum;
    }

    public void setTaxpayerNum(String taxpayerNum) {
        this.taxpayerNum = taxpayerNum;
    }

    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }

    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getBusinessRange() {
        return businessRange;
    }

    public void setBusinessRange(String businessRange) {
        this.businessRange = businessRange;
    }

    public Date getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(Date timeOut) {
        this.timeOut = timeOut;
    }

    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }

    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }

    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
