/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.vo.util;

import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public class SupplyQueryTypeUtil {
    private static List<String> RULE_A_MATERIALEQUIPMENT = Arrays.asList(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode(), ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode(), ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode(), ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
    private static List<String> RULE_A_SUB = Arrays.asList(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
    private static List<String> RULE_B_MATERIAL = Arrays.asList(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode(), ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c.getTypeCode());
    private static List<String> RULE_B_EQUIPMENT = Arrays.asList(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode(), ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode(), ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
    private static List<String> RULE_B_PRO_SUB = Arrays.asList(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
    private static List<String> RULE_B_LAB_SUB = Arrays.asList(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
    private static List<String> OTHER = Arrays.asList(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());

    public static String get(String ruleName, String contractType) {
        if ("RULE_A".equals(ruleName)) {
            if (RULE_A_MATERIALEQUIPMENT.contains(contractType)) {
                return "materialEquipment";
            }
            if (RULE_A_SUB.contains(contractType)) {
                return "sub";
            }
            if (OTHER.contains(contractType)) {
                return "other";
            }
            return "";
        }
        if (RULE_B_MATERIAL.contains(contractType)) {
            return "material";
        }
        if (RULE_B_EQUIPMENT.contains(contractType)) {
            return "equipment";
        }
        if (RULE_B_PRO_SUB.contains(contractType)) {
            return "proSub";
        }
        if (RULE_B_LAB_SUB.contains(contractType)) {
            return "laborSub";
        }
        if (OTHER.contains(contractType)) {
            return "other";
        }
        return "";
    }

    public static String getEName(String typeCode) {
        if (StringUtils.isEmpty((String)typeCode)) {
            return "";
        }
        if (RULE_B_MATERIAL.contains(typeCode)) {
            return "material";
        }
        if (RULE_B_EQUIPMENT.contains(typeCode)) {
            return "equipment";
        }
        if (RULE_B_PRO_SUB.contains(typeCode)) {
            return "major";
        }
        if (RULE_B_LAB_SUB.contains(typeCode)) {
            return "labor";
        }
        return "other";
    }

    public static String getName(String typeCode) {
        if (StringUtils.isEmpty((String)typeCode)) {
            return "";
        }
        if (RULE_B_MATERIAL.contains(typeCode)) {
            return "\u7269\u8d44";
        }
        if (RULE_B_EQUIPMENT.contains(typeCode)) {
            return "\u8bbe\u5907";
        }
        if (RULE_B_PRO_SUB.contains(typeCode)) {
            return "\u4e13\u4e1a\u5206\u5305";
        }
        if (RULE_B_LAB_SUB.contains(typeCode)) {
            return "\u52b3\u52a1\u5206\u5305";
        }
        return "\u5176\u4ed6";
    }

    public static void main(String[] args) {
        System.out.println(SupplyQueryTypeUtil.get("RULE_B", "contractMaterial"));
    }
}

