package com.ejianc.business.pro.supplier.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.vo.BrandReportVO;
import com.ejianc.business.pro.supplier.vo.CanInReportVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 供应商准入表
 * 
 * @author generator
 * 
 */
@Mapper
public interface CanInMapper extends BaseCrudMapper<CanInEntity> {
    List<BrandReportVO> queryBrandTypeList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper,@Param("supplierIds") List<Long> supplierIds);

    List<BrandReportVO> queryBrandList(@Param("supplierIds") List<Long> supplierIds);

    List<CanInReportVO> querySupplierList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper,@Param("brandId") Long brandId,@Param("supplierIds") List<Long> supplierIds);

}
